/*
 * Decompiled with CFR 0.152.
 */
package com.baloooouu.LizardmanShamanMinionAlert;

import com.baloooouu.LizardmanShamanMinionAlert.LizardmanShamanMinionAlertConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Preferences;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Lizardman Shaman Minion Alert")
public class LizardmanShamanMinionAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LizardmanShamanMinionAlertPlugin.class);
    private static final Integer SPAWN_ID = 6768;
    private static Boolean SPAWNS_EXIST_PREVIOUS_TICK = false;
    @Inject
    private Client client;
    @Inject
    private LizardmanShamanMinionAlertConfig config;

    protected void startUp() throws Exception {
        SPAWNS_EXIST_PREVIOUS_TICK = false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        SPAWNS_EXIST_PREVIOUS_TICK = false;
    }

    @Provides
    LizardmanShamanMinionAlertConfig provideConfig(ConfigManager configManager) {
        return (LizardmanShamanMinionAlertConfig)configManager.getConfig(LizardmanShamanMinionAlertConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        boolean spawnsExistCurrentTick = this.spawnCurrentlyExists();
        if (!SPAWNS_EXIST_PREVIOUS_TICK.booleanValue() && spawnsExistCurrentTick) {
            log.info("New Spawns detected.");
            this.playSound();
        }
        SPAWNS_EXIST_PREVIOUS_TICK = spawnsExistCurrentTick;
    }

    private boolean spawnCurrentlyExists() {
        NPC[] npcs = this.client.getCachedNPCs();
        return Arrays.stream(npcs).anyMatch(n -> this.validSpawn((NPC)n));
    }

    private boolean validSpawn(NPC npc) {
        if (npc == null) {
            return false;
        }
        if (npc.getId() != SPAWN_ID.intValue()) {
            return false;
        }
        WorldPoint spawnLocation = npc.getWorldLocation();
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        int distance = playerLocation.distanceTo(spawnLocation);
        return distance <= this.config.maxSpawnDistance();
    }

    private void playSound() {
        if (this.config.volume() <= 0) {
            return;
        }
        Preferences preferences = this.client.getPreferences();
        int preferredVolume = preferences.getSoundEffectVolume();
        preferences.setSoundEffectVolume(this.config.volume());
        this.client.playSoundEffect(this.config.soundEffect().getSoundEffectId(), this.config.volume());
        preferences.setSoundEffectVolume(preferredVolume);
    }
}

