/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights;

import com.WIZLights.Drops.ChambersOfXeric;
import com.WIZLights.Drops.TheatreOfBlood;
import com.WIZLights.Drops.ValuableDrops;
import com.WIZLights.UDP;
import com.WIZLights.WIZLights;
import com.WIZLights.WIZLightsConfig;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="WIZ Smart Lights", description="A plugin to control the WIZ Smart Lights")
public class WIZLightsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WIZLightsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private WIZLightsConfig config;
    @Inject
    private WIZLights wizLights;
    @Inject
    private ValuableDrops valuableDrops;
    @Inject
    private ChambersOfXeric cox;
    @Inject
    private UDP udp;
    @Inject
    private TheatreOfBlood tob;
    private List<String> lootNpcs;

    protected void startUp() throws Exception {
        this.tob.reset();
        this.lootNpcs = Collections.emptyList();
    }

    protected void shutDown() throws Exception {
        this.udp.closeSocket();
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        Collection items = npcLootReceived.getItems();
        if (!this.lootNpcs.isEmpty()) {
            for (String npcName : this.lootNpcs) {
                if (!WildcardMatcher.matches((String)npcName, (String)npc.getName())) continue;
                this.valuableDrops.processLoot(npc.getName(), items);
                return;
            }
        } else if (!this.tob.isInTob() && !this.cox.isInCox()) {
            this.valuableDrops.processLoot(npc.getName(), items);
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (lootReceived.getType() != LootRecordType.EVENT && lootReceived.getType() != LootRecordType.PICKPOCKET) {
            return;
        }
        if (!this.tob.isInTob() && !this.cox.isInCox()) {
            this.valuableDrops.processLoot(lootReceived.getName(), lootReceived.getItems());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message;
        this.valuableDrops.onChatMessage(event);
        if (this.cox.isInCox()) {
            this.cox.onChatMessage(event);
        }
        if ((message = Text.sanitize((String)Text.removeTags((String)event.getMessage()))).contains("Wiztest") && event.getName().contains(this.client.getLocalPlayer().getName())) {
            String[] msg = message.split(" ", 4);
            Color color = new Color(Integer.parseInt(msg[1]), Integer.parseInt(msg[2]), Integer.parseInt(msg[3]));
            this.wizLights.setAllLightsColor(color);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (this.tob.isInTob()) {
            this.tob.onGameObjectSpawned(event);
        }
    }

    @Provides
    WIZLightsConfig provideConfig(ConfigManager configManager) {
        return (WIZLightsConfig)configManager.getConfig(WIZLightsConfig.class);
    }
}

