/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights;

import com.WIZLights.ItemGroup;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="WIZLights")
public interface WIZLightsConfig
extends Config {
    @ConfigSection(name="Wiz Lights", description="IP address and port number of the lights", position=0, closedByDefault=false)
    public static final String wizLightSection = "wizLights";
    @ConfigSection(name="Lights Options", description="Several options for lights", position=1, closedByDefault=false)
    public static final String lightsOptionsSection = "lightsOptionsSection";
    @ConfigSection(name="Valuable drops", description="The color of the lights when receiving a valuable drop", position=2, closedByDefault=false)
    public static final String valuableDropsColorSection = "dropsColor";
    @ConfigSection(name="Chamber of Xeric", description="The color of the lights when receiving a drop at CoX", position=3, closedByDefault=false)
    public static final String coxDropsColorSection = "coxDropsColor";
    @ConfigSection(name="Theatre of Blood", description="The color of the lights when receiving a drop at Tob", position=4, closedByDefault=false)
    public static final String tobDropsColorSection = "tobDropsColor";

    @ConfigItem(keyName="wizLightIPAddresses", name="IP Address", description="IP addresses of the wiz lights, comma separated. Example:192.1.1.1, 192.1.1.2", section="wizLights")
    default public String wizLightIPAddresses() {
        return "";
    }

    @ConfigItem(keyName="wizLightPort", name="Port", description="Port of the wiz lights", section="wizLights")
    default public int wizLightPort() {
        return 38899;
    }

    @Units(value="s")
    @Range
    @ConfigItem(keyName="duration", name="Duration", description="Duration the lights stay recolored", position=0, section="lightsOptionsSection")
    default public int duration() {
        return 30;
    }

    @Units(value="%")
    @Range(max=100)
    @ConfigItem(keyName="brightness", name="Brightness", description="The brightness of the lights in percentage", position=1, section="lightsOptionsSection")
    default public int brightness() {
        return 100;
    }

    @ConfigItem(keyName="enableRecolorLowValue", name="Recolor low value loot", description="Enable recoloring the lights when Insane Value loot is received", section="dropsColor", position=0)
    default public boolean enableRecolorLowValue() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="lowValueColor", name="Low value items", description="Configures the color for low value items", section="dropsColor", position=1)
    default public Color lowValueColor() {
        return Color.decode("#66B2FF");
    }

    @ConfigItem(keyName="lowValuePrice", name="Low value price", description="Configures the start price for low value items", section="dropsColor", position=2)
    default public int lowValuePrice() {
        return 20000;
    }

    @ConfigItem(keyName="enableRecolorMediumValue", name="Recolor medium value loot", description="Enable recoloring the lights when Insane Value loot is received", section="dropsColor", position=3)
    default public boolean enableRecolorMediumValue() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="mediumValueColor", name="Medium value items", description="Configures the color for medium value items", section="dropsColor", position=4)
    default public Color mediumValueColor() {
        return Color.decode("#99FF99");
    }

    @ConfigItem(keyName="mediumValuePrice", name="Medium value price", description="Configures the start price for medium value items", section="dropsColor", position=5)
    default public int mediumValuePrice() {
        return 100000;
    }

    @ConfigItem(keyName="enableRecolorHighValue", name="Recolor high value loot", description="Enable recoloring the lights when Insane Value loot is received", section="dropsColor", position=6)
    default public boolean enableRecolorHighValue() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="highValueColor", name="High value items", description="Configures the color for high value items", section="dropsColor", position=7)
    default public Color highValueColor() {
        return Color.decode("#FF9600");
    }

    @ConfigItem(keyName="highValuePrice", name="High value price", description="Configures the start price for high value items", section="dropsColor", position=8)
    default public int highValuePrice() {
        return 1000000;
    }

    @ConfigItem(keyName="enableRecolorInsaneValue", name="Recolor insane value loot", description="Enable recoloring the lights when Insane Value loot is received", section="dropsColor", position=9)
    default public boolean enableRecolorInsaneValue() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="insaneValueColor", name="Insane value items", description="Configures the color for insane value items", section="dropsColor", position=10)
    default public Color insaneValueColor() {
        return Color.decode("#FF66B2");
    }

    @ConfigItem(keyName="insaneValuePrice", name="Insane value price", description="Configures the start price for insane value items", section="dropsColor", position=11)
    default public int insaneValuePrice() {
        return 10000000;
    }

    @ConfigItem(keyName="enableCoxStandardLoot", name="Recolor standard loot", description="Enable recoloring the light when no unique is obtained", position=0, section="coxDropsColor")
    default public boolean enableCoxStandardLoot() {
        return false;
    }

    @ConfigItem(keyName="coxStandardLootColor", name="Standard loot", description="Color of light when no unique item is obtained", position=1, section="coxDropsColor")
    default public Color coxStandardLootColor() {
        return Color.WHITE;
    }

    @ConfigItem(keyName="enableDust", name="Recolor dust", description="Enable recoloring the light when metamorphic dust is obtained", position=2, section="coxDropsColor")
    default public boolean enableDust() {
        return true;
    }

    @ConfigItem(keyName="dust", name="Metamorphic Dust", description="Color of light when metamorphic dust is obtained", position=3, section="coxDropsColor")
    default public Color dust() {
        return Color.CYAN;
    }

    @ConfigItem(keyName="enableKit", name="Recolor Twisted kit", description="Enable recoloring the light when a twisted kit is obtained", position=4, section="coxDropsColor")
    default public boolean enableKit() {
        return true;
    }

    @ConfigItem(keyName="twistedKit", name="Twisted Kit", description="Color of light when a twisted kit is obtained", position=5, section="coxDropsColor")
    default public Color twistedKit() {
        return Color.GREEN;
    }

    @ConfigItem(keyName="enableGroupOne", name="Recolor group 1", description="Enable recoloring the light when a unique from group 1 is obtained", position=6, section="coxDropsColor")
    default public boolean enableGroupOne() {
        return true;
    }

    @ConfigItem(keyName="groupOneColor", name="Group 1", description="Color of the light when an item from group 1 is obtained", position=7, section="coxDropsColor")
    default public Color groupOneColor() {
        return Color.RED;
    }

    @ConfigItem(keyName="enableGroupTwo", name="Recolor group 2", description="Enable recoloring the light when a unique from group 2 is obtained", position=8, section="coxDropsColor")
    default public boolean enableGroupTwo() {
        return true;
    }

    @ConfigItem(keyName="groupTwoColor", name="Group 2", description="Color of the light when an item from group 2 is obtained", position=9, section="coxDropsColor")
    default public Color groupTwoColor() {
        return Color.BLUE;
    }

    @ConfigItem(keyName="enableGroupThree", name="Recolor group 3", description="Enable recoloring the light when a unique from group 3 is obtained", position=10, section="coxDropsColor")
    default public boolean enableGroupThree() {
        return true;
    }

    @ConfigItem(keyName="groupThreeColor", name="Group 3", description="Color of the light when an item from group 3 is obtained", position=11, section="coxDropsColor")
    default public Color groupThreeColor() {
        return Color.YELLOW;
    }

    @ConfigItem(keyName="enableGroupFour", name="Recolor group 4", description="Enable recoloring the light when a unique from group 4 is obtained", position=12, section="coxDropsColor")
    default public boolean enableGroupFour() {
        return true;
    }

    @ConfigItem(keyName="groupFourColor", name="Group 4", description="Color of the light when an item from group 4 is obtained", position=13, section="coxDropsColor")
    default public Color groupFourColor() {
        return new Color(120, 86, 46);
    }

    @ConfigItem(keyName="groupTwistedBow", name="Twisted bow", description="Group color to use when this item is obtained", position=14, section="coxDropsColor")
    default public ItemGroup groupTwistedBow() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupKodai", name="Kodai insignia", description="Group color to use when this item is obtained", position=15, section="coxDropsColor")
    default public ItemGroup groupKodai() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupElderMaul", name="Elder maul", description="Group color to use when this item is obtained", position=16, section="coxDropsColor")
    default public ItemGroup groupElderMaul() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupClaws", name="Dragon claws", description="Group color to use when this item is obtained", position=17, section="coxDropsColor")
    default public ItemGroup groupClaws() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralHat", name="Ancestral hat", description="Group color to use when this item is obtained", position=18, section="coxDropsColor")
    default public ItemGroup groupAncestralHat() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralTop", name="Ancestral robe top", description="Group color to use when this item is obtained", position=19, section="coxDropsColor")
    default public ItemGroup groupAncestralTop() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralBottom", name="Ancestral robe bottom", description="Group color to use when this item is obtained", position=20, section="coxDropsColor")
    default public ItemGroup groupAncestralBottom() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDinhs", name="Dinh's bulwark", description="Group color to use when this item is obtained", position=21, section="coxDropsColor")
    default public ItemGroup groupDinhs() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDHCB", name="Dragon hunter crossbow", description="Group color to use when this item is obtained", position=22, section="coxDropsColor")
    default public ItemGroup groupDHCB() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupBuckler", name="Twisted buckler", description="Group color to use when this item is obtained", position=23, section="coxDropsColor")
    default public ItemGroup groupBuckler() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupArcane", name="Arcane prayer scroll", description="Group color to use when this item is obtained", position=24, section="coxDropsColor")
    default public ItemGroup groupArcane() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDex", name="Dexterous prayer scroll", description="Group color to use when this item is obtained", position=25, section="coxDropsColor")
    default public ItemGroup groupDex() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="enableTobStandardLoot", name="Recolor standard loot", description="Enable recoloring the lights when no unique item is obtained", position=0, section="tobDropsColor")
    default public boolean enableTobStandardLoot() {
        return false;
    }

    @ConfigItem(keyName="tobStandardLootColor", name="Standard loot", description="Color of the lights when no unique item is obtained", position=1, section="tobDropsColor")
    default public Color tobStandardLootColor() {
        return Color.WHITE;
    }

    @ConfigItem(keyName="enableRecolorTobYour", name="Recolor your purple", description="Enable recoloring the lights when you receive a unique", position=2, section="tobDropsColor")
    default public boolean enableRecolorTobYour() {
        return true;
    }

    @ConfigItem(keyName="yourPurpleColor", name="Your purple", description="Color of the lights when you receive a unique", position=3, section="tobDropsColor")
    default public Color yourPurpleColor() {
        return Color.MAGENTA;
    }

    @ConfigItem(keyName="enableRecolorTobOther", name="Recolor other purple", description="Enable recoloring the lights when someone else receives a unique", position=4, section="tobDropsColor")
    default public boolean enableRecolorTobOther() {
        return true;
    }

    @ConfigItem(keyName="otherPurpleColor", name="Other purple", description="Color of the lights when someone else receives a unique", position=5, section="tobDropsColor")
    default public Color otherPurpleColor() {
        return Color.RED;
    }
}

