/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights;

import com.WIZLights.UDP;
import com.WIZLights.WIZLightsConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WIZLights {
    private static final Logger log = LoggerFactory.getLogger(WIZLights.class);
    @Inject
    private WIZLightsConfig config;
    @Inject
    private UDP udp;
    @Inject
    private ScheduledExecutorService executorService;
    private List<String> previousStates = new ArrayList<String>();

    private void setAllLightsColorExecute(Color color) {
        log.debug("Setting lights to " + color.toString());
        List ipAddresses = Text.fromCSV((String)this.config.wizLightIPAddresses());
        String getMessage = this.udp.messageBuilder(UDP.Method.GETPILOT);
        for (String ip : ipAddresses) {
            this.udp.sendMessage(getMessage, ip, this.config.wizLightPort());
            String responseMessage = this.udp.receiveMessage();
            this.previousStates.add(this.udp.convertGetToSetPilot(responseMessage));
        }
        String setMessage = this.udp.messageBuilder(UDP.Method.SETPILOT, this.getParamsFromColor(color));
        for (String ip : ipAddresses) {
            this.udp.sendMessage(setMessage, ip, this.config.wizLightPort());
            String responseMessage = this.udp.receiveMessage();
            log.debug("Response message: " + responseMessage);
        }
        this.executorService.schedule(this::restoreLights, (long)this.config.duration(), TimeUnit.SECONDS);
    }

    public void setAllLightsColor(Color color) {
        this.executorService.execute(() -> this.setAllLightsColorExecute(color));
    }

    private void restoreLights() {
        log.debug("Restoring lights");
        List ipAddresses = Text.fromCSV((String)this.config.wizLightIPAddresses());
        for (int i = 0; i < ipAddresses.size(); ++i) {
            String setMessage = this.previousStates.get(i);
            this.udp.sendMessage(setMessage, (String)ipAddresses.get(i), this.config.wizLightPort());
            String responseMessage = this.udp.receiveMessage();
            log.debug("Response message: " + responseMessage);
        }
        this.previousStates.clear();
    }

    private Map<String, Integer> getParamsFromColor(Color color) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("r", color.getRed());
        params.put("g", color.getGreen());
        params.put("b", color.getBlue());
        params.put("dimming", this.config.brightness());
        return params;
    }
}

