/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDP {
    private static final Logger log = LoggerFactory.getLogger(UDP.class);
    private DatagramSocket socket = new DatagramSocket();

    public String messageBuilder(Method method) {
        return "{\"method\":\"" + method.getMethod() + "\"}";
    }

    public String messageBuilder(Method method, Map<String, Integer> params) {
        StringBuilder messageString = new StringBuilder("{");
        messageString.append("\"method\":\"").append(method.getMethod()).append("\",");
        messageString.append("\"params\":{");
        for (String key : params.keySet()) {
            messageString.append("\"").append(key).append("\":").append(params.get(key).toString()).append(",");
        }
        messageString.delete(messageString.length() - 1, messageString.length()).append("}}");
        return messageString.toString();
    }

    public void sendMessage(String msg, String ipAddress, int port) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        byte[] buffer = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, port);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String receiveMessage() {
        byte[] buffer = new byte[1000];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            this.socket.setSoTimeout(2000);
            this.socket.receive(packet);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return "";
        }
        return new String(packet.getData(), 0, packet.getLength());
    }

    public String convertGetToSetPilot(String message) {
        return message.replace("result", "params").replace(Method.GETPILOT.getMethod(), Method.SETPILOT.getMethod()).replace("\"sceneId\":0,", "");
    }

    public void closeSocket() {
        this.socket.close();
    }

    public static enum Method {
        GETPILOT("getPilot"),
        SETPILOT("setPilot");

        private final String method;

        public String getMethod() {
            return this.method;
        }

        private Method(String method) {
            this.method = method;
        }
    }
}

