/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights.Drops;

import com.WIZLights.WIZLights;
import com.WIZLights.WIZLightsConfig;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuableDrops {
    private static final Logger log = LoggerFactory.getLogger(ValuableDrops.class);
    @Inject
    private WIZLightsConfig config;
    @Inject
    private WIZLights wizLights;
    @Inject
    private ItemManager itemManager;

    public void onChatMessage(ChatMessage event) {
        String message = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (message.contains("Your treasure is worth around")) {
            String clueValue = message.replaceAll("\\D+", "");
            log.debug("Clue Value: " + clueValue);
            long valueOfClue = Integer.parseInt(clueValue);
            this.matchLootValue(valueOfClue);
        }
    }

    public void processLoot(String name, Collection<ItemStack> items) {
        long totalValue = 0L;
        for (ItemStack item : ValuableDrops.stack(items)) {
            int itemId = item.getId();
            int qty = item.getQuantity();
            int price = this.itemManager.getItemPrice(itemId);
            long total = (long)price * (long)qty;
            totalValue += total;
        }
        log.debug("Loot Received from " + name + ": " + totalValue);
        this.matchLootValue(totalValue);
    }

    private void matchLootValue(long value) {
        if ((long)this.config.lowValuePrice() <= value && (long)this.config.mediumValuePrice() > value && this.config.enableRecolorLowValue()) {
            this.wizLights.setAllLightsColor(this.config.lowValueColor());
        } else if ((long)this.config.mediumValuePrice() <= value && (long)this.config.highValuePrice() > value && this.config.enableRecolorMediumValue()) {
            this.wizLights.setAllLightsColor(this.config.mediumValueColor());
        } else if ((long)this.config.highValuePrice() <= value && (long)this.config.insaneValuePrice() > value && this.config.enableRecolorHighValue()) {
            this.wizLights.setAllLightsColor(this.config.highValueColor());
        } else if ((long)this.config.insaneValuePrice() <= value && this.config.enableRecolorInsaneValue()) {
            this.wizLights.setAllLightsColor(this.config.insaneValueColor());
        }
    }

    private static Collection<ItemStack> stack(Collection<ItemStack> items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            int quantity = 0;
            for (ItemStack i : list) {
                if (i.getId() != item.getId()) continue;
                quantity = i.getQuantity();
                list.remove(i);
                break;
            }
            if (quantity > 0) {
                list.add(new ItemStack(item.getId(), item.getQuantity() + quantity, item.getLocation()));
                continue;
            }
            list.add(item);
        }
        return list;
    }
}

