/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights.Drops;

import com.WIZLights.WIZLights;
import com.WIZLights.WIZLightsConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheatreOfBlood {
    private static final Logger log = LoggerFactory.getLogger(TheatreOfBlood.class);
    @Inject
    private Client client;
    @Inject
    private WIZLightsConfig config;
    @Inject
    private WIZLights wizLights;
    private static final List<Integer> rewardChestIds = Arrays.asList(33086, 33087, 33088, 33089, 33090);
    private static final int yourPurpleChestId = 32993;
    private static final int otherPurpleChestId = 32991;
    public static final int TOB_RAIDERS_VARP = 330;
    public static final int TOB_MAX_SIZE = 5;
    private int teamSize = 0;
    private int chestCount = 0;
    private boolean uniqueReceived = false;

    public void onGameObjectSpawned(GameObjectSpawned event) {
        int objId = event.getGameObject().getId();
        if (rewardChestIds.contains(objId)) {
            ++this.chestCount;
            int impostorId = this.client.getObjectDefinition(objId).getImpostor().getId();
            if (impostorId == 32993) {
                this.uniqueReceived = true;
                if (this.config.enableRecolorTobYour()) {
                    this.wizLights.setAllLightsColor(this.config.yourPurpleColor());
                }
            } else if (impostorId == 32991) {
                this.uniqueReceived = true;
                if (this.config.enableRecolorTobOther()) {
                    this.wizLights.setAllLightsColor(this.config.otherPurpleColor());
                }
            }
            if (this.chestCount == this.getTobTeamSize()) {
                if (!this.uniqueReceived && this.config.enableTobStandardLoot()) {
                    this.wizLights.setAllLightsColor(this.config.tobStandardLootColor());
                }
                this.reset();
            }
        }
    }

    public boolean isInTob() {
        int tobVar = this.client.getVar(6440);
        return tobVar == 2 || tobVar == 3;
    }

    public void reset() {
        this.teamSize = 0;
        this.chestCount = 0;
        this.uniqueReceived = false;
    }

    private int getTobTeamSize() {
        if (this.teamSize == 0) {
            Map varcmap = this.client.getVarcMap();
            for (int i = 0; i < 5; ++i) {
                String playerName;
                Integer playervarp = 330 + i;
                if (!varcmap.containsKey(playervarp) || (playerName = Text.sanitize((String)varcmap.get(playervarp).toString())) == null || playerName.equals("")) continue;
                ++this.teamSize;
            }
        }
        return this.teamSize;
    }
}

