/*
 * Decompiled with CFR 0.152.
 */
package com.WIZLights.Drops;

import com.WIZLights.ItemGroup;
import com.WIZLights.WIZLights;
import com.WIZLights.WIZLightsConfig;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChambersOfXeric {
    private static final Logger log = LoggerFactory.getLogger(ChambersOfXeric.class);
    @Inject
    private WIZLightsConfig config;
    @Inject
    private WIZLights wizLights;
    @Inject
    private Client client;
    private static final Pattern SPECIAL_DROP_MESSAGE = Pattern.compile("(.+) - (.+)");
    private static final Pattern POINTS_MESSAGE = Pattern.compile("Total points: .*, Personal points: ");
    private static final Set<String> uniques = ImmutableSet.of((Object)"Dexterous prayer scroll", (Object)"Arcane prayer scroll", (Object)"Twisted buckler", (Object)"Dragon hunter crossbow", (Object)"Dinh's bulwark", (Object)"Ancestral hat", (Object[])new String[]{"Ancestral robe top", "Ancestral robe bottom", "Dragon claws", "Elder maul", "Kodai insignia", "Twisted bow"});
    private boolean uniqueReceived = false;

    public void onChatMessage(ChatMessage event) {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        if (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            String message = Text.removeTags((String)event.getMessage());
            if (message.contains("your raid is complete!")) {
                return;
            }
            Matcher matcher = SPECIAL_DROP_MESSAGE.matcher(message);
            if (matcher.find()) {
                Color color;
                this.uniqueReceived = true;
                String dropReceiver = Text.sanitize((String)matcher.group(1)).trim();
                String dropName = matcher.group(2).trim();
                if (uniques.contains(dropName) && dropReceiver.equals(Text.sanitize((String)this.client.getLocalPlayer().getName())) && (color = this.getUniqueGroupColor(dropName)) != null) {
                    this.wizLights.setAllLightsColor(color);
                }
            }
            if ((matcher = POINTS_MESSAGE.matcher(message)).find()) {
                if (this.uniqueReceived) {
                    this.uniqueReceived = false;
                } else if (this.config.enableCoxStandardLoot()) {
                    this.wizLights.setAllLightsColor(this.config.coxStandardLootColor());
                }
            }
        }
    }

    private Color getUniqueGroupColor(String uniqueName) {
        switch (uniqueName.toLowerCase().trim()) {
            case "twisted bow": {
                return this.getGroupColor(this.config.groupTwistedBow());
            }
            case "kodai insignia": {
                return this.getGroupColor(this.config.groupKodai());
            }
            case "elder maul": {
                return this.getGroupColor(this.config.groupElderMaul());
            }
            case "dragon claws": {
                return this.getGroupColor(this.config.groupClaws());
            }
            case "ancestral hat": {
                return this.getGroupColor(this.config.groupAncestralHat());
            }
            case "ancestral robe top": {
                return this.getGroupColor(this.config.groupAncestralTop());
            }
            case "ancestral robe bottom": {
                return this.getGroupColor(this.config.groupAncestralBottom());
            }
            case "dinh's bulwark": {
                return this.getGroupColor(this.config.groupDinhs());
            }
            case "dragon hunter crossbow": {
                return this.getGroupColor(this.config.groupDHCB());
            }
            case "twisted buckler": {
                return this.getGroupColor(this.config.groupBuckler());
            }
            case "arcane prayer scroll": {
                return this.getGroupColor(this.config.groupArcane());
            }
            case "dexterous prayer scroll": {
                return this.getGroupColor(this.config.groupDex());
            }
        }
        log.info("Unique received did not match a known item from CoX: {}", (Object)uniqueName);
        return null;
    }

    private Color getGroupColor(ItemGroup group) {
        switch (group) {
            case ONE: {
                return this.config.enableGroupOne() ? this.config.groupOneColor() : null;
            }
            case TWO: {
                return this.config.enableGroupTwo() ? this.config.groupTwoColor() : null;
            }
            case THREE: {
                return this.config.enableGroupThree() ? this.config.groupThreeColor() : null;
            }
            case FOUR: {
                return this.config.enableGroupFour() ? this.config.groupFourColor() : null;
            }
        }
        return null;
    }

    public boolean isInCox() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getVar(5432) == 1;
    }
}

