/*
 * Decompiled with CFR 0.152.
 */
package io.leikvolle.tileindicators;

import com.google.inject.Provides;
import io.leikvolle.tileindicators.ImprovedTileIndicatorsConfig;
import io.leikvolle.tileindicators.ImprovedTileIndicatorsOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Improved Tile Indicators", description="An improved version of the tile indicators plugin", tags={"rs3", "overlay", "tile", "indicators"})
public class ImprovedTileIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImprovedTileIndicatorsPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ImprovedTileIndicatorsOverlay overlay;
    @Inject
    ImprovedTileIndicatorsConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private final Set<NPC> onTopNpcs = new HashSet<NPC>();
    private List<String> onTopNPCNames = new ArrayList<String>();
    private static final String DRAW_ABOVE = "Draw-Above";
    private static final String DRAW_BELOW = "Draw-Below";
    private static final String UNTAG_ALL = "Un-tag-All";

    @Provides
    ImprovedTileIndicatorsConfig provideConfig(ConfigManager configManager) {
        return (ImprovedTileIndicatorsConfig)configManager.getConfig(ImprovedTileIndicatorsConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invoke(this::rebuild);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.onTopNpcs.clear();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("improvedtileindicators")) {
            return;
        }
        this.clientThread.invoke(this::rebuild);
    }

    @Subscribe
    public void onPluginChanged(PluginChanged pluginChanged) {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.overlay);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.onTopMatchesNPCName(npcName)) {
            this.onTopNpcs.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.onTopNpcs.remove(npc);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuAction menuAction;
        int type = event.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        if ((menuAction = MenuAction.of((int)type)) == MenuAction.EXAMINE_NPC && this.client.isKeyPressed(81) && this.config.overlaysBelowNPCs()) {
            String npcName = this.getNameForCachedNPC(event.getIdentifier());
            if (npcName == null) {
                return;
            }
            boolean matchesList = this.onTopNPCNames.stream().filter(highlight -> !highlight.equalsIgnoreCase(npcName)).anyMatch(highlight -> WildcardMatcher.matches((String)highlight, (String)npcName));
            if (!matchesList) {
                this.client.createMenuEntry(-1).setOption(this.onTopNPCNames.stream().anyMatch(npcName::equalsIgnoreCase) ? DRAW_BELOW : DRAW_ABOVE).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::toggleDraw);
            }
        }
    }

    public void toggleDraw(MenuEntry click) {
        String name = this.getNameForCachedNPC(click.getIdentifier());
        if (name == null) {
            return;
        }
        this.updateNpcsToDrawAbove(name);
    }

    private void updateNpcsToDrawAbove(String npc) {
        ArrayList<String> highlightedNpcs = new ArrayList<String>(this.onTopNPCNames);
        if (!highlightedNpcs.removeIf(npc::equalsIgnoreCase)) {
            highlightedNpcs.add(npc);
        }
        this.config.setTopNPCs(Text.toCSV(highlightedNpcs));
    }

    List<String> getTopNPCs() {
        String configNpcs = this.config.getTopNPCs();
        if (configNpcs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNpcs);
    }

    void rebuild() {
        this.onTopNPCNames = this.getTopNPCs();
        this.onTopNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null || !this.onTopMatchesNPCName(npcName)) continue;
            this.onTopNpcs.add(npc);
        }
    }

    private boolean onTopMatchesNPCName(String npcName) {
        for (String matching : this.onTopNPCNames) {
            if (!WildcardMatcher.matches((String)matching, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    private String getNameForCachedNPC(int id) {
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        if (npc == null) {
            return null;
        }
        return npc.getName();
    }

    Set<NPC> getOnTopNpcs() {
        return this.onTopNpcs;
    }
}

