/*
 * Decompiled with CFR 0.152.
 */
package io.leikvolle.tileindicators;

import io.leikvolle.tileindicators.ImprovedTileIndicatorsConfig;
import io.leikvolle.tileindicators.ImprovedTileIndicatorsPlugin;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImprovedTileIndicatorsOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ImprovedTileIndicatorsOverlay.class);
    private final Client client;
    private final ImprovedTileIndicatorsConfig config;
    @Inject
    private ImprovedTileIndicatorsPlugin plugin;
    private final BufferedImage ARROW_ICON;
    private LocalPoint lastDestination;
    private LocalPoint lastlastDestination;
    private int spawnGameCycle;
    private int despawnGameCycle;

    @Inject
    private ImprovedTileIndicatorsOverlay(Client client, ImprovedTileIndicatorsConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
        this.ARROW_ICON = ImageUtil.loadImageResource(ImprovedTileIndicatorsPlugin.class, (String)"arrow.png");
    }

    public Dimension render(Graphics2D graphics) {
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        if (playerPos == null) {
            return null;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return null;
        }
        if (this.config.customDestinationTile()) {
            if (this.lastDestination != null && !this.lastDestination.equals((Object)this.client.getLocalDestinationLocation())) {
                this.lastlastDestination = this.lastDestination;
                this.despawnGameCycle = this.client.getGameCycle();
            }
            if (this.lastDestination == null || !this.lastDestination.equals((Object)this.client.getLocalDestinationLocation())) {
                if (this.client.getLocalDestinationLocation() != null) {
                    this.spawnGameCycle = this.client.getGameCycle();
                }
                this.lastDestination = this.client.getLocalDestinationLocation();
            }
            switch (this.config.highlightDestinationStyle()) {
                case RS3: {
                    this.renderRS3Tile(graphics, this.lastDestination, this.config.highlightDestinationColor(), true, true);
                    this.renderRS3Tile(graphics, this.lastlastDestination, this.config.highlightDestinationColor(), false, false);
                    break;
                }
                case RS3_NO_ARROW: {
                    this.renderRS3Tile(graphics, this.lastDestination, this.config.highlightDestinationColor(), false, true);
                    this.renderRS3Tile(graphics, this.lastlastDestination, this.config.highlightDestinationColor(), false, false);
                }
            }
        }
        if (this.config.overlaysBelowPlayer() && this.client.isGpu()) {
            this.removeActor(graphics, (Actor)this.client.getLocalPlayer());
        }
        if (this.config.overlaysBelowNPCs() && this.client.isGpu()) {
            for (NPC npc2 : this.plugin.getOnTopNpcs().stream().sorted(Comparator.comparingInt(npc -> npc.getLocalLocation().distanceTo(playerPosLocal))).limit(this.config.maxNPCsDrawn()).collect(Collectors.toSet())) {
                this.removeActor(graphics, (Actor)npc2);
            }
        }
        return null;
    }

    private void renderRS3Tile(Graphics2D graphics, LocalPoint dest, Color color, boolean drawArrow, boolean appearing) {
        if (dest == null) {
            return;
        }
        double size = appearing ? 0.65 * (Math.min(7.0, (double)(this.client.getGameCycle() - this.spawnGameCycle)) / 7.0) : 0.65 * ((double)(7 - (this.client.getGameCycle() - this.despawnGameCycle)) / 7.0);
        if (size < 0.0) {
            return;
        }
        Polygon poly = ImprovedTileIndicatorsOverlay.getCanvasTargetTileCirclePoly(this.client, dest, size, this.client.getPlane(), 10);
        Polygon shadow = ImprovedTileIndicatorsOverlay.getCanvasTargetTileCirclePoly(this.client, dest, size, this.client.getPlane(), 0);
        Point canvasLoc = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)dest, (BufferedImage)this.ARROW_ICON, (int)(150 + (int)(20.0 * Math.sin((double)this.client.getGameCycle() / 10.0))));
        if (poly != null) {
            Stroke originalStroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke((float)this.config.destinationTileBorderWidth()));
            graphics.setColor(new Color(-1929379840, true));
            graphics.draw(shadow);
            graphics.setColor(color);
            graphics.draw(poly);
            graphics.setStroke(originalStroke);
        }
        if (canvasLoc != null && drawArrow && shadow != null) {
            double imageScale = 0.8 * Math.min((double)this.client.get3dZoom() / 500.0, 1.0);
            graphics.drawImage(this.ARROW_ICON, (int)((double)(shadow.getBounds().width / 2 + shadow.getBounds().x) - (double)this.ARROW_ICON.getWidth() * imageScale / 2.0), canvasLoc.getY(), (int)((double)this.ARROW_ICON.getWidth() * imageScale), (int)((double)this.ARROW_ICON.getHeight() * imageScale), null);
        }
    }

    public static Polygon getCanvasTargetTileCirclePoly(@Nonnull Client client, @Nonnull LocalPoint localLocation, double size, int plane, int zOffset) {
        int sceneX = localLocation.getSceneX();
        int sceneY = localLocation.getSceneY();
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return null;
        }
        Polygon poly = new Polygon();
        int resolution = 64;
        int height = Perspective.getTileHeight((Client)client, (LocalPoint)localLocation, (int)plane) - zOffset;
        for (int i = 0; i < resolution; ++i) {
            int y;
            double angle = (double)((float)i / (float)resolution * 2.0f) * Math.PI;
            double offsetX = Math.cos(angle);
            double offsetY = Math.sin(angle);
            int x = (int)((double)localLocation.getX() + offsetX * 128.0 * size);
            Point p = Perspective.localToCanvas((Client)client, (int)x, (int)(y = (int)((double)localLocation.getY() + offsetY * 128.0 * size)), (int)height);
            if (p == null) continue;
            poly.addPoint(p.getX(), p.getY());
        }
        return poly;
    }

    private void removeActor(Graphics2D graphics, Actor actor) {
        NPCComposition composition;
        int clipX1 = this.client.getViewportXOffset();
        int clipY1 = this.client.getViewportYOffset();
        int clipX2 = this.client.getViewportWidth() + clipX1;
        int clipY2 = this.client.getViewportHeight() + clipY1;
        Object origAA = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Model model = actor.getModel();
        int vCount = model.getVerticesCount();
        int[] x3d = model.getVerticesX();
        int[] y3d = model.getVerticesY();
        int[] z3d = model.getVerticesZ();
        int[] x2d = new int[vCount];
        int[] y2d = new int[vCount];
        int size = 1;
        if (actor instanceof NPC && (composition = ((NPC)actor).getTransformedComposition()) != null) {
            size = composition.getSize();
        }
        LocalPoint lp = actor.getLocalLocation();
        int localX = lp.getX();
        int localY = lp.getY();
        int northEastX = lp.getX() + 128 * (size - 1) / 2;
        int northEastY = lp.getY() + 128 * (size - 1) / 2;
        LocalPoint northEastLp = new LocalPoint(northEastX, northEastY);
        int localZ = Perspective.getTileHeight((Client)this.client, (LocalPoint)northEastLp, (int)this.client.getPlane());
        int rotation = actor.getCurrentOrientation();
        Perspective.modelToCanvas((Client)this.client, (int)vCount, (int)localX, (int)localY, (int)localZ, (int)rotation, (int[])x3d, (int[])z3d, (int[])y3d, (int[])x2d, (int[])y2d);
        boolean anyVisible = false;
        for (int i = 0; i < vCount; ++i) {
            int x = x2d[i];
            int y = y2d[i];
            boolean visibleX = x >= clipX1 && x < clipX2;
            boolean visibleY = y >= clipY1 && y < clipY2;
            anyVisible |= visibleX && visibleY;
        }
        if (!anyVisible) {
            return;
        }
        int tCount = model.getFaceCount();
        int[] tx = model.getFaceIndices1();
        int[] ty = model.getFaceIndices2();
        int[] tz = model.getFaceIndices3();
        byte[] triangleTransparencies = model.getFaceTransparencies();
        Composite orig = graphics.getComposite();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.setColor(Color.WHITE);
        for (int i = 0; i < tCount; ++i) {
            if (this.getTriDirection(x2d[tx[i]], y2d[tx[i]], x2d[ty[i]], y2d[ty[i]], x2d[tz[i]], y2d[tz[i]]) >= 0 || triangleTransparencies != null && (triangleTransparencies[i] & 0xFF) >= 254) continue;
            Polygon p = new Polygon(new int[]{x2d[tx[i]], x2d[ty[i]], x2d[tz[i]]}, new int[]{y2d[tx[i]], y2d[ty[i]], y2d[tz[i]]}, 3);
            graphics.fill(p);
        }
        graphics.setComposite(orig);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAA);
    }

    private int getTriDirection(int x1, int y1, int x2, int y2, int x3, int y3) {
        int x4 = x2 - x1;
        int y4 = y2 - y1;
        int x5 = x3 - x1;
        int y5 = y3 - y1;
        return x4 * y5 - y4 * x5;
    }
}

