/*
 * Decompiled with CFR 0.152.
 */
package io.leikvolle.tileindicators;

import io.leikvolle.tileindicators.TileStyle;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="improvedtileindicators")
public interface ImprovedTileIndicatorsConfig
extends Config {
    @ConfigSection(name="Player Tile indicators", description="Settings replacing the normal tile indicators plugin", position=0)
    public static final String tileIndicatorsSection = "tileIndicatorsSection";
    @ConfigSection(name="Destination Tile", description="Settings for modifying the destination tile", position=1)
    public static final String destinationTileSection = "destinationTileSection";
    @ConfigSection(name="NPC Indicators", description="Settings enhancing the standard NPC indicators", position=2)
    public static final String npcIndicatorsSection = "npcIndicatorsSection";

    @ConfigItem(keyName="currentTileBelowPlayer", name="Draw overlays below player", description="Requires GPU. Draws overlays below the player", section="tileIndicatorsSection", position=1)
    default public boolean overlaysBelowPlayer() {
        return true;
    }

    @ConfigItem(keyName="customDestinationTile", name="Custom destination tile", description="Enables the use of custom tile indicators on destination", section="destinationTileSection", position=2)
    default public boolean customDestinationTile() {
        return false;
    }

    @ConfigItem(keyName="highlightDestinationStyle", name="Destination Tile Style", description="The style of the destination tile", section="destinationTileSection", position=3)
    default public TileStyle highlightDestinationStyle() {
        return TileStyle.RS3;
    }

    @ConfigItem(keyName="destinationTileBorderWitdh", name="Destination tile border width", description="The width of the custom destination indicator", section="destinationTileSection", position=4)
    default public double destinationTileBorderWidth() {
        return 2.0;
    }

    @Alpha
    @ConfigItem(keyName="highlightDestinationColor", name="Destination tile", description="Configures the highlight color of current destination", section="destinationTileSection", position=5)
    default public Color highlightDestinationColor() {
        return new Color(-5001153);
    }

    @ConfigItem(keyName="overlaysBelowNPCs", name="Draw overlays below NPCs", description="Requires GPU. Draws overlays below specified NPCs. CAUTION: Will make your game laggy if many NPCs are drawn above overlay at once. Best used for bosses, not large groups of NPCs.", section="npcIndicatorsSection", position=6)
    default public boolean overlaysBelowNPCs() {
        return true;
    }

    @ConfigItem(keyName="maxNPCsDrawn", name="NPC limit", description="The number of NPCs in the scene at a time to be affected by this plugin. Will affect FPS.", section="npcIndicatorsSection", position=7)
    @Range(max=20)
    default public int maxNPCsDrawn() {
        return 10;
    }

    @ConfigItem(keyName="topNPCs", name="NPCs to draw on top", description="List of NPCs to draw above overlays. To add NPCs, shift right-click them and click Draw-Above.", section="npcIndicatorsSection", position=8)
    default public String getTopNPCs() {
        return "";
    }

    @ConfigItem(keyName="topNPCs", name="", description="")
    public void setTopNPCs(String var1);
}

