/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.weaponcharges;

import com.gpperhour.weaponcharges.ChargedWeapon;
import com.gpperhour.weaponcharges.ChargesDialogHandler;
import com.gpperhour.weaponcharges.ChargesMessage;
import com.gpperhour.weaponcharges.DialogTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Hitsplat;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaponChargesManager {
    private static final Logger log = LoggerFactory.getLogger(WeaponChargesManager.class);
    public static final String CONFIG_GROUP_NAME = "gpperhour";
    private static final int BLOWPIPE_ATTACK_ANIMATION = 5061;
    private static final int AMMO_SAVING_SETTING_VARBIT = 5697;
    ChargedWeapon lastUsedOnWeapon;
    ChargedWeapon lastUnchargeClickedWeapon;
    @Inject
    Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private KeyManager keyManager;
    @Inject
    private DialogTracker dialogTracker;
    private boolean verboseLogging = false;
    private PickupAction lastPickUpAction;
    private int lastDegradedHitsplatTick = -1000;
    private final Set<Integer> meleeAttackAnimations = Set.of(8056, 245, 376, 381, 386, 390, 8288, 8290, 8289, 9471, 6118, 393, 0, 395, 400, 401, 406, 407, 414, 419, 422, 423, 428, 429, 440, 1058, 1060, 1062, 1378, 1658, 1665, 1667, 2066, 2067, 2078, 2661, 3297, 3298, 3852, 4503, 5865, 7004, 7045, 7054, 7055, 7514, 7515, 7516, 7638, 7639, 7640, 7641, 7642, 7643, 7644, 7645, 8145, 9171, 1203, 5439, 8640);
    private Hitsplat lastMeleeHitsplatApplied = null;
    private List<ChargedWeapon> lastWeaponChecked = new ArrayList<ChargedWeapon>();
    private List<ChargedWeapon> lastWeaponChecked2 = new ArrayList<ChargedWeapon>();
    private final List<Runnable> delayChargeUpdateUntilAfterAnimations = new ArrayList<Runnable>();
    private static final Pattern NO_DARTS_CHECK_PATTERN = Pattern.compile("Darts: None. Scales: ([\\d,]+) \\(\\d+[.]?\\d%\\).");
    private static final Pattern DARTS_AND_SCALE_CHECK_PATTERN = Pattern.compile("Darts: (\\S*)(?: dart)? x ([\\d,]+). Scales: ([\\d,]+) \\(\\d+[.]?\\d%\\).");
    private static final Pattern USE_SCALES_ON_FULL_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe can't hold any more scales.");
    private static final Pattern USE_DARTS_ON_FULL_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe can't hold any more darts.");
    private static final Pattern UNLOAD_EMPTY_BLOWPIPE_PATTERN = Pattern.compile("The blowpipe has no darts in it.");
    private static final Pattern NO_DARTS_PATTERN = Pattern.compile("Your blowpipe has run out of darts.");
    private static final Pattern NO_SCALES_PATTERN = Pattern.compile("Your blowpipe needs to be charged with Zulrah's scales.");
    private static final Pattern NO_DARTS_OR_SCALES_PATTERN = Pattern.compile("Your blowpipe has run out of scales and darts.");
    private static final Pattern NO_DARTS_PATTERN_2 = Pattern.compile("Your blowpipe contains no darts.");
    private static final Pattern NO_DARTS_OR_SCALES_PATTERN_2 = Pattern.compile("Your blowpipe needs to be charged with Zulrah's scales and loaded with darts.");
    private boolean checkTomeOfFire = false;
    private boolean checkTomeOfWater = false;
    private int checkBlowpipeUnload = -100;
    private int checkSingleCrystalShardUse = -100;
    private int lastLocalPlayerAnimationChangedGameTick = -1;
    private int lastLocalPlayerAnimationChanged = -1;
    private static final int TICKS_RAPID_PVM = 2;
    private static final int TICKS_NORMAL_PVM = 3;
    public static final int MAX_SCALES_BLOWPIPE = 16383;
    public static final int MAX_DARTS = 16383;
    private int ticks = 0;
    private int ticksInAnimation;
    private int lastAnimationStart = 0;
    @Inject
    ConfigManager configManager;
    private Map<Integer, Float> emptyMap = new HashMap<Integer, Float>();
    private Map<Integer, Float> blowpipeMap = new HashMap<Integer, Float>();

    public void startUp() {
        this.lastLocalPlayerAnimationChangedGameTick = -1;
        this.lastLocalPlayerAnimationChanged = -1;
        this.dialogTracker.reset();
        this.eventBus.register((Object)this.dialogTracker);
        this.keyManager.registerKeyListener((KeyListener)this.dialogTracker);
        this.dialogTracker.setStateChangedListener(this::dialogStateChanged);
        this.dialogTracker.setOptionSelectedListener(this::optionSelected);
    }

    public void shutDown() {
        this.eventBus.unregister((Object)this.dialogTracker);
        this.keyManager.unregisterKeyListener((KeyListener)this.dialogTracker);
    }

    void dialogStateChanged(DialogTracker.DialogState dialogState) {
        for (ChargesDialogHandler nonUniqueDialogHandler : ChargedWeapon.getNonUniqueDialogHandlers()) {
            nonUniqueDialogHandler.handleDialog(dialogState, this);
        }
        block1: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            for (ChargesDialogHandler dialogHandler : chargedWeapon.getDialogHandlers()) {
                if (!dialogHandler.handleDialog(dialogState, this)) continue;
                break block1;
            }
        }
    }

    void optionSelected(DialogTracker.DialogState dialogState, String optionSelected) {
        for (ChargesDialogHandler nonUniqueDialogHandler : ChargedWeapon.getNonUniqueDialogHandlers()) {
            nonUniqueDialogHandler.handleDialogOptionSelected(dialogState, optionSelected, this);
        }
        block1: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            for (ChargesDialogHandler dialogHandler : chargedWeapon.getDialogHandlers()) {
                if (!dialogHandler.handleDialogOptionSelected(dialogState, optionSelected, this)) continue;
                break block1;
            }
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        Actor target = e.getActor();
        Hitsplat hitsplat = e.getHitsplat();
        int hitType = hitsplat.getHitsplatType();
        ChargedWeapon helm = this.getEquippedChargedWeapon(EquipmentInventorySlot.HEAD);
        if (helm == ChargedWeapon.SERPENTINE_HELM && hitsplat.isMine() && this.client.getTickCount() - this.lastDegradedHitsplatTick > 90) {
            this.addCharges(helm, -10, false);
            this.lastDegradedHitsplatTick = this.client.getTickCount();
            if (this.verboseLogging) {
                this.client.addChatMessage(ChatMessageType.FRIENDSCHAT, "WeaponCharges", "Serpentine Helmet has Degraded!", "DEVMODE");
            }
        }
        ChargedWeapon body = this.getEquippedChargedWeapon(EquipmentInventorySlot.BODY);
        ChargedWeapon legs = this.getEquippedChargedWeapon(EquipmentInventorySlot.LEGS);
        if (target == this.client.getLocalPlayer() && hitType == 16 && e.getHitsplat().getAmount() > 0) {
            if (helm == ChargedWeapon.CRYSTAL_HELM) {
                this.addCharges(helm, -1, false);
            }
            if (body == ChargedWeapon.CRYSTAL_BODY) {
                this.addCharges(body, -1, false);
            }
            if (legs == ChargedWeapon.CRYSTAL_LEGS) {
                this.addCharges(legs, -1, false);
            }
        }
        this.checkMeleeHitsplat(target, hitsplat);
    }

    private void checkMeleeHitsplat(Actor target, Hitsplat hitsplat) {
        if (!hitsplat.isMine() || target == this.client.getLocalPlayer()) {
            return;
        }
        if (this.client.getTickCount() != this.lastLocalPlayerAnimationChangedGameTick + 1) {
            return;
        }
        if (!this.meleeAttackAnimations.contains(this.lastLocalPlayerAnimationChanged)) {
            return;
        }
        this.lastMeleeHitsplatApplied = hitsplat;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.GROUND_ITEM_THIRD_OPTION && event.getMenuOption().equals("Take")) {
            WorldPoint point = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
            this.lastPickUpAction = new PickupAction(event.getId(), point);
        }
        if (event.getMenuOption().equalsIgnoreCase("check")) {
            if (this.verboseLogging) {
                log.info("clicked \"check\" on " + event.getMenuTarget());
            }
            if (WidgetInfo.TO_GROUP((int)event.getParam1()) == 387) {
                ChargedWeapon chargedWeapon;
                int childId = WidgetInfo.TO_CHILD((int)event.getParam1());
                if (childId == 18) {
                    ChargedWeapon chargedWeapon2 = this.getEquippedChargedWeapon(EquipmentInventorySlot.WEAPON);
                    if (chargedWeapon2 != null) {
                        this.lastWeaponChecked.add(chargedWeapon2);
                    }
                } else if (childId == 20 && (chargedWeapon = this.getEquippedChargedWeapon(EquipmentInventorySlot.SHIELD)) != null) {
                    this.lastWeaponChecked.add(chargedWeapon);
                }
            } else {
                for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
                    if (!chargedWeapon.getItemIds().contains(event.getItemId()) || !chargedWeapon.getCheckChargesRegexes().isEmpty()) continue;
                    if (this.verboseLogging) {
                        log.info("adding last weapon checked to " + chargedWeapon);
                    }
                    this.lastWeaponChecked.add(chargedWeapon);
                    break;
                }
            }
        } else if (event.getMenuOption().equalsIgnoreCase("uncharge")) {
            for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
                if (!chargedWeapon.getItemIds().contains(event.getItemId())) continue;
                if (this.verboseLogging) {
                    log.info("setting lastUnchargeClickedWeapon to " + chargedWeapon);
                }
                this.lastUnchargeClickedWeapon = chargedWeapon;
                break;
            }
        } else if (event.getMenuOption().equalsIgnoreCase("unload") && event.getItemId() == 12926) {
            this.checkBlowpipeUnload = this.client.getTickCount();
        } else if (event.getMenuOption().equalsIgnoreCase("pages")) {
            this.lastUsedOnWeapon = WidgetInfo.TO_GROUP((int)event.getParam1()) == 387 ? this.getEquippedChargedWeapon(EquipmentInventorySlot.SHIELD) : ChargedWeapon.getChargedWeaponFromId(event.getItemId());
            if (this.verboseLogging) {
                log.info("pages checked. setting last used weapon to {}", (Object)this.lastUsedOnWeapon.toString());
            }
        }
        this.checkWidgetOnWidget(event);
    }

    void checkWidgetOnWidget(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET) {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            if (itemContainer == null) {
                return;
            }
            Widget selectedWidget = this.client.getSelectedWidget();
            if (selectedWidget == null) {
                return;
            }
            Item itemUsed = itemContainer.getItem(selectedWidget.getIndex());
            if (itemUsed == null) {
                return;
            }
            int itemUsedId = itemUsed.getId();
            Widget eventWidget = event.getWidget();
            if (eventWidget == null) {
                return;
            }
            Item itemUsedOn = itemContainer.getItem(eventWidget.getIndex());
            if (itemUsedOn == null) {
                return;
            }
            int itemUsedOnId = itemUsedOn.getId();
            this.lastUsedOnWeapon = ChargedWeapon.getChargedWeaponFromId(itemUsedId);
            if (this.lastUsedOnWeapon == null) {
                this.lastUsedOnWeapon = ChargedWeapon.getChargedWeaponFromId(itemUsedOnId);
                if (this.lastUsedOnWeapon != null) {
                    if (this.verboseLogging) {
                        log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), itemUsedId, this.lastUsedOnWeapon});
                    }
                    this.checkSingleCrystalShardUse(itemUsed, itemUsedId);
                } else if (this.verboseLogging) {
                    log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), itemUsedId, itemUsedOnId});
                }
            } else {
                if (this.verboseLogging) {
                    log.info("{}: used {} on {}", new Object[]{this.client.getTickCount(), this.lastUsedOnWeapon, itemUsedOnId});
                }
                this.checkSingleCrystalShardUse(itemUsedOn, itemUsedOnId);
            }
        }
    }

    private void checkSingleCrystalShardUse(Item itemUsed, int itemUsedId) {
        if (itemUsedId == 23962 && itemUsed.getQuantity() == 1 && ChargedWeapon.CRYSTAL_SHARD_RECHARGABLE_ITEMS.contains((Object)this.lastUsedOnWeapon)) {
            this.checkSingleCrystalShardUse = this.client.getTickCount();
        }
    }

    private boolean hasToxicBlowpipeEquippedOrInInventory() {
        Item weapon;
        ItemContainer equipmentContainer;
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer != null) {
            Item[] inventoryItems;
            for (Item item : inventoryItems = itemContainer.getItems()) {
                if (item.getId() != 12926) continue;
                return true;
            }
        }
        return (equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT)) != null && (weapon = equipmentContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx())) != null && weapon.getId() == 12926;
    }

    private boolean hasBlowpipeData() {
        return this.getDartsLeft() != null && this.getScalesLeft() != null && this.getDartType() != DartType.UNKNOWN;
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        if (this.client.getVarbitValue(5697) != 1) {
            return;
        }
        if (!this.hasBlowpipeData()) {
            return;
        }
        int itemId = event.getItem().getId();
        if (itemId != this.getDartType().itemId) {
            return;
        }
        if (!this.hasToxicBlowpipeEquippedOrInInventory()) {
            return;
        }
        if (this.lastPickUpAction == null) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation())) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.lastPickUpAction.getWorldPoint())) {
            return;
        }
        if (itemId != this.lastPickUpAction.getItemId()) {
            return;
        }
        int quantity = event.getItem().getQuantity();
        this.addDartsLeft(quantity, false);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        if (this.checkBlowpipeUnload == this.client.getTickCount() || this.checkBlowpipeUnload + 1 == this.client.getTickCount()) {
            this.setDartsLeft(0.0f);
            this.setDartType(DartType.UNKNOWN);
        }
        if (this.checkSingleCrystalShardUse == this.client.getTickCount() || this.checkSingleCrystalShardUse + 1 == this.client.getTickCount()) {
            this.addCharges(this.lastUsedOnWeapon, 100, false);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher matcher;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        for (ChargesMessage checkMessage : ChargedWeapon.getNonUniqueCheckChargesRegexes()) {
            matcher = checkMessage.getPattern().matcher(message);
            if (!matcher.find()) continue;
            ChargedWeapon chargedWeapon = this.removeLastWeaponChecked();
            if (chargedWeapon != null) {
                this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher));
                break;
            }
            if (this.lastUsedOnWeapon != null) {
                this.setCharges(this.lastUsedOnWeapon, checkMessage.getChargesLeft(matcher));
                if (!this.verboseLogging) break;
                log.info("applying charges to last used-on weapon: {}", (Object)this.lastUsedOnWeapon);
                break;
            }
            log.warn("saw check message without having seen a charged weapon checked or used: \"" + message + "\"");
            break;
        }
        for (ChargesMessage checkMessage : ChargedWeapon.getNonUniqueUpdateMessageChargesRegexes()) {
            matcher = checkMessage.getPattern().matcher(message);
            if (!matcher.find()) continue;
            int chargeCount = checkMessage.getChargesLeft(matcher);
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                ChargedWeapon equippedWeapon = this.getEquippedChargedWeapon(EquipmentInventorySlot.WEAPON);
                if (equippedWeapon != null) {
                    this.setCharges(equippedWeapon, chargeCount);
                } else {
                    log.warn("saw charge update message without a weapon being equipped: \"" + message + "\"");
                }
            });
            break;
        }
        block2: for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            Matcher matcher2;
            if (chargedWeapon.getCheckChargesRegexes().isEmpty()) continue;
            for (ChargesMessage checkMessage : chargedWeapon.getCheckChargesRegexes()) {
                matcher2 = checkMessage.getPattern().matcher(message);
                if (!matcher2.find()) continue;
                this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher2));
                break block2;
            }
            for (ChargesMessage checkMessage : chargedWeapon.getUpdateMessageChargesRegexes()) {
                matcher2 = checkMessage.getPattern().matcher(message);
                if (!matcher2.find()) continue;
                this.delayChargeUpdateUntilAfterAnimations.add(() -> this.setCharges(chargedWeapon, checkMessage.getChargesLeft(matcher2)));
                break block2;
            }
        }
        this.chatMessageBlowpipe(message);
    }

    private ChargedWeapon removeLastWeaponChecked() {
        return !this.lastWeaponChecked2.isEmpty() ? this.lastWeaponChecked2.remove(0) : (!this.lastWeaponChecked.isEmpty() ? this.lastWeaponChecked.remove(0) : null);
    }

    private ChargedWeapon getEquippedChargedWeapon(EquipmentInventorySlot slot) {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return null;
        }
        Item item = itemContainer.getItem(slot.getSlotIdx());
        if (item == null) {
            return null;
        }
        return ChargedWeapon.getChargedWeaponFromId(item.getId());
    }

    private void chatMessageBlowpipe(String chatMsg) {
        Matcher matcher = DARTS_AND_SCALE_CHECK_PATTERN.matcher(chatMsg);
        if (matcher.find()) {
            this.setDartsLeft(Integer.parseInt(matcher.group(2).replace(",", "")));
            this.setScalesLeft(Integer.parseInt(matcher.group(3).replace(",", "")));
            this.setDartType(DartType.getDartTypeByName(matcher.group(1)));
        }
        if ((matcher = NO_DARTS_CHECK_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(0.0f);
            this.setScalesLeft(Integer.parseInt(matcher.group(1).replace(",", "")));
            this.setDartType(DartType.UNKNOWN);
        }
        if ((matcher = USE_SCALES_ON_FULL_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setScalesLeft(16383.0f);
        }
        if ((matcher = USE_DARTS_ON_FULL_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(16383.0f);
        }
        if ((matcher = UNLOAD_EMPTY_BLOWPIPE_PATTERN.matcher(chatMsg)).find()) {
            this.setDartsLeft(0.0f);
            this.setDartType(DartType.UNKNOWN);
        }
        if ((matcher = NO_DARTS_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_SCALES_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> this.setScalesLeft(0.0f));
        }
        if ((matcher = NO_DARTS_OR_SCALES_PATTERN.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setScalesLeft(0.0f);
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_DARTS_PATTERN_2.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
        if ((matcher = NO_DARTS_OR_SCALES_PATTERN_2.matcher(chatMsg)).find()) {
            this.delayChargeUpdateUntilAfterAnimations.add(() -> {
                this.setScalesLeft(0.0f);
                this.setDartsLeft(0.0f);
                this.setDartType(DartType.UNKNOWN);
            });
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        Player localPlayer;
        if (this.checkTomeOfFire && ((localPlayer = this.client.getLocalPlayer()).hasSpotAnim(99) || localPlayer.hasSpotAnim(126) || localPlayer.hasSpotAnim(129) || localPlayer.hasSpotAnim(155) || localPlayer.hasSpotAnim(1464))) {
            this.addCharges(ChargedWeapon.TOME_OF_FIRE, -1, false);
        }
        this.checkTomeOfFire = false;
        if (this.checkTomeOfWater) {
            localPlayer = this.client.getLocalPlayer();
            if (localPlayer.hasSpotAnim(177) || localPlayer.hasSpotAnim(102) || localPlayer.hasSpotAnim(105) || localPlayer.hasSpotAnim(108) || localPlayer.hasSpotAnim(167) || localPlayer.hasSpotAnim(170) || localPlayer.hasSpotAnim(173) || localPlayer.hasSpotAnim(93) || localPlayer.hasSpotAnim(120) || localPlayer.hasSpotAnim(135) || localPlayer.hasSpotAnim(161) || localPlayer.hasSpotAnim(1458)) {
                this.addCharges(ChargedWeapon.TOME_OF_WATER, -1, false);
            }
            this.checkTomeOfWater = false;
        }
    }

    @Subscribe(priority=10.0f)
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (actor != this.client.getLocalPlayer()) {
            return;
        }
        this.lastLocalPlayerAnimationChangedGameTick = this.client.getTickCount();
        this.lastLocalPlayerAnimationChanged = actor.getAnimation();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        ChargedWeapon amulet;
        if (this.lastMeleeHitsplatApplied != null && this.lastMeleeHitsplatApplied.getAmount() > 0 && (amulet = this.getEquippedChargedWeapon(EquipmentInventorySlot.AMULET)) == ChargedWeapon.BLOOD_FURY) {
            if (this.lastLocalPlayerAnimationChanged == 8056) {
                this.addCharges(amulet, -3, false);
            } else {
                this.addCharges(amulet, -1, false);
            }
        }
        this.lastMeleeHitsplatApplied = null;
        if (this.lastLocalPlayerAnimationChangedGameTick == this.client.getTickCount()) {
            this.checkAnimation();
        }
        if (this.lastLocalPlayerAnimationChanged == 5061) {
            this.blowpipeOnGameTick();
        }
        if (!this.delayChargeUpdateUntilAfterAnimations.isEmpty()) {
            for (Runnable runnable : this.delayChargeUpdateUntilAfterAnimations) {
                runnable.run();
            }
            this.delayChargeUpdateUntilAfterAnimations.clear();
        }
        if (!this.lastWeaponChecked2.isEmpty()) {
            log.warn("checked weapons with no check message: " + this.lastWeaponChecked2);
        }
        this.lastWeaponChecked2.clear();
        this.lastWeaponChecked2 = this.lastWeaponChecked;
        this.lastWeaponChecked = new ArrayList<ChargedWeapon>();
    }

    private void blowpipeOnGameTick() {
        if (this.ticks == 0) {
            this.lastAnimationStart = this.client.getTickCount();
        } else if (this.client.getTickCount() - this.lastAnimationStart > this.ticksInAnimation) {
            this.ticks = 0;
            this.lastAnimationStart = this.client.getTickCount();
        }
        ++this.ticks;
        if (this.ticks == this.ticksInAnimation) {
            this.consumeBlowpipeCharges();
            this.ticks = 0;
        }
    }

    private void checkAnimation() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return;
        }
        Item weapon = itemContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
        int weaponItemId = weapon == null ? -1 : weapon.getId();
        Item offhand = itemContainer.getItem(EquipmentInventorySlot.SHIELD.getSlotIdx());
        int offhandItemId = offhand == null ? -1 : offhand.getId();
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            if (!chargedWeapon.getItemIds().contains(weaponItemId) && !chargedWeapon.getItemIds().contains(offhandItemId) || !chargedWeapon.animationIds.contains(this.lastLocalPlayerAnimationChanged)) continue;
            if (chargedWeapon == ChargedWeapon.TOME_OF_FIRE) {
                this.checkTomeOfFire = true;
                continue;
            }
            if (chargedWeapon == ChargedWeapon.TOME_OF_WATER) {
                this.checkTomeOfWater = true;
                continue;
            }
            this.addCharges(chargedWeapon, -1, false);
        }
    }

    private void consumeBlowpipeCharges() {
        this.addDartsLeft(-1.0f * this.getAmmoLossChance(), false);
        this.addScalesLeft(-0.6666667f, false);
    }

    private float getAmmoLossChance() {
        int attractorEquippedId = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.CAPE);
        switch (attractorEquippedId) {
            case 10498: {
                return 0.4f;
            }
            case 10499: 
            case 13337: {
                return 0.28f;
            }
            case 9756: 
            case 9757: 
            case 13280: {
                return 0.28f;
            }
            case 21898: 
            case 22109: 
            case 24135: 
            case 24222: 
            case 27363: 
            case 27365: 
            case 27374: 
            case 27376: {
                return 0.2f;
            }
        }
        return 1.0f;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() == 43) {
            this.ticksInAnimation = event.getValue() == 1 ? 2 : 3;
        }
    }

    public Integer getCharges(ChargedWeapon weapon) {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, weapon.configKeyName);
        if (configString == null) {
            return null;
        }
        return Integer.parseInt(configString);
    }

    public void setCharges(ChargedWeapon weapon, int charges) {
        this.setCharges(weapon, charges, true);
    }

    public void setCharges(ChargedWeapon weapon, int charges, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, weapon.configKeyName, (Object)Math.max(charges, 0));
        if (this.verboseLogging) {
            log.info("set charges for " + weapon + " to " + charges);
        }
    }

    public void addCharges(ChargedWeapon weapon, int change, boolean logChange) {
        Integer charges = this.getCharges(weapon);
        if (this.verboseLogging) {
            log.info("Adding " + change + " charges to " + weapon.name + "which has " + charges + "charges.");
        }
        this.setCharges(weapon, (charges == null ? 0 : charges) + change, logChange);
    }

    public Float getDartsLeft() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDarts");
        if (configString == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(configString));
    }

    void setDartsLeft(float dartsLeft) {
        this.setDartsLeft(dartsLeft, true);
    }

    private void setDartsLeft(float dartsLeft, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDarts", (Object)Float.valueOf(dartsLeft));
        if (this.verboseLogging) {
            log.info("set darts left to " + dartsLeft);
        }
    }

    private void addDartsLeft(float change, boolean logChange) {
        Float dartsLeft = this.getDartsLeft();
        this.setDartsLeft((dartsLeft == null ? 0.0f : dartsLeft.floatValue()) + change, logChange);
    }

    public DartType getDartType() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDartType");
        if (configString == null) {
            return DartType.UNKNOWN;
        }
        return DartType.valueOf(configString);
    }

    void setDartType(DartType dartType) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeDartType", (Object)dartType);
        if (this.verboseLogging) {
            log.info("set dart type to " + dartType);
        }
    }

    public Float getScalesLeft() {
        String configString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeScales");
        if (configString == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(configString));
    }

    void setScalesLeft(float scalesLeft) {
        this.setScalesLeft(scalesLeft, true);
    }

    private void setScalesLeft(float scalesLeft, boolean logChange) {
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "blowpipeScales", (Object)Float.valueOf(scalesLeft));
        if (this.verboseLogging) {
            log.info("set scales left to " + scalesLeft);
        }
    }

    private void addScalesLeft(float change, boolean logChange) {
        Float scalesLeft = this.getScalesLeft();
        this.setScalesLeft((scalesLeft == null ? 0.0f : scalesLeft.floatValue()) + change, logChange);
    }

    public boolean isChargeableWeapon(Integer itemId) {
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            if (!chargedWeapon.getItemIds().contains(itemId)) continue;
            return true;
        }
        return false;
    }

    private ChargedWeapon getChargedWeapon(Integer itemId) {
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            if (!chargedWeapon.getItemIds().contains(itemId)) continue;
            return chargedWeapon;
        }
        return null;
    }

    public boolean hasChargeData(Integer itemId) {
        if (itemId == 12926) {
            return this.hasBlowpipeData();
        }
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            if (!chargedWeapon.getItemIds().contains(itemId)) continue;
            return this.getCharges(chargedWeapon) != null;
        }
        log.warn("Didn't find a chargeable weapon for this itemID, this shouldn't happen.");
        return false;
    }

    public Map<Integer, Float> getChargeComponents(Integer itemId) {
        ChargedWeapon weapon = null;
        for (ChargedWeapon chargedWeapon : ChargedWeapon.values()) {
            if (!chargedWeapon.getItemIds().contains(itemId)) continue;
            weapon = chargedWeapon;
            break;
        }
        if (weapon == null) {
            log.warn("Weapon is NULL");
            return this.emptyMap;
        }
        if (weapon == ChargedWeapon.TOXIC_BLOWPIPE) {
            this.blowpipeMap.clear();
            Float dartCount = this.getDartsLeft();
            Float scaleCount = this.getScalesLeft();
            DartType dartType = this.getDartType();
            this.blowpipeMap.put(dartType.itemId, dartCount);
            this.blowpipeMap.put(12934, scaleCount);
            return this.blowpipeMap;
        }
        return weapon.getChargeComponents(this.getCharges(weapon));
    }

    public static enum DartType {
        UNKNOWN(-1, Color.LIGHT_GRAY, null),
        BRONZE(806, new Color(7231271), "bronze"),
        IRON(807, new Color(5394508), "iron"),
        STEEL(808, new Color(8026227), "steel"),
        MITHRIL(809, new Color(4280184), "mithril"),
        ADAMANT(810, new Color(4290642), "adamant"),
        RUNE(811, new Color(6807797), "rune"),
        AMETHYST(25849, new Color(13139412), "amethyst"),
        DRAGON(11230, new Color(4094071), "dragon");

        public final int itemId;
        public final Color displayColor;
        public final String checkBlowpipeMessageName;

        public static DartType getDartTypeByName(String group) {
            group = group.toLowerCase();
            for (DartType dartType : DartType.values()) {
                if (dartType.checkBlowpipeMessageName == null || !dartType.checkBlowpipeMessageName.equals(group)) continue;
                return dartType;
            }
            return null;
        }

        private DartType(int itemId, Color displayColor, String checkBlowpipeMessageName) {
            this.itemId = itemId;
            this.displayColor = displayColor;
            this.checkBlowpipeMessageName = checkBlowpipeMessageName;
        }
    }

    public class PickupAction {
        int itemId;
        WorldPoint worldPoint;

        public int getItemId() {
            return this.itemId;
        }

        public WorldPoint getWorldPoint() {
            return this.worldPoint;
        }

        public void setItemId(int itemId) {
            this.itemId = itemId;
        }

        public void setWorldPoint(WorldPoint worldPoint) {
            this.worldPoint = worldPoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PickupAction)) {
                return false;
            }
            PickupAction other = (PickupAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            WorldPoint this$worldPoint = this.getWorldPoint();
            WorldPoint other$worldPoint = other.getWorldPoint();
            return !(this$worldPoint == null ? other$worldPoint != null : !this$worldPoint.equals(other$worldPoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PickupAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemId();
            WorldPoint $worldPoint = this.getWorldPoint();
            result = result * 59 + ($worldPoint == null ? 43 : $worldPoint.hashCode());
            return result;
        }

        public String toString() {
            return "WeaponChargesManager.PickupAction(itemId=" + this.getItemId() + ", worldPoint=" + this.getWorldPoint() + ")";
        }

        public PickupAction(int itemId, WorldPoint worldPoint) {
            this.itemId = itemId;
            this.worldPoint = worldPoint;
        }
    }
}

