/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges.items;

import com.google.gson.Gson;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class U_SeedBox
extends ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(U_SeedBox.class);
    private static final String checkRegex = "^(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\.$";
    private static final Pattern checkPattern = Pattern.compile("^(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\.$");
    private static final String pickupRegex = "^You put\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+straight into your open seed box\\.$";
    private static final Pattern pickupPattern = Pattern.compile("^You put\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+straight into your open seed box\\.$");
    private static final String storeRegex = "^Stored\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+in your seed box\\.$";
    private static final Pattern storePattern = Pattern.compile("^Stored\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+in your seed box\\.$");
    private static final String removeRegex = "^Emptied\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+to your inventory\\.$";
    private static final Pattern removePattern = Pattern.compile("^Emptied\\s+(\\d+)\\s+x\\s+([A-Za-z\\s]+seed)\\s+to your inventory\\.$");

    public U_SeedBox(Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        super(ChargesItem.SEED_BOX, 13639, client, client_thread, configs, items, chat_messages, notifier, gson, executorService);
        this.config_key = "seed_box";
        this.zero_charges_is_positive = true;
        this.triggers_items = new TriggerItem[]{new TriggerItem(13639), new TriggerItem(24482)};
        this.triggers_chat_messages = new TriggerChatMessage[]{new TriggerChatMessage("The seed box is empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("Your seed box is now empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("The seed box contains:").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage(checkRegex).onItemClick().extraConsumer(message -> this.addMatches(checkPattern.matcher((CharSequence)message), false)), new TriggerChatMessage(pickupRegex).extraConsumer(message -> this.addMatches(pickupPattern.matcher((CharSequence)message), false)), new TriggerChatMessage(storeRegex).extraConsumer(message -> this.addMatches(storePattern.matcher((CharSequence)message), false)), new TriggerChatMessage(removeRegex).extraConsumer(message -> this.addMatches(removePattern.matcher((CharSequence)message), true))};
    }

    private void addMatches(Matcher matcher, boolean remove) {
        if (!super.hasChargeData()) {
            return;
        }
        while (matcher.find()) {
            try {
                int amount = Integer.parseInt(matcher.group(1));
                String name = matcher.group(2);
                Integer itemId = this.tryFindItemIdFromName(name);
                if (itemId == null) continue;
                super.addItems(itemId, Float.valueOf(remove ? -amount : amount));
            }
            catch (NumberFormatException e) {
                log.error("couldn't parse seed box match", (Throwable)e);
            }
        }
    }
}

