/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges.items;

import com.google.gson.Gson;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import com.gpperhour.itemcharges.triggers.TriggerItemContainer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class U_LogBasket
extends ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(U_LogBasket.class);
    private final int CAPACITY = 28;
    private static final String logMessage = "^You get some ([a-zA-Z ]+)[.!]?$";
    private static final Pattern logPattern = Pattern.compile("^You get some ([a-zA-Z ]+)[.!]?$");
    private static final String checkRegex = "([0-9]+) x ([a-zA-Z ]+),? ?";
    private static final Pattern checkPattern = Pattern.compile("([0-9]+) x ([a-zA-Z ]+),? ?");
    private int lastNatureOfferingTickCount = 0;

    public U_LogBasket(Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        super(ChargesItem.LOG_BASKET, 28140, client, client_thread, configs, items, chat_messages, notifier, gson, executorService);
        this.config_key = "log_basket";
        this.zero_charges_is_positive = true;
        this.triggers_items = new TriggerItem[]{new TriggerItem(28140), new TriggerItem(28142)};
        this.triggers_chat_messages = new TriggerChatMessage[]{new TriggerChatMessage("(Your|The) basket is empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("You empty your basket into the bank.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("(You get some.* logs)").extraConsumer(message -> {
            if ((this.item_id == 28142 || this.item_id == 28145) && this.getItemCount() < 28 && super.hasChargeData()) {
                Matcher matcher = logPattern.matcher((CharSequence)message);
                if (matcher.matches()) {
                    String logName = matcher.group(1);
                    Integer itemId = this.tryFindItemIdFromName(logName);
                    if (itemId != null) {
                        super.addItems(itemId, Float.valueOf(1.0f));
                        if (this.getItemCount() < 28 && this.lastNatureOfferingTickCount == client.getTickCount()) {
                            super.addItems(itemId, Float.valueOf(1.0f));
                        }
                    }
                } else {
                    log.error("no log match found for message: " + message);
                }
            }
        }), new TriggerChatMessage("(The nature offerings enabled you to chop an extra log.)").extraConsumer(message -> {
            this.lastNatureOfferingTickCount = client.getTickCount();
        }), new TriggerChatMessage("The basket contains:").extraConsumer(message -> {
            super.emptyOrClear();
            Matcher matcher = checkPattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int amount = Integer.parseInt(matcher.group(1));
                    String name = matcher.group(2);
                    Integer itemId = this.tryFindItemIdFromName(name);
                    if (itemId == null) continue;
                    super.addItems(itemId, Float.valueOf(amount));
                }
                catch (NumberFormatException e) {
                    log.error("couldn't parse log basket check", (Throwable)e);
                }
            }
        })};
        this.triggers_item_containers = new TriggerItemContainer[]{new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open log basket").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Log basket").menuOption("Fill").addDifference()};
        this.supportsWidgetOnWidget = true;
    }
}

