/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges.items;

import com.google.gson.Gson;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import com.gpperhour.itemcharges.triggers.TriggerItemContainer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class U_HerbSack
extends ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(U_HerbSack.class);
    private static final String pickupRegex = "^You put the (Grimy\\s+[A-Za-z\\s]+)\\s+herb into your herb sack\\.$";
    private static final Pattern pickupPattern = Pattern.compile("^You put the (Grimy\\s+[A-Za-z\\s]+)\\s+herb into your herb sack\\.$");
    private static final String checkRegex = "(\\d+)\\s*x\\s+(.*)";
    private static final Pattern checkPattern = Pattern.compile("(\\d+)\\s*x\\s+(.*)");

    public U_HerbSack(Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        super(ChargesItem.HERB_SACK, 13226, client, client_thread, configs, items, chat_messages, notifier, gson, executorService);
        this.config_key = "herb_sack";
        this.zero_charges_is_positive = true;
        this.triggers_items = new TriggerItem[]{new TriggerItem(13226), new TriggerItem(24478)};
        this.triggers_chat_messages = new TriggerChatMessage[]{new TriggerChatMessage("The herb sack is empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage(pickupRegex).extraConsumer(message -> {
            if (super.hasChargeData()) {
                Matcher matcher = pickupPattern.matcher((CharSequence)message);
                if (matcher.matches()) {
                    String itemName = matcher.group(1);
                    Integer itemId = this.tryFindItemIdFromName(itemName);
                    if (itemId != null) {
                        super.addItems(itemId, Float.valueOf(1.0f));
                    }
                } else {
                    log.error("no herb match found for message: " + message);
                }
            }
        }), new TriggerChatMessage("You look in your herb sack and see:").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("x Grimy").onItemClick().extraConsumer(message -> {
            Matcher matcher = checkPattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int amount = Integer.parseInt(matcher.group(1));
                    String name = matcher.group(2);
                    Integer itemId = this.tryFindItemIdFromName(name);
                    if (itemId == null) continue;
                    super.addItems(itemId, Float.valueOf(amount));
                }
                catch (NumberFormatException e) {
                    log.error("couldn't parse herb sack check", (Throwable)e);
                }
            }
        })};
        this.triggers_item_containers = new TriggerItemContainer[]{new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open herb sack").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Herb sack").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open herb sack").menuOption("Empty").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Herb sack").menuOption("Empty").addDifference(), new TriggerItemContainer(InventoryID.BANK.getId()).menuTarget("Open herb sack").menuOption("Empty").extraConsumer(() -> super.emptyOrClear()), new TriggerItemContainer(InventoryID.BANK.getId()).menuTarget("Herb sack").menuOption("Empty").extraConsumer(() -> super.emptyOrClear())};
        this.supportsWidgetOnWidget = true;
    }
}

