/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges.items;

import com.google.gson.Gson;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import com.gpperhour.itemcharges.triggers.TriggerItemContainer;
import com.gpperhour.itemcharges.triggers.TriggerItemDespawn;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.TileItem;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class U_GemBag
extends ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(U_GemBag.class);
    private final int CAPACITY = 60;
    private static final String pickpocketRegex = "The following stolen loot gets added to your gem bag: Uncut (.*) x (\\d+)";
    private static final Pattern pickpocketPattern = Pattern.compile("The following stolen loot gets added to your gem bag: Uncut (.*) x (\\d+)");
    private static final String checkRegex = "Sapphires: (\\d+) \\/ Emeralds: (\\d+) \\/ Rubies: (\\d+) Diamonds: (\\d+) \\/ Dragonstones: (\\d+)";
    private static final Pattern checkPattern = Pattern.compile("Sapphires: (\\d+) \\/ Emeralds: (\\d+) \\/ Rubies: (\\d+) Diamonds: (\\d+) \\/ Dragonstones: (\\d+)");
    private static final String acquireRegex = "^(You just (found|mined) (a|an) (Sapphire|Ruby|Emerald|Diamond))";
    private static final Pattern acquirePattern = Pattern.compile("^(You just (found|mined) (a|an) (Sapphire|Ruby|Emerald|Diamond))");

    public U_GemBag(Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        super(ChargesItem.GEM_BAG, 766, client, client_thread, configs, items, chat_messages, notifier, gson, executorService);
        this.config_key = "gem_bag";
        this.zero_charges_is_positive = true;
        this.triggers_items = new TriggerItem[]{new TriggerItem(12020), new TriggerItem(24481, true)};
        this.trigger_item_despawn = new TriggerItemDespawn(tileItem -> {
            if (tileItem.getId() == 1623 || tileItem.getId() == 1621 || tileItem.getId() == 1619 || tileItem.getId() == 1617 || tileItem.getId() == 1631) {
                this.addDespawnedGemIfHasCapacity((TileItem)tileItem);
            }
        });
        this.triggers_chat_messages = new TriggerChatMessage[]{new TriggerChatMessage("The gem bag is now empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage(acquireRegex).extraConsumer(message -> {
            if (!this.hasChargeData()) {
                return;
            }
            if (this.item_id != 24481) {
                return;
            }
            Matcher matcher = acquirePattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int gemID;
                    String gemName = matcher.group(4);
                    if (gemName.equals("Sapphire")) {
                        gemID = 1623;
                    } else if (gemName.equals("Emerald")) {
                        gemID = 1621;
                    } else if (gemName.equals("Ruby")) {
                        gemID = 1619;
                    } else if (gemName.equals("Diamond")) {
                        gemID = 1617;
                    } else {
                        throw new Exception("Gem name not matched.");
                    }
                    if (this.itemQuantities.containsKey(gemID) && !(this.itemQuantities.get(gemID).floatValue() < 60.0f)) continue;
                    super.addItems(gemID, Float.valueOf(1.0f));
                }
                catch (Exception e) {
                    log.error("couldn't find group match in gem bag acquire: " + message, (Throwable)e);
                }
            }
        }), new TriggerChatMessage(pickpocketRegex).extraConsumer(message -> {
            if (!this.hasChargeData()) {
                return;
            }
            Matcher matcher = pickpocketPattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int gemID;
                    String gemName = matcher.group(1);
                    if (gemName.equals("sapphire")) {
                        gemID = 1623;
                    } else if (gemName.equals("emerald")) {
                        gemID = 1621;
                    } else if (gemName.equals("ruby")) {
                        gemID = 1619;
                    } else if (gemName.equals("diamond")) {
                        gemID = 1617;
                    } else {
                        throw new Exception("Gem name not matched.");
                    }
                    int amount = Integer.parseInt(matcher.group(2));
                    super.addItems(gemID, Float.valueOf(amount));
                }
                catch (Exception e) {
                    log.error("couldn't find group match in gem bag acquire: " + message, (Throwable)e);
                }
            }
        }), new TriggerChatMessage("The gem bag is empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage(checkRegex).extraConsumer(message -> {
            super.emptyOrClear();
            Matcher matcher = checkPattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int sapphires = Integer.parseInt(matcher.group(1));
                    int emeralds = Integer.parseInt(matcher.group(2));
                    int rubies = Integer.parseInt(matcher.group(3));
                    int diamonds = Integer.parseInt(matcher.group(4));
                    int dragonstones = Integer.parseInt(matcher.group(5));
                    super.addItems(1623, Float.valueOf(sapphires));
                    super.addItems(1621, Float.valueOf(emeralds));
                    super.addItems(1619, Float.valueOf(rubies));
                    super.addItems(1617, Float.valueOf(diamonds));
                    super.addItems(1631, Float.valueOf(dragonstones));
                }
                catch (NumberFormatException e) {
                    log.error("couldn't parse gem bag check: " + message, (Throwable)e);
                }
            }
        })};
        this.triggers_item_containers = new TriggerItemContainer[]{new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open gem bag").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Gem bag").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.BANK.getId()).menuTarget("Open gem bag").menuOption("Empty").extraConsumer(() -> super.emptyOrClear()), new TriggerItemContainer(InventoryID.BANK.getId()).menuTarget("Gem bag").menuOption("Empty").extraConsumer(() -> super.emptyOrClear())};
        this.supportsWidgetOnWidget = true;
    }

    private void addDespawnedGemIfHasCapacity(TileItem tileItem) {
        if (tileItem.getQuantity() == 1 && (!this.itemQuantities.containsKey(tileItem.getId()) || this.itemQuantities.get(tileItem.getId()).floatValue() < 60.0f)) {
            super.addItems(tileItem.getId(), Float.valueOf(1.0f));
        }
    }
}

