/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges.items;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import com.gpperhour.itemcharges.triggers.TriggerItemContainer;
import com.gpperhour.itemcharges.triggers.TriggerMenuOption;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class U_FishBarrel
extends ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(U_FishBarrel.class);
    private final int FISH_BARREL_SIZE = 28;
    private static final String catchMessage = "^You catch (an?|some) ([a-zA-Z ]+)[.!]( It hardens as you handle it with your ice gloves\\.)?$";
    private static final Pattern catchPattern = Pattern.compile("^You catch (an?|some) ([a-zA-Z ]+)[.!]( It hardens as you handle it with your ice gloves\\.)?$");
    private static final String checkRegex = "([0-9]+) x ([a-zA-Z ]+),? ?";
    private static final Pattern checkPattern = Pattern.compile("([0-9]+) x ([a-zA-Z ]+),? ?");
    private Integer lastFishCaught = null;
    private static final Map<String, Integer> FISH_TYPES_BY_NAME = ImmutableMap.builder().put((Object)"shrimp", (Object)317).put((Object)"shrimps", (Object)317).put((Object)"sardine", (Object)327).put((Object)"herring", (Object)345).put((Object)"anchovies", (Object)321).put((Object)"mackerel", (Object)353).put((Object)"trout", (Object)335).put((Object)"cod", (Object)341).put((Object)"pike", (Object)349).put((Object)"slimy swamp eel", (Object)3379).put((Object)"salmon", (Object)331).put((Object)"tuna", (Object)359).put((Object)"rainbow fish", (Object)10138).put((Object)"cave eel", (Object)5001).put((Object)"lobster", (Object)377).put((Object)"bass", (Object)363).put((Object)"leaping trout", (Object)11328).put((Object)"swordfish", (Object)371).put((Object)"lava eel", (Object)2148).put((Object)"leaping salmon", (Object)11330).put((Object)"monkfish", (Object)7944).put((Object)"karambwan", (Object)3142).put((Object)"leaping sturgeon", (Object)11332).put((Object)"shark", (Object)383).put((Object)"infernal eel", (Object)21293).put((Object)"anglerfish", (Object)13439).put((Object)"dark crab", (Object)11934).put((Object)"sacred eel", (Object)13339).build();

    public U_FishBarrel(Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        super(ChargesItem.FISH_BARREL, 25582, client, client_thread, configs, items, chat_messages, notifier, gson, executorService);
        this.config_key = "fish_barrel";
        this.zero_charges_is_positive = true;
        this.triggers_items = new TriggerItem[]{new TriggerItem(25582), new TriggerItem(25584), new TriggerItem(25585), new TriggerItem(25587)};
        this.triggers_chat_messages = new TriggerChatMessage[]{new TriggerChatMessage("(Your|The) barrel is empty.").onItemClick().extraConsumer(message -> super.emptyOrClear()), new TriggerChatMessage("(You catch .*)").extraConsumer(message -> {
            if ((this.item_id == 25584 || this.item_id == 25587) && this.getItemCount() < 28 && super.hasChargeData()) {
                Matcher matcher = catchPattern.matcher((CharSequence)message);
                if (matcher.matches()) {
                    String fishName = matcher.group(2).toLowerCase();
                    if (FISH_TYPES_BY_NAME.containsKey(fishName)) {
                        Integer fishId;
                        this.lastFishCaught = fishId = FISH_TYPES_BY_NAME.get(fishName);
                        super.addItems(fishId, Float.valueOf(1.0f));
                    }
                } else {
                    log.error("no match found");
                }
            }
        }), new TriggerChatMessage("(.* enabled you to catch an extra fish.)").extraConsumer(message -> {
            if ((this.item_id == 25584 || this.item_id == 25587) && this.getItemCount() < 28 && super.hasChargeData()) {
                if (this.lastFishCaught != null) {
                    super.addItems(this.lastFishCaught, Float.valueOf(1.0f));
                } else {
                    log.error("last fish caught is null");
                }
            }
        }), new TriggerChatMessage("The barrel contains:").extraConsumer(message -> {
            super.emptyOrClear();
            Matcher matcher = checkPattern.matcher((CharSequence)message);
            while (matcher.find()) {
                try {
                    int fishAmount = Integer.parseInt(matcher.group(1));
                    String fishName = matcher.group(2).toLowerCase().replace("raw ", "");
                    if (FISH_TYPES_BY_NAME.containsKey(fishName)) {
                        Integer fishId = FISH_TYPES_BY_NAME.get(fishName);
                        super.addItems(fishId, Float.valueOf(fishAmount));
                        continue;
                    }
                    log.error("no match found");
                }
                catch (NumberFormatException e) {
                    log.error("couldn't parse fish barrel check", (Throwable)e);
                }
            }
        })};
        this.triggers_item_containers = new TriggerItemContainer[]{new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open fish barrel").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Fish barrel").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Open fish sack barrel").menuOption("Fill").addDifference(), new TriggerItemContainer(InventoryID.INVENTORY.getId()).menuTarget("Fish sack barrel").menuOption("Fill").addDifference()};
        this.triggers_menu_options = new TriggerMenuOption[]{new TriggerMenuOption("Open fish barrel", "Empty").extraConsumer(message -> super.emptyOrClear()), new TriggerMenuOption("Fish barrel", "Empty").extraConsumer(message -> super.emptyOrClear()), new TriggerMenuOption("Open fish sack barrel", "Empty").extraConsumer(message -> super.emptyOrClear()), new TriggerMenuOption("Fish sack barrel", "Empty").extraConsumer(message -> super.emptyOrClear())};
        this.supportsWidgetOnWidget = true;
    }
}

