/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges;

import com.google.gson.Gson;
import com.gpperhour.GPPerHourConfig;
import com.gpperhour.itemcharges.ChargedItem;
import com.gpperhour.itemcharges.items.S_KharedstMemoirs;
import com.gpperhour.itemcharges.items.U_AshSanctifier;
import com.gpperhour.itemcharges.items.U_BloodEssence;
import com.gpperhour.itemcharges.items.U_BottomlessCompostBucket;
import com.gpperhour.itemcharges.items.U_FishBarrel;
import com.gpperhour.itemcharges.items.U_GemBag;
import com.gpperhour.itemcharges.items.U_HerbSack;
import com.gpperhour.itemcharges.items.U_LogBasket;
import com.gpperhour.itemcharges.items.U_SeedBox;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargedItemManager {
    private static final Logger log = LoggerFactory.getLogger(ChargedItemManager.class);
    public static final int CHARGES_UNKNOWN = -1;
    public static final int CHARGES_UNLIMITED = -2;
    @Inject
    private Client client;
    @Inject
    private ClientThread client_thread;
    @Inject
    private ItemManager items;
    @Inject
    private ConfigManager configs;
    @Inject
    private GPPerHourConfig config;
    @Inject
    private ChatMessageManager chat_messages;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private Notifier notifier;
    @Inject
    private Gson gson;
    private ChargedItem[] chargedItems = new ChargedItem[0];
    private Map<Integer, Float> emptyMap = new HashMap<Integer, Float>();

    public void loadConfigData() {
        this.chargedItems = new ChargedItem[]{new U_FishBarrel(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_LogBasket(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new S_KharedstMemoirs(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_BottomlessCompostBucket(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_AshSanctifier(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_BloodEssence(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_GemBag(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_HerbSack(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService), new U_SeedBox(this.client, this.client_thread, this.configs, this.items, this.chat_messages, this.notifier, this.gson, this.executorService)};
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        log.debug("ITEM DESPAWNED | " + event.getItem().getId());
        for (ChargedItem chargedItem : this.chargedItems) {
            chargedItem.onItemDespawned(event);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        log.debug("STAT CHANGED | " + event.getSkill());
        for (ChargedItem chargedItem : this.chargedItems) {
            chargedItem.onStatChanged(event);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        log.debug("ITEM CONTAINER | " + event.getContainerId());
        for (ChargedItem chargedItem : this.chargedItems) {
            chargedItem.onItemContainersChanged(event);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onChatMessage(event));
        log.debug("MESSAGE | type: " + event.getType().name() + ", message: " + event.getMessage().replaceAll("</?col.*?>", "") + ", sender: " + event.getSender());
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onAnimationChanged(event));
        if (event.getActor() == this.client.getLocalPlayer()) {
            log.debug("ANIMATION | id: " + event.getActor().getAnimation());
        }
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onGraphicChanged(event));
        if (event.getActor() == this.client.getLocalPlayer()) {
            log.debug("GRAPHIC | id: " + event.getActor().getGraphic());
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onHitsplatApplied(event));
        log.debug("HITSPLAT | actor: " + (event.getActor() == this.client.getLocalPlayer() ? "self" : "enemy") + ", type: " + event.getHitsplat().getHitsplatType() + ", amount:" + event.getHitsplat().getAmount() + ", others = " + event.getHitsplat().isOthers() + ", mine = " + event.getHitsplat().isMine());
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onWidgetLoaded(event));
        log.debug("WIDGET | group: " + event.getGroupId());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        Arrays.stream(this.chargedItems).forEach(chargedItem -> chargedItem.onMenuOptionClicked(event));
        log.debug("OPTION | option: " + event.getMenuOption() + ", target: " + event.getMenuTarget() + ", action name: " + event.getMenuAction().name() + ", action id: " + event.getMenuAction().getId());
    }

    @Subscribe
    public void onGameTick(GameTick gametick) {
        for (ChargedItem chargedItem : this.chargedItems) {
            chargedItem.onGameTick(gametick);
        }
    }

    public boolean isChargeableItem(Integer itemId) {
        return this.getChargedItem(itemId) != null;
    }

    private ChargedItem getChargedItem(Integer itemId) {
        for (ChargedItem chargedItem : this.chargedItems) {
            if (chargedItem.item_id != itemId) continue;
            return chargedItem;
        }
        return null;
    }

    public boolean hasChargeData(Integer itemId) {
        ChargedItem chargedItem = this.getChargedItem(itemId);
        if (chargedItem == null) {
            log.warn("Didn't find a charged item for this itemID, this shouldn't happen.");
            return false;
        }
        return chargedItem.hasChargeData();
    }

    public Map<Integer, Float> getItemQuantities(Integer itemId) {
        ChargedItem chargedItem = this.getChargedItem(itemId);
        if (chargedItem == null) {
            log.warn("Didn't find a charged item for this itemID, this shouldn't happen.");
            return this.emptyMap;
        }
        return chargedItem.getItemQuantities();
    }
}

