/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour.itemcharges;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gpperhour.itemcharges.ChargesItem;
import com.gpperhour.itemcharges.triggers.TriggerAnimation;
import com.gpperhour.itemcharges.triggers.TriggerChatMessage;
import com.gpperhour.itemcharges.triggers.TriggerGraphic;
import com.gpperhour.itemcharges.triggers.TriggerHitsplat;
import com.gpperhour.itemcharges.triggers.TriggerItem;
import com.gpperhour.itemcharges.triggers.TriggerItemContainer;
import com.gpperhour.itemcharges.triggers.TriggerItemDespawn;
import com.gpperhour.itemcharges.triggers.TriggerMenuOption;
import com.gpperhour.itemcharges.triggers.TriggerReset;
import com.gpperhour.itemcharges.triggers.TriggerWidget;
import com.gpperhour.itemcharges.triggers.TriggerXPDrop;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargedItem {
    private static final Logger log = LoggerFactory.getLogger(ChargedItem.class);
    public final ChargesItem infobox_id;
    public int item_id;
    protected final Client client;
    protected final ClientThread client_thread;
    protected final ItemManager items;
    protected final ConfigManager configs;
    protected final ChatMessageManager chat_messages;
    protected final Notifier notifier;
    protected final Gson gson;
    protected final ScheduledExecutorService executorService;
    @Nullable
    public ItemContainer inventory;
    @Nullable
    protected ItemContainer equipment;
    @Nullable
    private Item[] inventory_items;
    @Nullable
    protected String config_key;
    @Nullable
    protected String[] extra_config_keys;
    @Nullable
    protected TriggerChatMessage[] triggers_chat_messages;
    @Nullable
    protected TriggerAnimation[] triggers_animations;
    @Nullable
    protected TriggerGraphic[] triggers_graphics;
    @Nullable
    protected TriggerHitsplat[] triggers_hitsplats;
    @Nullable
    protected TriggerItem[] triggers_items;
    @Nullable
    protected TriggerWidget[] triggers_widgets;
    @Nullable
    protected TriggerReset[] triggers_resets;
    @Nullable
    protected TriggerItemContainer[] triggers_item_containers;
    @Nullable
    protected TriggerMenuOption[] triggers_menu_options;
    @Nullable
    protected TriggerXPDrop[] triggers_xp_drops;
    @Nullable
    protected TriggerItemDespawn trigger_item_despawn;
    protected boolean supportsWidgetOnWidget = false;
    private PickupAction lastPickUpAction;
    private boolean in_equipment;
    private boolean in_inventory;
    private final List<String[]> menu_entries = new ArrayList<String[]>();
    private int animation = -1;
    private int graphic = -1;
    private int lastUseOnMeTick = -2;
    private boolean isInInventoryOrEquipment;
    protected int charges = -1;
    protected Map<Integer, Float> itemQuantities = null;
    @Nullable
    protected Integer negative_full_charges;
    protected boolean zero_charges_is_positive = false;
    protected boolean allow_chat_messages_when_not_present = false;
    private int gametick = 0;
    private int gametick_before = 0;
    private final Map<Integer, Integer> differenceMap = new HashMap<Integer, Integer>();
    private boolean itemQuantitiesNeedsSaving = false;
    private static final Map<String, Integer> nameToIdLookup = new HashMap<String, Integer>();

    public ChargedItem(ChargesItem infobox_id, int item_id, Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, ChatMessageManager chat_messages, Notifier notifier, Gson gson, ScheduledExecutorService executorService) {
        this.infobox_id = infobox_id;
        this.item_id = item_id;
        this.client = client;
        this.client_thread = client_thread;
        this.configs = configs;
        this.items = items;
        this.chat_messages = chat_messages;
        this.notifier = notifier;
        this.gson = gson;
        this.executorService = executorService;
        client_thread.invokeLater(() -> {
            this.loadChargesFromConfig();
            this.onChargesUpdated();
            this.onItemContainerUpdated(client.getItemContainer(InventoryID.INVENTORY));
            this.onItemContainerUpdated(client.getItemContainer(InventoryID.EQUIPMENT));
        });
    }

    protected void emptyOrClear() {
        if (this.itemQuantities == null) {
            this.itemQuantities = new HashMap<Integer, Float>();
        } else {
            this.itemQuantities.clear();
        }
        this.onItemQuantitiesModified();
    }

    protected void addItems(Integer itemId, Float count) {
        this.itemQuantities.merge(itemId, count, Float::sum);
        this.onItemQuantitiesModified();
    }

    protected Integer getItemCount() {
        if (this.itemQuantities == null) {
            return 0;
        }
        Float itemCount = Float.valueOf(0.0f);
        for (Float quantity : this.itemQuantities.values()) {
            itemCount = Float.valueOf(itemCount.floatValue() + quantity.floatValue());
        }
        return Math.round(itemCount.floatValue());
    }

    public boolean hasChargeData() {
        return this.charges != -1 || this.itemQuantities != null;
    }

    public void onStatChanged(StatChanged event) {
        if (!this.hasChargeData()) {
            return;
        }
        if (!this.isInInventoryOrEquipment) {
            return;
        }
        if (event.getXp() <= 0) {
            return;
        }
        if (this.triggers_xp_drops != null) {
            for (TriggerXPDrop trigger_xp_drop : this.triggers_xp_drops) {
                if (trigger_xp_drop.skill != event.getSkill() || !trigger_xp_drop.updateXP(event.getXp())) continue;
                this.decreaseCharges(trigger_xp_drop.discharges);
            }
        }
    }

    public void onItemDespawned(ItemDespawned event) {
        if (!this.hasChargeData()) {
            return;
        }
        if (!this.isInInventoryOrEquipment) {
            return;
        }
        if (this.triggers_items == null) {
            return;
        }
        if (this.trigger_item_despawn == null) {
            return;
        }
        if (this.lastPickUpAction == null) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation())) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.lastPickUpAction.getWorldPoint())) {
            return;
        }
        if (event.getItem().getId() != this.lastPickUpAction.getItemId()) {
            return;
        }
        for (TriggerItem triggerItem : this.triggers_items) {
            if (triggerItem.item_id != this.item_id || triggerItem.is_open_container) continue;
            return;
        }
        this.trigger_item_despawn.consumer.accept(event.getItem());
    }

    public void onItemContainersChanged(ItemContainerChanged event) {
        this.onItemContainerUpdated(event.getItemContainer());
    }

    protected void onItemContainerUpdated(ItemContainer itemContainer) {
        if (itemContainer == null) {
            return;
        }
        int containerId = itemContainer.getId();
        int items_difference = 0;
        if (containerId == InventoryID.INVENTORY.getId() && this.inventory_items != null) {
            items_difference = this.itemsDifference(this.inventory_items, itemContainer.getItems());
        }
        this.differenceMap.clear();
        if (containerId == InventoryID.INVENTORY.getId() && this.inventory_items != null) {
            Item[] before = this.inventory_items;
            Item[] after = itemContainer.getItems();
            for (Item beforeItem : before) {
                this.differenceMap.merge(beforeItem.getId(), 1, Integer::sum);
            }
            for (Item afterItem : after) {
                this.differenceMap.merge(afterItem.getId(), -1, Integer::sum);
            }
        }
        if (containerId == InventoryID.INVENTORY.getId() && this.itemQuantities != null && this.supportsWidgetOnWidget && (this.lastUseOnMeTick == this.client.getTickCount() || this.lastUseOnMeTick + 1 == this.client.getTickCount())) {
            for (Integer itemId : this.differenceMap.keySet()) {
                Integer count = this.differenceMap.get(itemId);
                if (count <= 0) continue;
                this.addItems(itemId, Float.valueOf(count.intValue()));
            }
        }
        if (containerId == InventoryID.INVENTORY.getId()) {
            this.inventory = itemContainer;
            this.inventory_items = this.inventory.getItems();
        }
        if (this.triggers_item_containers != null) {
            for (TriggerItemContainer trigger_item_container : this.triggers_item_containers) {
                if (trigger_item_container.inventory_id != containerId || trigger_item_container.menu_target != null && this.menu_entries.stream().noneMatch(entry -> entry[0].equals(trigger_item_container.menu_target)) || trigger_item_container.menu_option != null && this.menu_entries.stream().noneMatch(entry -> entry[1].equals(trigger_item_container.menu_option))) continue;
                if (trigger_item_container.fixed_charges != null) {
                    this.setCharges(trigger_item_container.fixed_charges);
                    break;
                }
                if (trigger_item_container.increase_by_difference) {
                    this.increaseCharges(items_difference);
                    break;
                }
                if (trigger_item_container.add_difference && this.itemQuantities != null) {
                    for (Integer itemId : this.differenceMap.keySet()) {
                        Integer count = this.differenceMap.get(itemId);
                        if (count == 0) continue;
                        this.addItems(itemId, Float.valueOf(count.intValue()));
                    }
                    break;
                }
                if (trigger_item_container.extra_consumer == null) continue;
                trigger_item_container.extra_consumer.run();
                break;
            }
        }
        if (containerId == InventoryID.INVENTORY.getId()) {
            this.inventory = itemContainer;
        } else if (containerId == InventoryID.EQUIPMENT.getId()) {
            this.equipment = itemContainer;
        }
        if (this.triggers_items == null) {
            return;
        }
        boolean in_equipment = false;
        boolean in_inventory = false;
        boolean inInventoryOrEquipment = false;
        Integer charges = null;
        for (TriggerItem trigger_item : this.triggers_items) {
            boolean in_inventory_item;
            boolean in_equipment_item = this.equipment != null && this.equipment.contains(trigger_item.item_id);
            boolean bl = in_inventory_item = this.inventory != null && this.inventory.contains(trigger_item.item_id);
            if (in_inventory_item || in_equipment_item) {
                inInventoryOrEquipment = true;
                if (trigger_item.item_id != this.item_id) {
                    this.updateItemId(trigger_item.item_id);
                }
                if (in_equipment_item) {
                    in_equipment = true;
                }
                if (in_inventory_item) {
                    in_inventory = true;
                }
            }
            if (!in_equipment_item && !in_inventory_item || trigger_item.fixed_charges == null) continue;
            if (charges == null) {
                charges = 0;
            }
            charges = charges + (this.inventory != null ? this.inventory.count(trigger_item.item_id) * trigger_item.fixed_charges : 0);
            charges = charges + (this.equipment != null ? this.equipment.count(trigger_item.item_id) * trigger_item.fixed_charges : 0);
        }
        this.in_equipment = in_equipment;
        this.in_inventory = in_inventory;
        this.isInInventoryOrEquipment = inInventoryOrEquipment;
        if (charges != null) {
            this.charges = charges;
        }
    }

    public void onChatMessage(ChatMessage event) {
        if (this.triggers_chat_messages == null || event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.MESBOX || this.config_key == null || !this.isInInventoryOrEquipment && !this.allow_chat_messages_when_not_present) {
            return;
        }
        String message = event.getMessage().replaceAll("</?col.*?>", "").replace("<br>", " ").replace("\u00a0", " ");
        for (TriggerChatMessage chat_message : this.triggers_chat_messages) {
            Pattern regex = chat_message.message;
            Matcher matcher = regex.matcher(message);
            if (!matcher.find() || chat_message.menu_target && this.menu_entries.stream().noneMatch(entry -> entry[0].equals(this.items.getItemComposition(this.item_id).getName())) || chat_message.equipped && !this.in_equipment) continue;
            if (chat_message.increase_charges != null) {
                this.increaseCharges(chat_message.increase_charges);
            } else if (chat_message.decrease_charges != null) {
                this.decreaseCharges(chat_message.decrease_charges);
            } else if (chat_message.fixed_charges != null) {
                this.setCharges(chat_message.fixed_charges);
            } else if (chat_message.multiple_charges) {
                int charges = 0;
                Matcher matcher_multiple = Pattern.compile(".*?(\\d+)").matcher(message);
                while (matcher_multiple.find()) {
                    charges += Integer.parseInt(matcher_multiple.group(1));
                }
                this.setCharges(charges);
            } else if (chat_message.consumer != null) {
                chat_message.consumer.accept(message);
            } else {
                if (matcher.group("charges") == null) continue;
                try {
                    int charges = Integer.parseInt(matcher.group("charges").replaceAll(",", "").replaceAll("\\.", ""));
                    if (chat_message.increase_dynamically) {
                        this.increaseCharges(charges);
                    } else if (chat_message.decrease_dynamically) {
                        this.decreaseCharges(charges);
                    } else {
                        this.setCharges(charges);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.extra_config_keys != null) {
                for (String extra_group : this.extra_config_keys) {
                    String extra = matcher.group(extra_group);
                    if (extra == null) continue;
                    this.setConfiguration(this.config_key + "_" + extra_group, extra.replaceAll(",", ""));
                    this.onChargesUpdated();
                }
            }
            if (chat_message.notification) {
                this.notifier.notify(chat_message.notification_message != null ? chat_message.notification_message : message);
            }
            return;
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (this.triggers_widgets == null || this.config_key == null) {
            return;
        }
        this.client_thread.invokeLater(() -> {
            for (TriggerWidget trigger_widget : this.triggers_widgets) {
                if (event.getGroupId() != trigger_widget.group_id) continue;
                Widget widget = this.client.getWidget(trigger_widget.group_id, trigger_widget.child_id);
                if (trigger_widget.sub_child_id != null && widget != null) {
                    widget = widget.getChild(trigger_widget.sub_child_id.intValue());
                }
                if (widget == null) continue;
                String message = widget.getText().replaceAll("</?col.*?>", "").replaceAll("<br>", " ");
                Pattern regex = Pattern.compile(trigger_widget.message);
                Matcher matcher = regex.matcher(message);
                if (!matcher.find()) continue;
                if (trigger_widget.charges != null) {
                    this.setCharges(trigger_widget.charges);
                } else if (trigger_widget.consumer != null) {
                    trigger_widget.consumer.accept(message);
                } else if (matcher.group("charges") != null) {
                    int charges = Integer.parseInt(matcher.group("charges").replaceAll(",", ""));
                    if (trigger_widget.increase_dynamically) {
                        this.increaseCharges(charges);
                    } else {
                        this.setCharges(charges);
                    }
                }
                if (this.extra_config_keys == null) continue;
                for (String extra_group : this.extra_config_keys) {
                    String extra = matcher.group(extra_group);
                    if (extra == null) continue;
                    this.setConfiguration(this.config_key + "_" + extra_group, extra);
                }
            }
        });
    }

    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        this.animation = event.getActor().getAnimation();
        if (this.inventory == null || this.triggers_animations == null || this.charges == -1 || this.triggers_items == null) {
            return;
        }
        for (TriggerAnimation trigger_animation : this.triggers_animations) {
            if (trigger_animation.animation_id != event.getActor().getAnimation()) continue;
            if (trigger_animation.unallowed_items != null) {
                boolean unallowed_items = false;
                for (int item_id : trigger_animation.unallowed_items) {
                    if (!this.inventory.contains(item_id) && (this.equipment == null || !this.equipment.contains(item_id))) continue;
                    unallowed_items = true;
                    break;
                }
                if (unallowed_items) continue;
            }
            if (trigger_animation.equipped) {
                boolean equipped = false;
                for (TriggerItem trigger_item : this.triggers_items) {
                    if (this.equipment == null || !this.equipment.contains(trigger_item.item_id)) continue;
                    equipped = true;
                    break;
                }
                if (!equipped) continue;
            }
            if (trigger_animation.menu_target && this.menu_entries.stream().noneMatch(entry -> entry[0].equals(this.items.getItemComposition(this.item_id).getName())) || trigger_animation.menu_option != null && this.menu_entries.stream().noneMatch(entry -> entry[1].equals(trigger_animation.menu_option))) continue;
            if (trigger_animation.decrease_charges) {
                this.decreaseCharges(trigger_animation.charges);
                continue;
            }
            this.increaseCharges(trigger_animation.charges);
        }
    }

    public void onGraphicChanged(GraphicChanged event) {
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        this.graphic = event.getActor().getGraphic();
        if (this.inventory == null || this.triggers_graphics == null || this.charges == -1 || this.triggers_items == null) {
            return;
        }
        for (TriggerGraphic trigger_graphic : this.triggers_graphics) {
            if (!event.getActor().hasSpotAnim(trigger_graphic.graphic_id)) continue;
            if (trigger_graphic.unallowed_items != null) {
                boolean unallowed_items = false;
                for (int item_id : trigger_graphic.unallowed_items) {
                    if (!this.inventory.contains(item_id) && (this.equipment == null || !this.equipment.contains(item_id))) continue;
                    unallowed_items = true;
                    break;
                }
                if (unallowed_items) continue;
            }
            if (trigger_graphic.equipped) {
                boolean equipped = false;
                for (TriggerItem trigger_item : this.triggers_items) {
                    if (this.equipment == null || !this.equipment.contains(trigger_item.item_id)) continue;
                    equipped = true;
                    break;
                }
                if (!equipped) continue;
            }
            if (trigger_graphic.menu_option != null && this.menu_entries.stream().noneMatch(entry -> entry[1].equals(trigger_graphic.menu_option))) continue;
            if (trigger_graphic.decrease_charges) {
                this.decreaseCharges(trigger_graphic.charges);
                continue;
            }
            this.increaseCharges(trigger_graphic.charges);
        }
    }

    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.triggers_hitsplats == null) {
            return;
        }
        for (TriggerHitsplat trigger_hitsplat : this.triggers_hitsplats) {
            if (trigger_hitsplat.self && event.getActor() != this.client.getLocalPlayer() || !trigger_hitsplat.self && (event.getActor() == this.client.getLocalPlayer() || event.getHitsplat().isOthers()) || trigger_hitsplat.hitsplat_id != event.getHitsplat().getHitsplatType()) continue;
            if (trigger_hitsplat.equipped && this.triggers_items != null && this.equipment != null) {
                boolean equipped = false;
                for (TriggerItem trigger_item : this.triggers_items) {
                    if (!this.equipment.contains(trigger_item.item_id)) continue;
                    equipped = true;
                    break;
                }
                if (!equipped) continue;
            }
            if (trigger_hitsplat.animations != null) {
                boolean valid = false;
                for (int animation : trigger_hitsplat.animations) {
                    if (animation != this.animation) continue;
                    valid = true;
                    break;
                }
                if (!valid) continue;
            }
            this.decreaseCharges(trigger_hitsplat.discharges);
        }
    }

    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.GROUND_ITEM_THIRD_OPTION && event.getMenuOption().equals("Take")) {
            WorldPoint point = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
            this.lastPickUpAction = new PickupAction(event.getId(), point);
        }
        if (event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && this.supportsWidgetOnWidget) {
            boolean usedItemOnMe;
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            if (itemContainer == null) {
                return;
            }
            Widget widgetA = this.client.getSelectedWidget();
            if (widgetA == null) {
                return;
            }
            Item itemA = itemContainer.getItem(widgetA.getIndex());
            if (itemA == null) {
                return;
            }
            int itemAId = itemA.getId();
            Widget widgetB = event.getWidget();
            if (widgetB == null) {
                return;
            }
            Item itemB = itemContainer.getItem(widgetB.getIndex());
            if (itemB == null) {
                return;
            }
            int itemBId = itemB.getId();
            boolean bl = usedItemOnMe = this.item_id == itemAId || this.item_id == itemBId;
            if (usedItemOnMe) {
                this.lastUseOnMeTick = this.client.getTickCount();
            }
        }
        String menu_target = event.getMenuTarget().replaceAll("</?col.*?>", "");
        String menu_option = event.getMenuOption();
        if (menu_target.length() == 0 || !this.in_inventory && !this.in_equipment || menu_option == null || menu_option.length() == 0) {
            return;
        }
        if (this.gametick > this.gametick_before + 1) {
            this.gametick = 0;
            this.gametick_before = 0;
            this.menu_entries.clear();
        }
        this.menu_entries.add(new String[]{menu_target, menu_option});
        if (this.triggers_menu_options == null) {
            return;
        }
        for (TriggerMenuOption trigger_menu_option : this.triggers_menu_options) {
            if (!trigger_menu_option.option.equals(menu_option) || trigger_menu_option.target != null && !trigger_menu_option.target.equals(menu_target)) continue;
            new Thread(() -> {
                try {
                    Thread.sleep(600L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (trigger_menu_option.charges != null) {
                    this.setCharges(trigger_menu_option.charges);
                } else {
                    trigger_menu_option.consumer.accept(menu_target);
                }
            }).start();
            return;
        }
    }

    public void resetCharges() {
        if (this.triggers_resets == null) {
            return;
        }
        if (this.in_equipment || this.in_inventory) {
            this.client_thread.invokeLater(() -> this.chat_messages.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage("<colHIGHLIGHT>" + this.items.getItemComposition(this.item_id).getName() + " daily charges have been reset.").build()));
        }
        for (TriggerReset trigger_reset : this.triggers_resets) {
            if (trigger_reset.item_id != null) {
                if (this.item_id != trigger_reset.item_id) continue;
                this.setCharges(trigger_reset.charges);
                continue;
            }
            this.setCharges(trigger_reset.charges);
        }
    }

    private void loadChargesFromConfig() {
        if (this.config_key == null) {
            return;
        }
        try {
            this.charges = Integer.parseInt(this.configs.getRSProfileConfiguration("gpperhour", this.config_key));
            return;
        }
        catch (Exception exception) {
            try {
                Type mapType = new TypeToken<Map<Integer, Float>>(){}.getType();
                this.itemQuantities = (Map)this.gson.fromJson(this.configs.getRSProfileConfiguration("gpperhour", this.config_key), mapType);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public void setCharges(int charges) {
        if (this.negative_full_charges != null && charges > this.negative_full_charges) {
            return;
        }
        this.charges = charges;
        this.onChargesUpdated();
        if (this.config_key != null) {
            this.setConfiguration(this.config_key, charges);
        }
    }

    private void onItemQuantitiesModified() {
        this.itemQuantitiesNeedsSaving = true;
    }

    private void saveItemQuantities() {
        this.itemQuantitiesNeedsSaving = false;
        this.executorService.execute(() -> {
            if (this.config_key != null) {
                this.setConfiguration(this.config_key, this.gson.toJson(this.itemQuantities));
            }
        });
    }

    private void decreaseCharges(int charges) {
        if (this.charges - charges < 0) {
            return;
        }
        this.setCharges(this.charges - charges);
    }

    public void increaseCharges(int charges) {
        if (this.charges < 0) {
            return;
        }
        this.setCharges(this.charges + charges);
    }

    private void setConfiguration(String key, @Nonnull String value) {
        this.configs.setRSProfileConfiguration("gpperhour", key, (Object)value);
    }

    private void setConfiguration(String key, int value) {
        this.configs.setRSProfileConfiguration("gpperhour", key, (Object)value);
    }

    private void updateItemId(int item_id) {
        this.item_id = item_id;
    }

    protected void onChargesUpdated() {
    }

    public void onGameTick(GameTick ignored) {
        ++this.gametick;
        if (this.itemQuantitiesNeedsSaving) {
            this.saveItemQuantities();
        }
    }

    private int itemsDifference(Item[] items_before, Item[] items_after) {
        int items_before_count = (int)Arrays.stream(items_before).filter(item -> item.getId() != -1).count();
        int items_after_count = (int)Arrays.stream(items_after).filter(item -> item.getId() != -1).count();
        return Math.abs(items_before_count - items_after_count);
    }

    protected Integer tryFindItemIdFromName(String name) {
        if (nameToIdLookup.containsKey(name = name.toLowerCase().trim())) {
            return nameToIdLookup.get(name);
        }
        List results = this.items.search(name);
        if (results != null && !results.isEmpty()) {
            for (ItemPrice result : results) {
                if (!result.getName().toLowerCase().equals(name)) continue;
                nameToIdLookup.put(name, result.getId());
                return result.getId();
            }
        }
        return null;
    }

    public Map<Integer, Float> getItemQuantities() {
        return this.itemQuantities;
    }

    public class PickupAction {
        int itemId;
        WorldPoint worldPoint;

        public int getItemId() {
            return this.itemId;
        }

        public WorldPoint getWorldPoint() {
            return this.worldPoint;
        }

        public void setItemId(int itemId) {
            this.itemId = itemId;
        }

        public void setWorldPoint(WorldPoint worldPoint) {
            this.worldPoint = worldPoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PickupAction)) {
                return false;
            }
            PickupAction other = (PickupAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            WorldPoint this$worldPoint = this.getWorldPoint();
            WorldPoint other$worldPoint = other.getWorldPoint();
            return !(this$worldPoint == null ? other$worldPoint != null : !this$worldPoint.equals(other$worldPoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PickupAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemId();
            WorldPoint $worldPoint = this.getWorldPoint();
            result = result * 59 + ($worldPoint == null ? 43 : $worldPoint.hashCode());
            return result;
        }

        public String toString() {
            return "ChargedItem.PickupAction(itemId=" + this.getItemId() + ", worldPoint=" + this.getWorldPoint() + ")";
        }

        public PickupAction(int itemId, WorldPoint worldPoint) {
            this.itemId = itemId;
            this.worldPoint = worldPoint;
        }
    }
}

