/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPlugin;
import com.gpperhour.LedgerItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UI {
    private static final Logger log = LoggerFactory.getLogger(UI.class);
    public static final ImageIcon PAUSE_ICON;
    public static final ImageIcon PLAY_ICON;
    public static final ImageIcon SESSIONINFO_GEAR_ICON;
    public static final ImageIcon SESSIONINFO_REFRESH_ICON;
    public static final ImageIcon SESSIONINFO_WRENCH_ICON;
    public static final ImageIcon SESSIONINFO_STOP_ICON;
    public static final ImageIcon SESSIONINFO_PLAY_ICON;
    public static final ImageIcon SESSIONINFO_TRASH_ICON;
    public static final ImageIcon SESSIONINFO_SAVE_ICON;
    public static final ImageIcon SESSIONINFO_GEAR_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_REFRESH_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_WRENCH_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_STOP_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_PLAY_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_TRASH_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_SAVE_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_INFO_ICON;
    public static final ImageIcon SESSIONINFO_INFO_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_GRID_ICON;
    public static final ImageIcon SESSIONINFO_GRID_HOVER_ICON;
    public static final ImageIcon SESSIONINFO_PLUS_ICON;
    public static final ImageIcon SESSIONINFO_PLUS_HOVER_ICON;
    private static final String PROFIT_LOSS_TIME_FORMAT = "%01d:%02d:%02d";
    private static final String PROFIT_LOSS_TIME_NO_HOURS_FORMAT = "%01d:%02d";
    private static final NumberFormat englishFormat;
    private static final Color redLootBackgroundColor;
    private static final Color greenLootBackgroundColor;
    private static final int ITEMS_PER_ROW = 5;
    private static final Dimension ITEM_SIZE;
    private static final float roundMultiplier = 100.0f;

    public static String formatQuantity(float quantity, boolean absolute) {
        if (absolute) {
            quantity = Math.abs(quantity);
        }
        quantity = (float)Math.round(quantity * 100.0f) / 100.0f;
        String text = englishFormat.format(quantity);
        return text;
    }

    public static JLabel createIconButton(final ImageIcon defaultIcon, final ImageIcon hoverIcon, String tooltipText, final Runnable onClick) {
        final JLabel label = new JLabel(defaultIcon);
        label.setToolTipText(tooltipText);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    onClick.run();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setIcon(hoverIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setIcon(defaultIcon);
            }
        });
        return label;
    }

    public static boolean ledgersMatch(List<LedgerItem> ledgerOne, List<LedgerItem> ledgerTwo) {
        if (ledgerOne == null || ledgerTwo == null) {
            return false;
        }
        if (ledgerOne.size() != ledgerTwo.size()) {
            return false;
        }
        for (int i = 0; i < ledgerOne.size(); ++i) {
            LedgerItem itemOne = ledgerOne.get(i);
            LedgerItem itemTwo = ledgerTwo.get(i);
            if (itemOne.getQty() != itemTwo.getQty()) {
                return false;
            }
            if (itemOne.getItemId() != itemTwo.getItemId()) {
                return false;
            }
            if (itemOne.getPrice() == itemTwo.getPrice()) continue;
            return false;
        }
        return true;
    }

    public static String getTimeAgo(long timestamp) {
        long currentTime = Instant.now().toEpochMilli();
        long timeDiff = currentTime - timestamp;
        if (timeDiff < 0L) {
            return "In the future";
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeDiff) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(timeDiff);
        long days = TimeUnit.MILLISECONDS.toDays(timeDiff);
        if (days > 0L) {
            return days + " day" + (days > 1L ? "s" : "") + " ago";
        }
        if (hours > 0L) {
            return hours + " hour" + (hours > 1L ? "s" : "") + " and " + minutes + " minute" + (minutes != 1L ? "s" : "") + " ago";
        }
        if (minutes > 0L) {
            return minutes + " minute" + (minutes > 1L ? "s" : "") + " ago";
        }
        return "less than a minute ago";
    }

    public static void clearListeners(AbstractButton button) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = button.getActionListeners()) {
            button.removeActionListener(listener);
        }
    }

    public static Component addVerticalRigidBox(Container container, int size) {
        return container.add(Box.createRigidArea(new Dimension(0, size)));
    }

    public static String formatTime(long millis) {
        long totalSecs = millis / 1000L;
        long totalMins = totalSecs / 60L;
        long hrs = totalMins / 60L;
        long mins = totalMins % 60L;
        long secs = totalSecs % 60L;
        if (hrs > 0L) {
            return String.format(PROFIT_LOSS_TIME_FORMAT, hrs, mins, secs);
        }
        return String.format(PROFIT_LOSS_TIME_NO_HOURS_FORMAT, mins, secs);
    }

    public static List<LedgerItem> sortLedger(List<LedgerItem> ledger) {
        ledger = ledger.stream().sorted(Comparator.comparingLong(o -> -o.getCombinedValue())).collect(Collectors.toList());
        return ledger;
    }

    public static String buildToolTip(String name, String quantity, String price, String combinedValue) {
        return "<html>" + name + " x " + quantity + "<br/>Price: " + price + "<br/>Total: " + combinedValue + "</html>";
    }

    public static long getGpPerHour(long runTime, long total) {
        float hours = (float)runTime / 3600000.0f;
        long gpPerHour = (long)((float)total / hours);
        return gpPerHour;
    }

    public static String formatGp(long value, boolean showExact) {
        if (showExact) {
            return QuantityFormatter.formatNumber((long)value);
        }
        return QuantityFormatter.quantityToStackSize((long)value);
    }

    public static String formatGp(double value, boolean showExact) {
        if (showExact || Math.abs(value) < 10.0) {
            return QuantityFormatter.formatNumber((double)value);
        }
        return QuantityFormatter.quantityToStackSize((long)Math.round(value));
    }

    static void updateLootGrid(List<LedgerItem> ledger, LootPanelData lootPanelData, ItemManager itemManager, GPPerHourConfig config) {
        JPanel slot;
        if (UI.ledgersMatch(ledger, lootPanelData.previousLedger)) {
            return;
        }
        lootPanelData.previousLedger = ledger;
        JPanel containerCurrent = new JPanel();
        int totalItems = ledger.size();
        int rowSize = (totalItems % 5 == 0 ? 0 : 1) + totalItems / 5;
        lootPanelData.containerPanel.setLayout(new GridLayout(rowSize, 5, 1, 1));
        containerCurrent.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (LedgerItem ledgerItem : ledger) {
            slot = new JPanel();
            boolean wasGain = ledgerItem.getQty() > 0.0f;
            slot.setLayout(new GridLayout(1, 1, 0, 0));
            slot.setBackground(wasGain ? greenLootBackgroundColor : redLootBackgroundColor);
            slot.setPreferredSize(ITEM_SIZE);
            JLabel itemLabel = new JLabel();
            itemLabel.setToolTipText(UI.buildToolTip(ledgerItem.getDescription(), UI.formatQuantity(ledgerItem.getQty(), false), UI.formatGp(ledgerItem.getPrice(), config.showExactGp()), UI.formatGp(ledgerItem.getCombinedValue(), config.showExactGp())));
            itemLabel.setVerticalAlignment(0);
            itemLabel.setHorizontalAlignment(0);
            AsyncBufferedImage itemImage = itemManager.getImage(ledgerItem.getItemId(), (int)Math.ceil(Math.abs(ledgerItem.getQty())), Math.ceil(Math.abs(ledgerItem.getQty())) > 1.0);
            itemImage.addTo(itemLabel);
            slot.add(itemLabel);
            containerCurrent.add(slot);
        }
        if (totalItems < 5 || totalItems % 5 != 0) {
            int extraBoxes;
            if (totalItems % 5 != 0 && totalItems >= 5) {
                int i = totalItems;
                while (i % 5 != 0) {
                    ++i;
                }
                extraBoxes = i - totalItems;
            } else {
                extraBoxes = 5 - totalItems;
            }
            for (int i = 0; i < extraBoxes; ++i) {
                slot = new JPanel();
                slot.setLayout(new GridLayout(1, 1, 0, 0));
                slot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                slot.setPreferredSize(ITEM_SIZE);
                containerCurrent.add(slot);
            }
        }
        lootPanelData.lootPanel.remove(lootPanelData.containerPanel);
        lootPanelData.containerPanel = containerCurrent;
        lootPanelData.lootPanel.add(lootPanelData.containerPanel);
        lootPanelData.lootPanel.revalidate();
        lootPanelData.lootPanel.repaint();
    }

    static {
        englishFormat = NumberFormat.getInstance(Locale.ENGLISH);
        redLootBackgroundColor = new Color(48, 15, 15);
        greenLootBackgroundColor = new Color(21, 43, 16);
        ITEM_SIZE = new Dimension(40, 40);
        BufferedImage pausePNG = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-pause.png");
        BufferedImage playPNG = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-play.png");
        PAUSE_ICON = new ImageIcon(pausePNG);
        PLAY_ICON = new ImageIcon(playPNG);
        float hoverAlphaOffset = 0.53f;
        BufferedImage importIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-gear.png");
        SESSIONINFO_GEAR_ICON = new ImageIcon(importIcon);
        SESSIONINFO_GEAR_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)importIcon, (float)0.53f));
        BufferedImage refreshIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-refresh.png");
        SESSIONINFO_REFRESH_ICON = new ImageIcon(refreshIcon);
        SESSIONINFO_REFRESH_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)refreshIcon, (float)0.53f));
        BufferedImage wrenchIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-wrench.png");
        SESSIONINFO_WRENCH_ICON = new ImageIcon(wrenchIcon);
        SESSIONINFO_WRENCH_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)wrenchIcon, (float)0.53f));
        BufferedImage stopIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-stop.png");
        SESSIONINFO_STOP_ICON = new ImageIcon(stopIcon);
        SESSIONINFO_STOP_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)stopIcon, (float)0.53f));
        BufferedImage playIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-play.png");
        SESSIONINFO_PLAY_ICON = new ImageIcon(playIcon);
        SESSIONINFO_PLAY_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)playIcon, (float)0.53f));
        BufferedImage trashIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-trash.png");
        SESSIONINFO_TRASH_ICON = new ImageIcon(trashIcon);
        SESSIONINFO_TRASH_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)trashIcon, (float)0.53f));
        BufferedImage saveIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-save.png");
        SESSIONINFO_SAVE_ICON = new ImageIcon(saveIcon);
        SESSIONINFO_SAVE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)saveIcon, (float)0.53f));
        BufferedImage infoIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-info.png");
        SESSIONINFO_INFO_ICON = new ImageIcon(infoIcon);
        SESSIONINFO_INFO_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)infoIcon, (float)0.53f));
        BufferedImage gridIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-grid.png");
        SESSIONINFO_GRID_ICON = new ImageIcon(gridIcon);
        SESSIONINFO_GRID_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)gridIcon, (float)0.53f));
        BufferedImage plusIcon = ImageUtil.loadImageResource(GPPerHourPlugin.class, (String)"/gpperhour-session-plus.png");
        SESSIONINFO_PLUS_ICON = new ImageIcon(plusIcon);
        SESSIONINFO_PLUS_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)plusIcon, (float)0.53f));
    }

    public static class LootPanelData {
        JPanel lootPanel = new JPanel();
        JPanel containerPanel = new JPanel();
        List<LedgerItem> previousLedger = new LinkedList<LedgerItem>();
    }
}

