/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.EditableNameField;
import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPlugin;
import com.gpperhour.RoundedPanel;
import com.gpperhour.SessionManager;
import com.gpperhour.SessionStats;
import com.gpperhour.UI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class SessionHistoryPanel
extends JPanel {
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private static final String durationLabelPrefix = "Duration: ";
    private static final String gpPerHourLabelPrefix = "GP/hr: ";
    private static final String netTotalLabelPrefix = "Net Total: ";
    private static final String totalGainsLabelPrefix = "Gains: ";
    private static final String totalLossesLabelPrefix = "Losses: ";
    private static final String tripCountLabelPrefix = "Trip Count: ";
    private static final String avgTripDurationLabelPrefix = "Avg Trip Time: ";
    private static final Color borderColor = new Color(57, 57, 57);
    private final GPPerHourConfig config;
    private final GPPerHourPlugin plugin;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final SessionManager sessionManager;
    GridBagConstraints constraints = new GridBagConstraints();
    private final List<SessionHistoryPanelData> historyPanels = new LinkedList<SessionHistoryPanelData>();
    private final IconTextField searchBar = new IconTextField();
    private final JPanel historyPanelContainer = new JPanel();
    private final JScrollPane resultsWrapper;

    SessionHistoryPanel(GPPerHourPlugin plugin, GPPerHourConfig config, ItemManager itemManager, ClientThread clientThread, SessionManager sessionManager) {
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.sessionManager = sessionManager;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(5, 15));
        container.setBorder(new EmptyBorder(15, 5, 5, 5));
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(100, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addKeyListener((java.awt.event.KeyListener)new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                SessionHistoryPanel.this.redrawPanels(true);
            }
        });
        this.searchBar.addClearListener(() -> this.redrawPanels(true));
        this.historyPanelContainer.setLayout(new GridBagLayout());
        this.historyPanelContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.insets = new Insets(0, 0, 10, 0);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.historyPanelContainer, "North");
        this.resultsWrapper = new JScrollPane(wrapper);
        this.resultsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.resultsWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        this.resultsWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(0, 5, 0, 0));
        this.resultsWrapper.setHorizontalScrollBarPolicy(31);
        this.resultsWrapper.setVisible(true);
        container.add((Component)this.searchBar, "North");
        container.add((Component)this.resultsWrapper, "Center");
        this.add((Component)container, "Center");
    }

    void redrawPanels(boolean resetScroll) {
        this.updateSessions();
        if (resetScroll) {
            this.resultsWrapper.getVerticalScrollBar().setValue(0);
        }
    }

    void updateSessions() {
        List<SessionStats> sessions = this.sessionManager.sessionHistory;
        if (!this.searchBar.getText().isEmpty()) {
            sessions = this.filterSessions(sessions, this.searchBar.getText());
        }
        sessions = sessions.stream().sorted(Comparator.comparingLong(o -> -o.getSessionSaveTime())).collect(Collectors.toList());
        for (int sessionIndex = 0; sessionIndex < sessions.size(); ++sessionIndex) {
            this.ensurePanelCount(sessionIndex + 1);
            this.renderHistoryPanel(sessions.get(sessionIndex), this.historyPanels.get(sessionIndex));
        }
        for (int i = sessionIndex; i < this.historyPanels.size(); ++i) {
            this.historyPanels.get((int)i).masterPanel.setVisible(false);
        }
        this.repaint();
        this.revalidate();
    }

    public List<SessionStats> filterSessions(List<SessionStats> sessionStats, String textToFilter) {
        String textToFilterLower = textToFilter.toLowerCase();
        return sessionStats.stream().filter(i -> i.getSessionName().toLowerCase().contains(textToFilterLower)).collect(Collectors.toList());
    }

    void renderHistoryPanel(SessionStats stats, SessionHistoryPanelData panelData) {
        panelData.masterPanel.setVisible(true);
        panelData.nameField.setData(stats.sessionName, newName -> {
            stats.sessionName = newName;
            this.sessionManager.overwriteSession(stats);
        });
        SimpleDateFormat sdfLeft = new SimpleDateFormat("MMM dd, yyyy   h:mm a", Locale.US);
        Date date = new Date(stats.getSessionSaveTime());
        String formattedDateLeft = sdfLeft.format(date);
        panelData.subtitleLeft.setText(formattedDateLeft);
        long gpPerHourLong = UI.getGpPerHour(stats.getSessionRuntime(), stats.getNetTotal());
        String gpPerHour = UI.formatGp(gpPerHourLong, this.config.showExactGp()) + "/hr";
        panelData.gpPerHourTabLabel.setText(gpPerHour);
        int gpPerHourCoinsImage = Math.abs((int)gpPerHourLong);
        this.getCoinsImage(gpPerHourCoinsImage /= 100, image -> panelData.coinsLabel.setIcon(new ImageIcon((Image)image)), stats);
        panelData.detailsPanel.setVisible(stats.showDetails);
        if (stats.showDetails) {
            panelData.gpPerHourLabel.setText(SessionHistoryPanel.htmlLabel(gpPerHourLabelPrefix, gpPerHour));
            panelData.netTotalLabel.setText(SessionHistoryPanel.htmlLabel(netTotalLabelPrefix, UI.formatQuantity(stats.getNetTotal(), false)));
            panelData.totalGainsLabel.setText(SessionHistoryPanel.htmlLabel(totalGainsLabelPrefix, UI.formatGp(stats.getTotalGain(), this.config.showExactGp())));
            panelData.totalLossesLabel.setText(SessionHistoryPanel.htmlLabel(totalLossesLabelPrefix, UI.formatGp(stats.getTotalLoss(), this.config.showExactGp())));
            panelData.durationLabel.setText(SessionHistoryPanel.htmlLabel(durationLabelPrefix, UI.formatTime(stats.getSessionRuntime())));
            boolean showTripCountAndTime = stats.getTripCount() > 1;
            panelData.setTripCountAndDurationVisible(showTripCountAndTime);
            if (showTripCountAndTime) {
                panelData.tripCountLabel.setText(SessionHistoryPanel.htmlLabel(tripCountLabelPrefix, Integer.toString(stats.getTripCount())));
                panelData.avgTripDurationLabel.setText(SessionHistoryPanel.htmlLabel(avgTripDurationLabelPrefix, UI.formatTime(stats.getAvgTripDuration())));
            }
            UI.updateLootGrid(UI.sortLedger(GPPerHourPlugin.getProfitLossLedger(stats.getInitialQtys(), stats.getQtys())), panelData.sessionLootPanelData, this.itemManager, this.config);
        }
        panelData.onDetailsPressed = () -> {
            stats.showDetails = !stats.showDetails;
            this.redrawPanels(false);
        };
        panelData.onDeletePressed = () -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this session?", "Warning", 2);
            if (confirm == 0) {
                this.clientThread.invokeLater(() -> this.sessionManager.deleteSession(stats));
            }
        };
    }

    void ensurePanelCount(int size) {
        while (this.historyPanels.size() < size) {
            this.constraints.gridy = this.historyPanels.size();
            SessionHistoryPanelData data = this.buildHistoryPanel();
            this.historyPanelContainer.add((Component)data.masterPanel, this.constraints);
            this.historyPanels.add(data);
        }
    }

    SessionHistoryPanelData buildHistoryPanel() {
        return new SessionHistoryPanelData(this);
    }

    static String htmlLabel(String key, String valueStr) {
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    void getCoinsImage(int quantity, Consumer<BufferedImage> consumer, SessionStats stats) {
        if (stats.coinsImage == null) {
            AsyncBufferedImage asyncImage = this.itemManager.getImage(995, quantity, false);
            Runnable resizeImage = () -> {
                stats.coinsImage = ImageUtil.resizeImage((BufferedImage)asyncImage, (int)24, (int)24);
                consumer.accept(stats.coinsImage);
            };
            asyncImage.onLoaded(resizeImage);
        } else {
            consumer.accept(stats.coinsImage);
        }
    }

    private class SessionHistoryPanelData {
        final JPanel detailsPanel;
        final JLabel gpPerHourTabLabel;
        final JPanel masterPanel = new JPanel();
        final EditableNameField nameField;
        private final JLabel coinsLabel = new JLabel();
        private final JLabel subtitleLeft = new JLabel("Left");
        private final JLabel durationLabel = new JLabel(SessionHistoryPanel.htmlLabel("Duration: ", "N/A"));
        private final JLabel gpPerHourLabel = new JLabel(SessionHistoryPanel.htmlLabel("GP/hr: ", "N/A"));
        private final JLabel netTotalLabel = new JLabel(SessionHistoryPanel.htmlLabel("Net Total: ", "N/A"));
        private final JLabel totalGainsLabel = new JLabel(SessionHistoryPanel.htmlLabel("Gains: ", "N/A"));
        private final JLabel totalLossesLabel = new JLabel(SessionHistoryPanel.htmlLabel("Losses: ", "N/A"));
        private final JLabel tripCountLabel = new JLabel(SessionHistoryPanel.htmlLabel("Trip Count: ", "N/A"));
        private final JLabel avgTripDurationLabel = new JLabel(SessionHistoryPanel.htmlLabel("Avg Trip Time: ", "N/A"));
        private final Component tripCountSpacing;
        private final Component avgTripDurationSpacing;
        private final UI.LootPanelData sessionLootPanelData = new UI.LootPanelData();
        Runnable onDetailsPressed;
        Runnable onDeletePressed;

        void setTripCountAndDurationVisible(boolean visible) {
            this.tripCountLabel.setVisible(visible);
            this.avgTripDurationLabel.setVisible(visible);
            this.tripCountSpacing.setVisible(visible);
            this.avgTripDurationSpacing.setVisible(visible);
        }

        SessionHistoryPanelData(SessionHistoryPanel parentPanel) {
            this.masterPanel.setLayout(new BorderLayout(0, 0));
            this.gpPerHourTabLabel = new JLabel();
            this.gpPerHourTabLabel.setText("xxx/hr");
            this.gpPerHourTabLabel.setFont(FontManager.getRunescapeBoldFont());
            RoundedPanel gpPerHourPanel = new RoundedPanel();
            gpPerHourPanel.setLayout(new BorderLayout(5, 0));
            gpPerHourPanel.setBorder(new EmptyBorder(3, 10, 3, 10));
            gpPerHourPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            gpPerHourPanel.setForeground(borderColor);
            gpPerHourPanel.add((Component)this.coinsLabel, "West");
            gpPerHourPanel.add((Component)this.gpPerHourTabLabel, "Center");
            JPanel gpPerHourWrapperPanel = new JPanel();
            gpPerHourWrapperPanel.setLayout(new BorderLayout());
            gpPerHourWrapperPanel.add((Component)gpPerHourPanel, "West");
            this.nameField = new EditableNameField(parentPanel, 50, ColorScheme.DARKER_GRAY_COLOR, null);
            JLabel detailsButton = UI.createIconButton(UI.SESSIONINFO_INFO_ICON, UI.SESSIONINFO_INFO_HOVER_ICON, "Show Details", () -> this.onDetailsPressed.run());
            JLabel deleteButton = UI.createIconButton(UI.SESSIONINFO_TRASH_ICON, UI.SESSIONINFO_TRASH_HOVER_ICON, "Delete Session", () -> this.onDeletePressed.run());
            JPanel subtitlePanel = new JPanel();
            subtitlePanel.setLayout(new BorderLayout());
            subtitlePanel.setBorder(new EmptyBorder(5, 10, 5, 10));
            subtitlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            subtitlePanel.add((Component)this.subtitleLeft, "West");
            subtitlePanel.add((Component)detailsButton, "Center");
            subtitlePanel.add((Component)deleteButton, "East");
            JPanel nameAndSubtitlePanel = new JPanel();
            nameAndSubtitlePanel.setLayout(new BorderLayout());
            nameAndSubtitlePanel.setBorder(new MatteBorder(1, 1, 1, 1, borderColor));
            nameAndSubtitlePanel.add((Component)this.nameField, "North");
            nameAndSubtitlePanel.add((Component)subtitlePanel, "Center");
            JPanel headerPanel = new JPanel();
            headerPanel.setLayout(new BorderLayout());
            headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            headerPanel.add((Component)gpPerHourWrapperPanel, "North");
            headerPanel.add((Component)nameAndSubtitlePanel, "Center");
            JPanel infoLabels = new JPanel();
            infoLabels.setLayout(new BoxLayout(infoLabels, 1));
            infoLabels.setBorder(new EmptyBorder(8, 10, 8, 10));
            infoLabels.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            int vGap = 8;
            infoLabels.add(this.gpPerHourLabel);
            UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.netTotalLabel);
            UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.totalGainsLabel);
            UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.totalLossesLabel);
            UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.tripCountLabel);
            this.tripCountSpacing = UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.avgTripDurationLabel);
            this.avgTripDurationSpacing = UI.addVerticalRigidBox(infoLabels, vGap);
            infoLabels.add(this.durationLabel);
            this.sessionLootPanelData.lootPanel.setLayout(new BorderLayout());
            this.sessionLootPanelData.lootPanel.setBorder(new MatteBorder(1, 0, 0, 0, borderColor));
            this.detailsPanel = new JPanel();
            this.detailsPanel.setLayout(new BorderLayout());
            this.detailsPanel.setBorder(new MatteBorder(0, 1, 1, 1, borderColor));
            this.detailsPanel.add((Component)infoLabels, "North");
            this.detailsPanel.add((Component)this.sessionLootPanelData.lootPanel, "South");
            this.masterPanel.add((Component)headerPanel, "North");
            this.masterPanel.add((Component)this.detailsPanel, "Center");
        }
    }
}

