/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootingBagManager {
    private static final Logger log = LoggerFactory.getLogger(LootingBagManager.class);
    public static final int LOOTING_BAG_CONTAINER = 516;
    private static final Set<Integer> FEROX_REGION = ImmutableSet.of((Object)12600, (Object)12344);
    private static final int LOOTING_BAG_SIZE = 28;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private ScheduledExecutorService executor;
    private Map<Integer, Integer> bagItems = null;
    private int lastLootingBagUseOn = -2;
    private PickupAction lastPickUpAction;
    private Map<Integer, Integer> differenceMap = new HashMap<Integer, Integer>();
    private Item[] inventory_items;

    public void loadConfigData() {
        Type mapType = new TypeToken<Map<Integer, Integer>>(){}.getType();
        String json = this.configManager.getRSProfileConfiguration("gpperhour", "looting_bag");
        try {
            this.bagItems = (Map)this.gson.fromJson(json, mapType);
        }
        catch (Exception e) {
            log.error("Failed to load looting bag data from json: " + json, (Throwable)e);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() != WidgetInfo.LOOTING_BAG_CONTAINER.getGroupId()) {
            return;
        }
        this.updateValue();
    }

    private void updateValue() {
        ItemContainer itemContainer = this.client.getItemContainer(516);
        if (itemContainer == null) {
            if (this.bagItems == null) {
                this.bagItems = new HashMap<Integer, Integer>();
            }
            this.bagItems.clear();
            this.saveData();
            return;
        }
        if (this.bagItems == null) {
            this.bagItems = new HashMap<Integer, Integer>();
        }
        this.bagItems.clear();
        for (Item item : itemContainer.getItems()) {
            if (item.getId() < 0) continue;
            this.bagItems.merge(item.getId(), item.getQuantity(), Integer::sum);
        }
        this.saveData();
    }

    void addLootingBagContents(Map<Integer, Float> qtyMap) {
        if (this.bagItems == null) {
            return;
        }
        for (Integer itemId : this.bagItems.keySet()) {
            qtyMap.merge(itemId, Float.valueOf(this.bagItems.get(itemId).intValue()), Float::sum);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == null) {
            return;
        }
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            if (this.inventory_items != null && this.bagItems != null && (this.lastLootingBagUseOn == this.client.getTickCount() || this.lastLootingBagUseOn + 1 == this.client.getTickCount())) {
                this.differenceMap.clear();
                Item[] before = this.inventory_items;
                Item[] after = event.getItemContainer().getItems();
                for (Item beforeItem : before) {
                    this.differenceMap.merge(beforeItem.getId(), 1, Integer::sum);
                }
                for (Item afterItem : after) {
                    this.differenceMap.merge(afterItem.getId(), -1, Integer::sum);
                }
                for (Integer itemId : this.differenceMap.keySet()) {
                    Integer count = this.differenceMap.get(itemId);
                    if (count <= 0 || !this.canAddItem(itemId)) continue;
                    this.bagItems.merge(itemId, count, Integer::sum);
                }
                this.saveData();
            }
            this.inventory_items = event.getItemContainer().getItems();
        }
        if (event.getContainerId() == 516) {
            this.updateValue();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.GROUND_ITEM_THIRD_OPTION && event.getMenuOption().equals("Take")) {
            WorldPoint point = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
            this.lastPickUpAction = new PickupAction(event.getId(), point);
        }
        if (event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET) {
            boolean usedItemOnLootingBag;
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
            if (itemContainer == null) {
                return;
            }
            Widget widgetA = this.client.getSelectedWidget();
            if (widgetA == null) {
                return;
            }
            Item itemA = itemContainer.getItem(widgetA.getIndex());
            if (itemA == null) {
                return;
            }
            int itemAId = itemA.getId();
            Widget widgetB = event.getWidget();
            if (widgetB == null) {
                return;
            }
            Item itemB = itemContainer.getItem(widgetB.getIndex());
            if (itemB == null) {
                return;
            }
            int itemBId = itemB.getId();
            boolean bl = usedItemOnLootingBag = this.isLootingBag(itemAId) || this.isLootingBag(itemBId);
            if (usedItemOnLootingBag) {
                this.lastLootingBagUseOn = this.client.getTickCount();
            }
        }
    }

    private boolean isLootingBag(int itemId) {
        return itemId == 11941 || itemId == 22586;
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        if (this.bagItems == null) {
            return;
        }
        if (this.client.getVarbitValue(5963) == 0 && !FEROX_REGION.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            return;
        }
        ItemContainer inv = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inv == null || !inv.contains(22586)) {
            return;
        }
        if (this.lastPickUpAction == null) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation())) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.lastPickUpAction.getWorldPoint())) {
            return;
        }
        int itemId = event.getItem().getId();
        if (itemId != this.lastPickUpAction.getItemId()) {
            return;
        }
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        if (!itemComposition.isTradeable()) {
            return;
        }
        if (!this.canAddItem(itemId)) {
            return;
        }
        int quantity = event.getItem().getQuantity();
        this.bagItems.merge(itemId, quantity, Integer::sum);
        this.saveData();
    }

    private boolean canAddItem(int itemId) {
        if (this.isStackable(itemId) && this.bagItems.containsKey(itemId)) {
            return true;
        }
        int slotsUsed = 0;
        for (Integer bagItemId : this.bagItems.keySet()) {
            slotsUsed += this.isStackable(bagItemId) ? 1 : this.bagItems.get(bagItemId);
        }
        return slotsUsed < 28;
    }

    private boolean isStackable(int itemId) {
        return this.itemManager.getItemComposition(itemId).isStackable();
    }

    private void saveData() {
        this.executor.execute(() -> this.configManager.setRSProfileConfiguration("gpperhour", "looting_bag", (Object)this.gson.toJson(this.bagItems)));
    }

    public long getPrice(int itemId) {
        return this.itemManager.getItemPrice(itemId);
    }

    boolean needsCheck() {
        return this.bagItems == null;
    }

    public class PickupAction {
        int itemId;
        WorldPoint worldPoint;

        public int getItemId() {
            return this.itemId;
        }

        public WorldPoint getWorldPoint() {
            return this.worldPoint;
        }

        public void setItemId(int itemId) {
            this.itemId = itemId;
        }

        public void setWorldPoint(WorldPoint worldPoint) {
            this.worldPoint = worldPoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PickupAction)) {
                return false;
            }
            PickupAction other = (PickupAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            WorldPoint this$worldPoint = this.getWorldPoint();
            WorldPoint other$worldPoint = other.getWorldPoint();
            return !(this$worldPoint == null ? other$worldPoint != null : !this$worldPoint.equals(other$worldPoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PickupAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemId();
            WorldPoint $worldPoint = this.getWorldPoint();
            result = result * 59 + ($worldPoint == null ? 43 : $worldPoint.hashCode());
            return result;
        }

        public String toString() {
            return "LootingBagManager.PickupAction(itemId=" + this.getItemId() + ", worldPoint=" + this.getWorldPoint() + ")";
        }

        public PickupAction(int itemId, WorldPoint worldPoint) {
            this.itemId = itemId;
            this.worldPoint = worldPoint;
        }
    }
}

