/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.google.inject.Inject;
import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPlugin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.time.Instant;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldDropManager
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(GoldDropManager.class);
    private static final int COINS_100_SPRITE_ID = -1337;
    private static final int COINS_250_SPRITE_ID = -1338;
    private static final int COINS_1000_SPRITE_ID = -1339;
    private static final int COINS_10000_SPRITE_ID = -1340;
    private static final int XPDROP_SKILL = Skill.FISHING.ordinal();
    private final ItemManager itemManager;
    private final Client client;
    private final GPPerHourConfig config;
    private final ConfigManager configManager;
    private final GPPerHourPlugin plugin;
    private boolean hasLoadedCoinsImages;
    private BufferedImage coinsImage100;
    private BufferedImage coinsImage250;
    private BufferedImage coinsImage1000;
    private BufferedImage coinsImage10000;
    private long currentGoldDropValue;
    boolean showingStaticGoldDrop = false;
    long currentStaticAmountToShow;
    long staticGoldDropDisplayTime;
    private static final int staticImageDimension = 24;
    private InventoryWidgetData lastWidgetData;

    @Inject
    GoldDropManager(Client client, GPPerHourPlugin plugin, ItemManager itemManager, GPPerHourConfig config, ConfigManager configManager) {
        this.client = client;
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.config = config;
        this.configManager = configManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.prepareCoinSprite(10000, -1340);
        this.prepareCoinSprite(1000, -1339);
        this.prepareCoinSprite(250, -1338);
        this.prepareCoinSprite(100, -1337);
        this.currentGoldDropValue = 0L;
    }

    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() != 996) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        int widgetId = intStack[intStackSize - 4];
        boolean isThisGoldDrop = this.currentGoldDropValue != 0L;
        long goldDropValue = this.currentGoldDropValue;
        this.currentGoldDropValue = 0L;
        this.handleXpDrop(widgetId, isThisGoldDrop, goldDropValue);
    }

    private void handleXpDrop(int xpDropWidgetId, boolean isThisGoldDrop, long goldDropValue) {
        Widget xpDropWidget = this.client.getWidget(WidgetInfo.TO_GROUP((int)xpDropWidgetId), WidgetInfo.TO_CHILD((int)xpDropWidgetId));
        if (xpDropWidget == null) {
            log.error("xpDropWidget was null");
            return;
        }
        Widget[] xpDropWidgetChildren = xpDropWidget.getChildren();
        if (xpDropWidgetChildren.length < 1) {
            log.error(String.format("Unexpected xpDropWidgets length! %d", xpDropWidgetChildren.length));
            return;
        }
        Widget dropTextWidget = xpDropWidgetChildren[0];
        if (isThisGoldDrop) {
            if (xpDropWidgetChildren.length < 2) {
                log.error(String.format("Unexpected xpDropWidgetChildren length for a gold drop! length! %d", xpDropWidgetChildren.length));
                return;
            }
            Widget dropSpriteWidget = xpDropWidgetChildren[1];
            this.xpDropToGoldDrop(dropTextWidget, dropSpriteWidget, goldDropValue);
        } else if (this.config.goldDropsDisplayMode() == GoldDropDisplayMode.VANILLA && !((Boolean)this.configManager.getConfiguration("runelite", "xpdropplugin", Boolean.class)).booleanValue()) {
            this.resetXpDropTextColor(dropTextWidget);
        }
    }

    private void xpDropToGoldDrop(Widget dropTextWidget, Widget dropSpriteWidget, long goldDropValue) {
        dropTextWidget.setText(this.formatGoldDropText(goldDropValue));
        if (goldDropValue > 0L) {
            dropTextWidget.setTextColor(this.config.goldDropsPositiveColor().getRGB());
            dropTextWidget.setOpacity(255 - this.config.goldDropsPositiveColor().getAlpha());
        } else {
            dropTextWidget.setTextColor(this.config.goldDropsNegativeColor().getRGB());
            dropTextWidget.setOpacity(255 - this.config.goldDropsNegativeColor().getAlpha());
        }
        int spriteId = 0;
        long absValue = Math.abs(goldDropValue);
        spriteId = absValue >= 10000L ? -1340 : (absValue >= 1000L ? -1339 : (absValue >= 250L ? -1338 : -1337));
        dropSpriteWidget.setSpriteId(spriteId);
    }

    private void prepareCoinSprite(int quantity, int spriteId) {
        AsyncBufferedImage coin_image_raw = this.itemManager.getImage(995, quantity, false);
        Runnable r = () -> {
            SpritePixels coin_sprite = ImageUtil.getImageSpritePixels((BufferedImage)coin_image_raw, (Client)this.client);
            this.client.getSpriteOverrides().put(spriteId, coin_sprite);
        };
        coin_image_raw.onLoaded(r);
    }

    public void requestGoldDrop(long amount) {
        if (this.config.goldDropsDisplayMode() == GoldDropDisplayMode.STATIC) {
            this.showStaticDrop(amount);
            return;
        }
        this.currentGoldDropValue = amount;
        if (amount < 0L) {
            amount *= -10L;
        }
        if ((amount /= 100L) == 0L) {
            amount = 1L;
        }
        this.client.runScript(new Object[]{2091, XPDROP_SKILL, (int)amount});
    }

    private void resetXpDropTextColor(Widget xpDropTextWidget) {
        EnumComposition colorEnum = this.client.getEnum(1169);
        int defaultColorId = this.client.getVarbitValue(4695);
        int color = colorEnum.getIntValue(defaultColorId);
        xpDropTextWidget.setTextColor(color);
        xpDropTextWidget.setOpacity(0);
    }

    private void showStaticDrop(long amount) {
        this.currentStaticAmountToShow = this.showingStaticGoldDrop ? (this.currentStaticAmountToShow += amount) : amount;
        this.showingStaticGoldDrop = true;
        this.staticGoldDropDisplayTime = Instant.now().toEpochMilli();
    }

    public Dimension render(Graphics2D graphics) {
        boolean isInvHidden;
        Widget inventoryWidget = this.plugin.getInventoryWidget();
        boolean bl = isInvHidden = inventoryWidget == null || inventoryWidget.isHidden();
        if (isInvHidden && this.lastWidgetData == null) {
            return null;
        }
        if (!isInvHidden) {
            if (this.lastWidgetData == null) {
                this.lastWidgetData = new InventoryWidgetData();
            }
            this.lastWidgetData.canvasLocation = inventoryWidget.getCanvasLocation();
            this.lastWidgetData.width = inventoryWidget.getWidth();
            this.lastWidgetData.height = inventoryWidget.getHeight();
        }
        if (!this.showingStaticGoldDrop || this.currentStaticAmountToShow == 0L) {
            return null;
        }
        long fadeOutTimeMillis = 3000L;
        long timePassed = Instant.now().toEpochMilli() - this.staticGoldDropDisplayTime;
        float percentDone = (float)timePassed / (float)fadeOutTimeMillis;
        if (percentDone > 1.0f) {
            this.showingStaticGoldDrop = false;
            return null;
        }
        int x = this.lastWidgetData.getCanvasLocation().getX() + 20 - this.lastWidgetData.width / 2;
        int y = this.lastWidgetData.getCanvasLocation().getY() + 20 - this.config.inventoryYOffset();
        String text = QuantityFormatter.quantityToStackSize((long)this.currentStaticAmountToShow);
        BufferedImage image = this.getCoinsImage((int)this.currentStaticAmountToShow);
        float alpha = GoldDropManager.clamp(2.0f - percentDone * 2.0f, 0.0f, 1.0f);
        Composite composite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        graphics.drawImage((Image)image, x - 24, y - 12, null);
        graphics.setComposite(composite);
        Color textColor = this.currentStaticAmountToShow > 0L ? this.config.goldDropsPositiveColor() : this.config.goldDropsNegativeColor();
        graphics.setColor(new Color((float)textColor.getRed() / 255.0f, (float)textColor.getGreen() / 255.0f, (float)textColor.getBlue() / 255.0f, (float)textColor.getAlpha() / 255.0f * alpha));
        graphics.drawString(text, x + 1, y + graphics.getFontMetrics().getHeight() / 2);
        return null;
    }

    private BufferedImage getCoinsImage(int quantity) {
        long absValue;
        if (!this.hasLoadedCoinsImages) {
            this.loadCoinsImages();
        }
        if ((absValue = (long)Math.abs(quantity)) >= 10000L) {
            return this.coinsImage10000;
        }
        if (absValue >= 1000L) {
            return this.coinsImage1000;
        }
        if (absValue >= 250L) {
            return this.coinsImage250;
        }
        return this.coinsImage100;
    }

    private void loadCoinsImages() {
        this.coinsImage100 = this.loadCoinsImage(100);
        this.coinsImage250 = this.loadCoinsImage(250);
        this.coinsImage1000 = this.loadCoinsImage(1000);
        this.coinsImage10000 = this.loadCoinsImage(10000);
        this.hasLoadedCoinsImages = true;
    }

    private BufferedImage loadCoinsImage(int quantity) {
        Object image = this.itemManager.getImage(995, quantity, false);
        image = ImageUtil.resizeImage((BufferedImage)image, (int)24, (int)24);
        return image;
    }

    private String formatGoldDropText(long goldDropValue) {
        return NumberFormat.getInstance().format(goldDropValue);
    }

    private static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private class InventoryWidgetData {
        public Point canvasLocation;
        public int width;
        public int height;

        public Point getCanvasLocation() {
            return this.canvasLocation;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setCanvasLocation(Point canvasLocation) {
            this.canvasLocation = canvasLocation;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InventoryWidgetData)) {
                return false;
            }
            InventoryWidgetData other = (InventoryWidgetData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            Point this$canvasLocation = this.getCanvasLocation();
            Point other$canvasLocation = other.getCanvasLocation();
            return !(this$canvasLocation == null ? other$canvasLocation != null : !this$canvasLocation.equals(other$canvasLocation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InventoryWidgetData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            Point $canvasLocation = this.getCanvasLocation();
            result = result * 59 + ($canvasLocation == null ? 43 : $canvasLocation.hashCode());
            return result;
        }

        public String toString() {
            return "GoldDropManager.InventoryWidgetData(canvasLocation=" + this.getCanvasLocation() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }

    public static enum GoldDropDisplayMode {
        DISABLED("Disabled"),
        VANILLA("Vanilla"),
        STATIC("Static");

        private final String configName;

        public String toString() {
            return this.configName;
        }

        private GoldDropDisplayMode(String configName) {
            this.configName = configName;
        }
    }
}

