/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.gpperhour.ActiveSessionPanel;
import com.gpperhour.ActiveTripOverlay;
import com.gpperhour.FractionalRemapper;
import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPanel;
import com.gpperhour.GoldDropManager;
import com.gpperhour.LedgerItem;
import com.gpperhour.LootingBagManager;
import com.gpperhour.RunState;
import com.gpperhour.SessionHistoryPanel;
import com.gpperhour.SessionManager;
import com.gpperhour.SessionStats;
import com.gpperhour.TrackingMode;
import com.gpperhour.TripData;
import com.gpperhour.ValueRemapper;
import com.gpperhour.itemcharges.ChargedItemManager;
import com.gpperhour.weaponcharges.WeaponChargesManager;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GP Per Hour", description="Track your gp/hr across various trips and save your sessions for later viewing.", tags={"inventory", "total", "profit", "tracker", "loss", "gp", "per", "hour", "prices", "gold farming", "gp/hr"})
public class GPPerHourPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GPPerHourPlugin.class);
    private static final String plugin_version = "1.2";
    private static final String plugin_message = "GP Per Hour 1.2:<br>* Option to only show positive gold drops.<br>* Option to set the value of Brimstone Keys to zero.<br>* Option to use low or high alchemy values.<br>* Seedlings now remap to sapling prices.<br>* Seed vault now counts as a bank interface.";
    static final int COINS = 995;
    static final int NO_PROFIT_LOSS_TIME = -1;
    static final int RUNEPOUCH_ITEM_ID = 12791;
    static final int DIVINE_RUNEPOUCH_ITEM_ID = 27281;
    public static final float roundAmount = 0.01f;
    private static final Map<Integer, Float> itemPrices = new HashMap<Integer, Float>();
    private static final Map<Integer, String> itemNames = new HashMap<Integer, String>();
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ActiveTripOverlay tripOverlay;
    @Inject
    private WeaponChargesManager weaponChargesManager;
    @Inject
    private ChargedItemManager chargedItemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private GPPerHourConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private LootingBagManager lootingBagManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ChatMessageManager chat_messages;
    private SessionManager sessionManager;
    private GPPerHourPanel gpPerHourPanel;
    private ActiveSessionPanel activeSessionPanel;
    private SessionHistoryPanel sessionHistoryPanel;
    private TripData runData;
    @Inject
    private GoldDropManager goldDropManager;
    private TrackingMode mode = TrackingMode.TOTAL;
    private RunState state = RunState.NONE;
    private RunState previousState = RunState.NONE;
    private long totalGp = 0L;
    private Long previousTotalGp = null;
    private long initialGp = 0L;
    private BufferedImage icon;
    private NavigationButton navButton;
    private final Map<Integer, Float> inventoryQtyMap = new HashMap<Integer, Float>();
    private final Map<Integer, Float> equipmentQtyMap = new HashMap<Integer, Float>();
    private final HashSet<String> ignoredItems = new HashSet();
    private int depositInteractionTick;
    private static final int interactionTickThreshold = 30;
    private Widget inventoryWidget;
    private ItemContainer inventoryItemContainer;
    private ItemContainer equipmentItemContainer;
    private boolean postNewRun = false;
    private long newRunTick = 0L;
    private boolean expectingPutAnimation = false;
    private static final int[] RUNEPOUCH_AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNEPOUCH_RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private String currentProfileKey;
    private final Map<Integer, Float> chargedWeaponComponentQtyMap = new HashMap<Integer, Float>();
    private final Map<Integer, Float> chargedItemQtyMap = new HashMap<Integer, Float>();
    private final HashSet<String> chargeableItemsNeedingCheck = new HashSet();

    protected void startUp() throws Exception {
        if (this.config.showTripOverlay()) {
            this.overlayManager.add((Overlay)this.tripOverlay);
        }
        if (this.config.goldDropsDisplayMode() == GoldDropManager.GoldDropDisplayMode.STATIC) {
            this.overlayManager.add((Overlay)this.goldDropManager);
        }
        this.eventBus.register((Object)this.lootingBagManager);
        this.eventBus.register((Object)this.weaponChargesManager);
        this.eventBus.register((Object)this.chargedItemManager);
        this.weaponChargesManager.startUp();
        this.sessionManager = new SessionManager(this, this.config, this.executor, this.gson);
        this.buildSidePanel();
        this.updatePanels();
        this.refreshIgnoredItems();
        this.checkLoadingState(true);
        if (this.config.goldDrops()) {
            this.config.setGoldDropsDisplayMode(GoldDropManager.GoldDropDisplayMode.VANILLA);
            this.config.setGoldDrops(false);
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.tripOverlay);
        this.overlayManager.remove((Overlay)this.goldDropManager);
        this.eventBus.unregister((Object)this.lootingBagManager);
        this.eventBus.unregister((Object)this.weaponChargesManager);
        this.eventBus.unregister((Object)this.chargedItemManager);
        this.weaponChargesManager.shutDown();
        this.clientToolbar.removeNavigation(this.navButton);
        if (this.currentProfileKey != null) {
            this.writeSavedData(this.currentProfileKey);
        }
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        this.checkLoadingState(false);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        String profileKey = this.configManager.getRSProfileKey();
        if (profileKey != null) {
            this.writeSavedData(profileKey);
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.showChangelog();
        }
    }

    private void showChangelog() {
        String currentVersion = this.configManager.getConfiguration("gpperhour", "version");
        if (currentVersion == null || !currentVersion.equals(plugin_version)) {
            this.configManager.setConfiguration("gpperhour", "version", plugin_version);
            this.chat_messages.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(plugin_message).build());
        }
    }

    private void checkLoadingState(boolean isStartingUp) {
        String profileKey = this.configManager.getRSProfileKey();
        if (profileKey != null) {
            if (this.currentProfileKey == null || isStartingUp) {
                this.loadData();
            } else if (!profileKey.equals(this.currentProfileKey)) {
                this.writeSavedData(this.currentProfileKey);
                this.loadData();
            }
        } else if (this.currentProfileKey != null) {
            this.writeSavedData(this.currentProfileKey);
        }
        this.currentProfileKey = profileKey;
    }

    private void loadData() {
        this.lootingBagManager.loadConfigData();
        this.chargedItemManager.loadConfigData();
        this.sessionManager.reloadSessions();
        this.sessionManager.deleteAllTrips();
        this.sessionManager.stopTracking();
        this.runData = this.getSavedData();
        this.sessionManager.startTracking();
        this.previousTotalGp = null;
    }

    void updatePanels() {
        if (this.navButton.isSelected() && this.gpPerHourPanel.isShowingActiveSession()) {
            SessionStats sessionStats = this.sessionManager.getActiveSessionStats();
            if (sessionStats != null) {
                this.ensureSessionNameAndPriceLoaded(sessionStats);
            }
            SwingUtilities.invokeLater(() -> this.activeSessionPanel.updateTrips());
        }
        if (this.navButton.isSelected() && this.gpPerHourPanel.isShowingSessionHistory() && this.sessionManager.sessionHistoryDirty) {
            for (SessionStats sessionStats : this.sessionManager.sessionHistory) {
                this.ensureSessionNameAndPriceLoaded(sessionStats);
            }
            SwingUtilities.invokeLater(() -> this.sessionHistoryPanel.updateSessions());
            this.sessionManager.sessionHistoryDirty = false;
        }
    }

    void ensureSessionNameAndPriceLoaded(SessionStats sessionStats) {
        for (Integer intialItemId : sessionStats.getInitialQtys().keySet()) {
            this.ensureNameAndPriceLoaded(intialItemId);
        }
        for (Integer itemId : sessionStats.getQtys().keySet()) {
            this.ensureNameAndPriceLoaded(itemId);
        }
    }

    void ensureNameAndPriceLoaded(Integer itemId) {
        if (!itemNames.containsKey(itemId)) {
            ItemComposition composition = this.itemManager.getItemComposition(itemId.intValue());
            itemNames.put(itemId, composition.getName());
        }
        if (!itemPrices.containsKey(itemId)) {
            itemPrices.put(itemId, Float.valueOf(this.getPrice(itemId)));
        }
    }

    private void buildSidePanel() {
        this.activeSessionPanel = new ActiveSessionPanel(this, this.config, this.itemManager, this.clientThread, this.sessionManager);
        this.activeSessionPanel.sidePanelInitializer();
        this.sessionHistoryPanel = new SessionHistoryPanel(this, this.config, this.itemManager, this.clientThread, this.sessionManager);
        this.gpPerHourPanel = new GPPerHourPanel(this.activeSessionPanel, this.sessionHistoryPanel);
        this.icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/gpperhour-icon.png");
        this.navButton = this.buildNavButton();
        if (this.config.enableSessionPanel()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    @Subscribe(priority=-1.0f)
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        this.goldDropManager.onScriptPreFired(scriptPreFired);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.runData == null) {
            return;
        }
        this.updatePluginState(false);
        this.updatePanels();
        this.updateChargeableItemsNeedingCheck();
        if (this.state == RunState.RUN && !this.runData.isPaused) {
            this.runData.runtime += 600L;
        }
        this.checkTickProfit();
    }

    void checkTickProfit() {
        boolean isRun;
        boolean bl = isRun = this.state == RunState.RUN;
        if (!isRun) {
            return;
        }
        if (this.runData.isBankDelay) {
            return;
        }
        if (this.previousTotalGp == null) {
            this.previousTotalGp = this.totalGp;
            return;
        }
        long tickProfit = this.totalGp - this.previousTotalGp;
        this.previousTotalGp = this.totalGp;
        if (Math.abs(tickProfit) <= 1L) {
            return;
        }
        if (this.runData.isPaused && this.config.autoResumeTrip()) {
            this.runData.isPaused = false;
        }
        if (!(this.config.goldDropsDisplayMode() == GoldDropManager.GoldDropDisplayMode.DISABLED || Math.abs(tickProfit) < (long)this.config.goldDropThreshold() || tickProfit <= 0L && this.config.onlyShowPositiveGoldDrops())) {
            this.goldDropManager.requestGoldDrop(tickProfit);
        }
    }

    @Provides
    GPPerHourConfig provideConfig(ConfigManager configManager) {
        return (GPPerHourConfig)configManager.getConfig(GPPerHourConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("gpperhour")) {
            if (event.getKey().equals("showTripOverlay")) {
                if (this.config.showTripOverlay()) {
                    this.overlayManager.add((Overlay)this.tripOverlay);
                } else {
                    this.overlayManager.remove((Overlay)this.tripOverlay);
                }
            } else if (event.getKey().equals("goldDropsDisplayMode")) {
                if (this.config.goldDropsDisplayMode() == GoldDropManager.GoldDropDisplayMode.STATIC) {
                    this.overlayManager.add((Overlay)this.goldDropManager);
                } else {
                    this.overlayManager.remove((Overlay)this.goldDropManager);
                }
            } else if (event.getKey().equals("enableSessionPanel")) {
                if (this.config.enableSessionPanel()) {
                    this.clientToolbar.addNavigation(this.navButton);
                } else {
                    this.clientToolbar.removeNavigation(this.navButton);
                }
                this.sessionManager.refreshSessionTracking();
            } else if (event.getKey().equals("enableSessionTracking")) {
                this.sessionManager.refreshSessionTracking();
            } else if (event.getKey().equals("sidePanelPosition")) {
                this.clientToolbar.removeNavigation(this.navButton);
                this.navButton = this.buildNavButton();
                if (this.config.enableSessionPanel()) {
                    this.clientToolbar.addNavigation(this.navButton);
                }
            } else if (event.getKey().equals("ignoredItems")) {
                this.refreshIgnoredItems();
            } else if (event.getKey().equals("valueMode")) {
                this.refreshPrices();
            } else if (event.getKey().startsWith("tokkul")) {
                this.refreshPrice(6529);
            } else if (event.getKey().startsWith("crystalShard")) {
                this.refreshPrice(23962);
            } else if (event.getKey().startsWith("crystalDust")) {
                this.refreshPrice(23964);
            } else if (event.getKey().startsWith("mermaidsTear")) {
                this.refreshPrice(21656);
            } else if (event.getKey().startsWith("stardust")) {
                this.refreshPrice(25527);
            } else if (event.getKey().startsWith("unidentifiedMinerals")) {
                this.refreshPrice(21341);
            } else if (event.getKey().startsWith("goldenNugget")) {
                this.refreshPrice(12012);
            } else if (event.getKey().startsWith("hallowedMark")) {
                this.refreshPrice(24711);
            } else if (event.getKey().startsWith("abyssalPearls")) {
                this.refreshPrice(26792);
            } else if (event.getKey().startsWith("brimstoneKey")) {
                this.refreshPrice(23083);
            }
        }
    }

    private void refreshIgnoredItems() {
        this.ignoredItems.clear();
        String[] items = this.config.ignoredItems().split(",");
        for (int i = 0; i < items.length; ++i) {
            this.ignoredItems.add(items[i].trim().toLowerCase());
        }
    }

    private void refreshPrice(int itemID) {
        this.clientThread.invoke(() -> {
            if (itemPrices.remove(itemID) != null) {
                this.getPrice(itemID);
            }
        });
    }

    private NavigationButton buildNavButton() {
        return NavigationButton.builder().tooltip("GP Per Hour").icon(this.icon).priority(this.config.sidePanelPosition()).panel((PluginPanel)this.gpPerHourPanel).build();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.updatePluginState(false);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getId() == 10529 && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT || event.getId() == 10530 && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT || event.getId() == 43696 || event.getId() == 49583 && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT) {
            this.expectingPutAnimation = true;
            this.depositInteractionTick = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.expectingPutAnimation || this.client.getTickCount() - this.depositInteractionTick > 30) {
            return;
        }
        if (event.getActor() == this.client.getLocalPlayer() && (event.getActor().getAnimation() == 834 || event.getActor().getAnimation() == 9402)) {
            this.updatePluginState(true);
            this.expectingPutAnimation = false;
        }
    }

    boolean isBanking() {
        Widget collectOnBank = this.client.getWidget(402, 2);
        if (collectOnBank != null && !collectOnBank.isHidden()) {
            return true;
        }
        Widget grandExchange = this.client.getWidget(WidgetInfo.GRAND_EXCHANGE_WINDOW_CONTAINER);
        if (grandExchange != null && !grandExchange.isHidden()) {
            return true;
        }
        Widget toolLeprechaun = this.client.getWidget(125, 0);
        if (toolLeprechaun != null && !toolLeprechaun.isHidden()) {
            return true;
        }
        if (this.inventoryWidget == null || this.inventoryWidget.getCanvasLocation().getX() < 0 || this.inventoryWidget.isHidden()) {
            Widget[] altInventoryWidgets;
            Widget[] widgetArray = altInventoryWidgets = new Widget[]{this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER), this.client.getWidget(WidgetInfo.GRAND_EXCHANGE_INVENTORY_ITEMS_CONTAINER), this.client.getWidget(WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER), this.client.getWidget(15, 4), this.client.getWidget(15, 5), this.client.getWidget(268, 0), this.client.getWidget(551, 1)};
            int n = widgetArray.length;
            for (int i = 0; i < n; ++i) {
                Widget altInventoryWidget;
                this.inventoryWidget = altInventoryWidget = widgetArray[i];
                if (this.inventoryWidget == null || this.inventoryWidget.isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    void updatePluginState(boolean forceBanking) {
        boolean isBank;
        if (this.runData == null) {
            return;
        }
        this.inventoryWidget = this.client.getWidget(WidgetInfo.INVENTORY);
        this.inventoryItemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        this.equipmentItemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (this.config.inventoryOverlayDisplayMode() == ActiveTripOverlay.InventoryOverlayDisplayMode.INVENTORY_TOTAL) {
            this.setMode(TrackingMode.TOTAL);
        } else {
            this.setMode(TrackingMode.PROFIT_LOSS);
        }
        boolean bl = isBank = this.runData.isFirstRun || forceBanking || this.isBanking();
        if (isBank) {
            this.setState(RunState.BANK);
        } else {
            this.setState(RunState.RUN);
        }
        boolean newRun = this.getPreviousState() == RunState.BANK && this.getState() == RunState.RUN;
        this.getRunData().itemQtys.clear();
        long inventoryTotal = this.getInventoryTotal(false);
        long equipmentTotal = this.getEquipmentTotal(false);
        long totalGp = inventoryTotal;
        if (this.getState() == RunState.RUN && this.getMode() == TrackingMode.PROFIT_LOSS) {
            totalGp += equipmentTotal;
        }
        this.setTotalGp(totalGp);
        if (newRun) {
            this.onNewRun();
            this.postNewRun = true;
            this.newRunTick = this.client.getTickCount();
        } else if (this.getPreviousState() != RunState.BANK && this.getState() == RunState.BANK) {
            this.onBank();
        }
        if (this.postNewRun && (long)this.client.getTickCount() - this.newRunTick > 0L) {
            if (this.getState() == RunState.RUN) {
                this.postNewRun();
            } else {
                this.getRunData().isBankDelay = false;
            }
            this.postNewRun = false;
        }
    }

    void onNewRun() {
        this.runData.isBankDelay = true;
        this.runData.runStartTime = Instant.now().toEpochMilli();
        this.runData.ignoredItems = this.getIgnoredItems();
        this.previousTotalGp = null;
    }

    void postNewRun() {
        this.runData.initialItemQtys.clear();
        this.runData.itemQtys.clear();
        this.getInventoryTotal(true);
        this.getEquipmentTotal(true);
        this.initialGp = this.mode == TrackingMode.PROFIT_LOSS ? this.getInitialGp() : 0L;
        this.runData.isBankDelay = false;
        this.writeSavedData(this.currentProfileKey);
        this.sessionManager.onTripStarted(this.runData);
    }

    void onBank() {
        this.runData.runEndTime = Instant.now().toEpochMilli();
        if (!this.runData.isFirstRun) {
            this.sessionManager.onTripCompleted(this.runData);
        }
        this.runData = this.createRunData();
        this.initialGp = 0L;
    }

    long getInventoryTotal(boolean isNewRun) {
        if (this.inventoryItemContainer == null) {
            return 0L;
        }
        double totalGp = 0.0;
        this.refreshQtyMap(this.inventoryQtyMap, this.inventoryItemContainer);
        for (Integer itemId : this.inventoryQtyMap.keySet()) {
            float gePrice = this.getPrice(itemId);
            float itemQty = this.inventoryQtyMap.get(itemId).floatValue();
            totalGp += (double)(itemQty * gePrice);
            this.updateRunData(isNewRun, itemId, itemQty, gePrice);
        }
        return (long)totalGp;
    }

    public void openConfiguration() {
        this.eventBus.post((Object)new OverlayMenuClicked(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, null, null), (Overlay)this.tripOverlay));
    }

    public void refreshPrices() {
        LinkedList<Integer> itemIds = new LinkedList<Integer>(itemPrices.keySet());
        itemPrices.clear();
        for (Integer itemId : itemIds) {
            itemPrices.put(itemId, Float.valueOf(this.getPrice(itemId)));
        }
    }

    private void addChargedWeaponComponents(Map<Integer, Float> qtyMap) {
        Map<Integer, Float> chargedWeaponComponents = this.getChargedWeaponComponentQtyMap(qtyMap.keySet());
        for (int itemId : chargedWeaponComponents.keySet()) {
            qtyMap.merge(itemId, chargedWeaponComponents.get(itemId), Float::sum);
        }
    }

    private void addChargedItemComponents(Map<Integer, Float> qtyMap) {
        Map<Integer, Float> chargedItemComponents = this.getChargedItemQtyMap(qtyMap.keySet());
        for (int itemId : chargedItemComponents.keySet()) {
            qtyMap.merge(itemId, chargedItemComponents.get(itemId), Float::sum);
        }
    }

    long getEquipmentTotal(boolean isNewRun) {
        this.refreshQtyMap(this.equipmentQtyMap, this.equipmentItemContainer);
        double eTotal = 0.0;
        for (int itemId : this.equipmentQtyMap.keySet()) {
            float qty = this.equipmentQtyMap.get(itemId).floatValue();
            float gePrice = this.getPrice(itemId);
            eTotal += (double)(qty * gePrice);
            this.updateRunData(isNewRun, itemId, qty, gePrice);
        }
        return (long)eTotal;
    }

    private Map<Integer, Float> getChargedWeaponComponentQtyMap(Set<Integer> itemIdsToCheck) {
        this.chargedWeaponComponentQtyMap.clear();
        for (int itemId : itemIdsToCheck) {
            if (!this.weaponChargesManager.isChargeableWeapon(itemId) || !this.weaponChargesManager.hasChargeData(itemId)) continue;
            Map<Integer, Float> chargeComponents = this.weaponChargesManager.getChargeComponents(itemId);
            for (Integer chargeComponentItemId : chargeComponents.keySet()) {
                this.chargedWeaponComponentQtyMap.merge(chargeComponentItemId, chargeComponents.get(chargeComponentItemId), Float::sum);
            }
        }
        return this.chargedWeaponComponentQtyMap;
    }

    private Map<Integer, Float> getChargedItemQtyMap(Set<Integer> itemIdsToCheck) {
        this.chargedItemQtyMap.clear();
        for (int itemId : itemIdsToCheck) {
            if (!this.chargedItemManager.isChargeableItem(itemId) || !this.chargedItemManager.hasChargeData(itemId)) continue;
            Map<Integer, Float> itemContents = this.chargedItemManager.getItemQuantities(itemId);
            for (Integer itemContentId : itemContents.keySet()) {
                this.chargedItemQtyMap.merge(itemContentId, itemContents.get(itemContentId), Float::sum);
            }
        }
        return this.chargedItemQtyMap;
    }

    List<LedgerItem> getInventoryLedger() {
        LinkedList<LedgerItem> ledgerItems = new LinkedList<LedgerItem>();
        if (this.inventoryItemContainer == null) {
            return new LinkedList<LedgerItem>();
        }
        this.refreshQtyMap(this.inventoryQtyMap, this.inventoryItemContainer);
        for (Integer itemId : this.inventoryQtyMap.keySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
            String itemName = itemComposition.getName();
            Float qty = this.inventoryQtyMap.get(itemId);
            Float price = itemPrices.get(itemId);
            if (price == null) {
                price = Float.valueOf(1.0f);
            }
            ledgerItems.add(new LedgerItem(itemName, qty.floatValue(), price.floatValue(), itemId));
        }
        return ledgerItems;
    }

    void refreshQtyMap(Map<Integer, Float> qtyMap, ItemContainer container) {
        qtyMap.clear();
        if (container == null) {
            return;
        }
        Item[] containerItems = container.getItems();
        for (int i = 0; i < containerItems.length; ++i) {
            ItemComposition itemComposition;
            String itemName;
            boolean ignore;
            int itemId = containerItems[i].getId();
            if (itemId == -1 || (ignore = this.ignoredItems.contains((itemName = (itemComposition = this.itemManager.getItemComposition(itemId)).getName()).toLowerCase()))) continue;
            qtyMap.merge(itemId, Float.valueOf(containerItems[i].getQuantity()), Float::sum);
            if (itemId == 12791 || itemId == 27281) {
                this.addRunepouchContents(qtyMap);
                continue;
            }
            if (itemId != 11941 && itemId != 22586) continue;
            this.lootingBagManager.addLootingBagContents(qtyMap);
        }
        this.addChargedWeaponComponents(qtyMap);
        this.addChargedItemComponents(qtyMap);
        FractionalRemapper.Remap(qtyMap);
    }

    void updateChargeableItemsNeedingCheck() {
        this.chargeableItemsNeedingCheck.clear();
        if (this.state == RunState.BANK) {
            return;
        }
        this.checkQtyMapForCheck(this.inventoryQtyMap.keySet());
        this.checkQtyMapForCheck(this.equipmentQtyMap.keySet());
    }

    void checkQtyMapForCheck(Set<Integer> keySet) {
        for (Integer itemId : keySet) {
            if ((itemId == 11941 || itemId == 22586) && this.lootingBagManager.needsCheck()) {
                this.chargeableItemsNeedingCheck.add("looting bag");
                continue;
            }
            if (this.weaponChargesManager.isChargeableWeapon(itemId) && !this.weaponChargesManager.hasChargeData(itemId)) {
                this.chargeableItemsNeedingCheck.add(this.itemManager.getItemComposition(itemId.intValue()).getName().toLowerCase());
                continue;
            }
            if (!this.chargedItemManager.isChargeableItem(itemId) || this.chargedItemManager.hasChargeData(itemId)) continue;
            this.chargeableItemsNeedingCheck.add(this.itemManager.getItemComposition(itemId.intValue()).getName().toLowerCase());
        }
    }

    static List<LedgerItem> getProfitLossLedger(Map<Integer, Float> initialQtys, Map<Integer, Float> qtys) {
        HashMap<Integer, Float> qtyDifferences = new HashMap<Integer, Float>(initialQtys.size());
        HashSet<Integer> combinedQtyKeys = new HashSet<Integer>(initialQtys.size());
        combinedQtyKeys.addAll(qtys.keySet());
        combinedQtyKeys.addAll(initialQtys.keySet());
        for (Integer n : combinedQtyKeys) {
            Float initialQty = initialQtys.get(n);
            Float qty = qtys.get(n);
            if (initialQty == null) {
                initialQty = Float.valueOf(0.0f);
            }
            if (qty == null) {
                qty = Float.valueOf(0.0f);
            }
            qtyDifferences.put(n, Float.valueOf(qty.floatValue() - initialQty.floatValue()));
        }
        HashMap<String, LedgerItem> ledgerItems = new HashMap<String, LedgerItem>(qtyDifferences.size());
        for (Integer itemId : qtyDifferences.keySet()) {
            String name = itemNames.get(itemId);
            if (name == null) continue;
            Float price = itemPrices.get(itemId);
            if (price == null) {
                price = Float.valueOf(1.0f);
            }
            Float qtyDifference = (Float)qtyDifferences.get(itemId);
            if (ledgerItems.containsKey(name)) {
                ((LedgerItem)ledgerItems.get(name)).addQuantityDifference(qtyDifference.floatValue());
                continue;
            }
            if (price.floatValue() == 0.0f) continue;
            ledgerItems.put(name, new LedgerItem(name, qtyDifference.floatValue(), price.floatValue(), itemId));
        }
        LinkedList<LedgerItem> linkedList = new LinkedList<LedgerItem>();
        for (LedgerItem item : ledgerItems.values()) {
            if (!(Math.abs(item.getQty()) > 0.005f)) continue;
            linkedList.add(item);
        }
        return linkedList;
    }

    private void addRunepouchContents(Map<Integer, Float> qtyMap) {
        EnumComposition runepouchEnum = this.client.getEnum(982);
        for (int i = 0; i < RUNEPOUCH_AMOUNT_VARBITS.length; ++i) {
            int runeId;
            int amount = this.client.getVarbitValue(RUNEPOUCH_AMOUNT_VARBITS[i]);
            if (amount <= 0 || (runeId = this.client.getVarbitValue(RUNEPOUCH_RUNE_VARBITS[i])) == 0) continue;
            qtyMap.merge(runepouchEnum.getIntValue(runeId), Float.valueOf(amount), Float::sum);
        }
    }

    void updateRunData(boolean isNewRun, int itemId, float itemQty, float gePrice) {
        if (itemId != 995 && !itemPrices.containsKey(itemId)) {
            itemPrices.put(itemId, Float.valueOf(gePrice));
        }
        itemNames.put(itemId, this.itemManager.getItemComposition(itemId).getName());
        if (isNewRun) {
            if (this.runData.initialItemQtys.containsKey(itemId)) {
                this.runData.initialItemQtys.put(itemId, Float.valueOf(this.runData.initialItemQtys.get(itemId).floatValue() + itemQty));
            } else {
                this.runData.initialItemQtys.put(itemId, Float.valueOf(itemQty));
            }
        }
        if (this.runData.itemQtys.containsKey(itemId)) {
            this.runData.itemQtys.put(itemId, Float.valueOf(this.runData.itemQtys.get(itemId).floatValue() + itemQty));
        } else {
            this.runData.itemQtys.put(itemId, Float.valueOf(itemQty));
        }
    }

    float getPrice(int itemId) {
        if (itemId == 995) {
            return 1.0f;
        }
        if (itemId == 13204) {
            return 1000.0f;
        }
        if (itemPrices.containsKey(itemId)) {
            return itemPrices.get(itemId).floatValue();
        }
        Float remappedValue = ValueRemapper.remapPrice(itemId, this, this.config);
        if (remappedValue != null) {
            return remappedValue.floatValue();
        }
        if (this.config.valueMode() == ValueMode.RUNELITE_VALUE) {
            return this.itemManager.getItemPrice(itemId);
        }
        ItemComposition itemDef = this.itemManager.getItemComposition(itemId);
        int itemPrice = itemDef.getPrice();
        if (itemPrice <= 0) {
            return 0.0f;
        }
        return this.config.valueMode() == ValueMode.LOW_ALCHEMY_VALUE ? (float)itemPrice * 0.4f : (float)itemPrice * 0.6f;
    }

    void writeSavedData(String profileKey) {
        if (this.runData == null || this.runData.isFirstRun) {
            return;
        }
        this.executor.execute(() -> {
            String json = this.gson.toJson((Object)this.runData);
            this.configManager.setConfiguration("gpperhour", profileKey, "inventory_total_data", json);
        });
    }

    private TripData getSavedData() {
        String json = this.readData("inventory_total_data");
        TripData savedData = null;
        try {
            savedData = (TripData)this.gson.fromJson(json, TripData.class);
        }
        catch (Exception e) {
            log.error("Failed to load run data from json: " + json, (Throwable)e);
        }
        if (savedData == null) {
            TripData runData = this.createRunData();
            runData.isFirstRun = true;
            return runData;
        }
        return savedData;
    }

    private TripData createRunData() {
        TripData data = new TripData();
        data.identifier = UUID.randomUUID().toString();
        return data;
    }

    private LinkedList<String> getIgnoredItems() {
        return new LinkedList<String>(Arrays.asList(this.config.ignoredItems().split("\\s*,\\s*")));
    }

    long elapsedRunTime() {
        if (this.runData.runStartTime == 0L) {
            return -1L;
        }
        return this.runData.getRuntime();
    }

    void setMode(TrackingMode mode) {
        this.mode = mode;
        switch (mode) {
            case TOTAL: {
                this.initialGp = 0L;
                break;
            }
            case PROFIT_LOSS: {
                this.initialGp = this.getInitialGp();
            }
        }
    }

    long getInitialGp() {
        if (this.runData == null) {
            return 0L;
        }
        double value = 0.0;
        for (Map.Entry<Integer, Float> entry : this.runData.initialItemQtys.entrySet()) {
            value += (double)(this.getPrice(entry.getKey()) * entry.getValue().floatValue());
        }
        return (long)value;
    }

    void setState(RunState state) {
        this.previousState = this.state;
        this.state = state;
    }

    public long getProfitGp() {
        return this.totalGp - this.initialGp;
    }

    void saveData(String key, String data) {
        this.configManager.setRSProfileConfiguration("gpperhour", key, (Object)data);
    }

    String readData(String key) {
        return this.configManager.getRSProfileConfiguration("gpperhour", key);
    }

    <T> void saveData(String key, T data) {
        this.configManager.setRSProfileConfiguration("gpperhour", key, data);
    }

    void deleteData(String key) {
        this.configManager.unsetRSProfileConfiguration("gpperhour", key);
    }

    public Client getClient() {
        return this.client;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public TripData getRunData() {
        return this.runData;
    }

    public TrackingMode getMode() {
        return this.mode;
    }

    public RunState getState() {
        return this.state;
    }

    public RunState getPreviousState() {
        return this.previousState;
    }

    public long getTotalGp() {
        return this.totalGp;
    }

    public void setTotalGp(long totalGp) {
        this.totalGp = totalGp;
    }

    public Widget getInventoryWidget() {
        return this.inventoryWidget;
    }

    public HashSet<String> getChargeableItemsNeedingCheck() {
        return this.chargeableItemsNeedingCheck;
    }

    public static enum ValueMode {
        RUNELITE_VALUE("Runelite (Default)"),
        LOW_ALCHEMY_VALUE("Low Alchemy"),
        HIGH_ALCHEMY_VALUE("High Alchemy");

        private final String configName;

        public String toString() {
            return this.configName;
        }

        private ValueMode(String configName) {
            this.configName = configName;
        }
    }
}

