/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.ActiveSessionPanel;
import com.gpperhour.SessionHistoryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;

class GPPerHourPanel
extends PluginPanel {
    private static final Color lineColor = ColorScheme.BRAND_ORANGE;
    private final JPanel display = new JPanel();
    private final MaterialTabGroup tabGroup = new MaterialTabGroup(this.display);
    private final MaterialTab sessionHistoryTab;
    private final JPanel titlePanel = new JPanel();
    private final ActiveSessionPanel activeSessionPanel;
    private final SessionHistoryPanel sessionHistoryPanel;

    GPPerHourPanel(ActiveSessionPanel activeSessionPanel, SessionHistoryPanel sessionHistoryPanel) {
        super(false);
        this.activeSessionPanel = activeSessionPanel;
        this.sessionHistoryPanel = sessionHistoryPanel;
        this.buildTitlePanel();
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 5, 10, 5));
        MaterialTab activeSessionTab = new MaterialTab("Active Session", this.tabGroup, (JComponent)((Object)activeSessionPanel));
        this.sessionHistoryTab = new MaterialTab("Session History", this.tabGroup, (JComponent)sessionHistoryPanel);
        this.tabGroup.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        this.tabGroup.addTab(activeSessionTab);
        this.tabGroup.addTab(this.sessionHistoryTab);
        this.tabGroup.select(activeSessionTab);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.tabGroup, "North");
        centerPanel.add((Component)this.display, "Center");
        this.add(this.titlePanel, "North");
        this.add(centerPanel, "Center");
    }

    private JPanel buildTitlePanel() {
        this.titlePanel.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 5, 0), new MatteBorder(0, 0, 1, 0, lineColor)));
        this.titlePanel.setLayout(new BorderLayout());
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(2, 0, 10, 0));
        errorPanel.setContent("GP Per Hour", "Tracks your GP/hr over various trips.");
        this.titlePanel.add((Component)errorPanel, "Center");
        return this.titlePanel;
    }

    boolean isShowingActiveSession() {
        return this.activeSessionPanel.isShowing();
    }

    boolean isShowingSessionHistory() {
        return this.sessionHistoryPanel.isShowing();
    }

    void showActiveSession() {
        if (this.activeSessionPanel.isShowing()) {
            return;
        }
        this.tabGroup.select(this.sessionHistoryTab);
        this.revalidate();
    }

    public ActiveSessionPanel getActiveSessionPanel() {
        return this.activeSessionPanel;
    }

    public SessionHistoryPanel getSessionHistoryPanel() {
        return this.sessionHistoryPanel;
    }
}

