/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.SessionHistoryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableNameField
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(EditableNameField.class);
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private String name;
    private final JLabel save = new JLabel("Save");
    private final JLabel cancel = new JLabel("Cancel");
    private final JLabel edit = new JLabel("Edit Name");
    private final MouseAdapter flatTextFieldMouseAdapter;
    private final FlatTextField nameInput = new FlatTextField();
    private Consumer<String> onNameSaved;
    private boolean isEditing = false;

    public void setData(String name, Consumer<String> callback) {
        if (!name.equals(this.name)) {
            if (this.isEditing) {
                this.stopEditing();
            }
            this.name = name;
            this.nameInput.setText(name);
            this.updateSaveButtonDuringEditing();
        }
        this.onNameSaved = callback;
    }

    public EditableNameField(final SessionHistoryPanel panel, final int maxLength, Color panelColor, MouseAdapter flatTextFieldMouseAdapter) {
        this.flatTextFieldMouseAdapter = flatTextFieldMouseAdapter;
        this.setLayout(new BorderLayout());
        this.setBackground(panelColor);
        this.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new BorderLayout(3, 0));
        nameActions.setBorder(new EmptyBorder(0, 0, 0, 8));
        nameActions.setBackground(panelColor);
        AbstractDocument doc = (AbstractDocument)this.nameInput.getDocument();
        doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet a) throws BadLocationException {
                if (fb.getDocument().getLength() + str.length() <= maxLength) {
                    super.insertString(fb, offset, str, a);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet a) throws BadLocationException {
                if (fb.getDocument().getLength() + str.length() - length >= maxLength) {
                    int chars_available = maxLength - (fb.getDocument().getLength() - length);
                    int chars_to_cut = str.length() - chars_available;
                    str = str.substring(0, str.length() - chars_to_cut);
                }
                super.replace(fb, offset, length, str, a);
            }
        });
        this.nameInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditableNameField.this.updateSaveButtonDuringEditing();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditableNameField.this.updateSaveButtonDuringEditing();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditableNameField.this.updateSaveButtonDuringEditing();
            }
        });
        this.nameInput.getTextField().addMouseListener(flatTextFieldMouseAdapter);
        this.save.setVisible(false);
        this.save.setFont(FontManager.getRunescapeSmallFont());
        this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.save.setBackground(panelColor);
        this.save.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && EditableNameField.this.save.isEnabled()) {
                    EditableNameField.this.name = EditableNameField.this.nameInput.getText();
                    EditableNameField.this.onNameSaved.accept(EditableNameField.this.name);
                    panel.redrawPanels(false);
                    EditableNameField.this.stopEditing();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!EditableNameField.this.nameInput.getText().isEmpty()) {
                    EditableNameField.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
                } else {
                    EditableNameField.this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!EditableNameField.this.nameInput.getText().isEmpty()) {
                    EditableNameField.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
                } else {
                    EditableNameField.this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                }
            }
        });
        this.cancel.setVisible(false);
        this.cancel.setFont(FontManager.getRunescapeSmallFont());
        this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancel.setBackground(panelColor);
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    EditableNameField.this.nameInput.setText(EditableNameField.this.name);
                    EditableNameField.this.stopEditing();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EditableNameField.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EditableNameField.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.edit.setFont(FontManager.getRunescapeSmallFont());
        this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.edit.setBackground(panelColor);
        this.edit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    EditableNameField.this.startEditing();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EditableNameField.this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EditableNameField.this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameActions.add((Component)this.save, "East");
        nameActions.add((Component)this.cancel, "West");
        nameActions.add((Component)this.edit, "Center");
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(panelColor);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBackground(panelColor);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 6, 0, 0));
        this.nameInput.getTextField().setCaretPosition(0);
        JPanel wrapper = new JPanel();
        wrapper.setBackground(panelColor);
        wrapper.setLayout(new BorderLayout());
        wrapper.setBorder(new EmptyBorder(3, 0, 3, 0));
        wrapper.add((Component)this.nameInput, "Center");
        wrapper.add((Component)nameActions, "East");
        this.add((Component)wrapper, "Center");
    }

    private void startEditing() {
        this.isEditing = true;
        this.nameInput.getTextField().removeMouseListener(this.flatTextFieldMouseAdapter);
        this.nameInput.setEditable(true);
        this.updateNameActions(true);
    }

    private void stopEditing() {
        this.isEditing = false;
        this.nameInput.getTextField().addMouseListener(this.flatTextFieldMouseAdapter);
        this.nameInput.getTextField().setCaretPosition(0);
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.edit.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    private void updateSaveButtonDuringEditing() {
        if (this.nameInput.getText().isEmpty() || this.nameInput.getText().equals(this.name)) {
            this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            this.save.setEnabled(false);
        } else {
            this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            this.save.setEnabled(true);
        }
    }

    public FlatTextField getNameInput() {
        return this.nameInput;
    }
}

