/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPlugin;
import com.gpperhour.LedgerItem;
import com.gpperhour.RunState;
import com.gpperhour.SessionStats;
import com.gpperhour.UI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActiveTripOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ActiveTripOverlay.class);
    private static final int TEXT_Y_OFFSET = 17;
    private static final int HORIZONTAL_PADDING = 10;
    private static final int imageSize = 15;
    static final int COINS = 995;
    private final Client client;
    private final GPPerHourPlugin plugin;
    private final GPPerHourConfig config;
    private final ItemManager itemManager;
    private final SpriteManager spriteManager;
    private long lastGpPerHour;
    private long lastGpPerHourUpdateTime;
    private BufferedImage redXImage;
    private boolean hasLoadedCoinsImages;
    private BufferedImage coinsImage100;
    private BufferedImage coinsImage250;
    private BufferedImage coinsImage1000;
    private BufferedImage coinsImage10000;
    private InventoryWidgetData lastWidgetData;
    final int totalOverlayHeight = 20;

    @Inject
    private ActiveTripOverlay(Client client, GPPerHourPlugin plugin, GPPerHourConfig config, ItemManager itemManager, SpriteManager spriteManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.spriteManager = spriteManager;
    }

    public Dimension render(Graphics2D graphics) {
        boolean isInvHidden;
        if (this.plugin.getRunData() == null) {
            return null;
        }
        Widget inventoryWidget = this.plugin.getInventoryWidget();
        boolean bl = isInvHidden = inventoryWidget == null || inventoryWidget.isHidden();
        if (isInvHidden && (!this.config.alwaysShowTripOverlay() || this.lastWidgetData == null)) {
            return null;
        }
        if (!isInvHidden) {
            if (this.lastWidgetData == null) {
                this.lastWidgetData = new InventoryWidgetData();
            }
            this.lastWidgetData.canvasLocation = inventoryWidget.getCanvasLocation();
            this.lastWidgetData.width = inventoryWidget.getWidth();
            this.lastWidgetData.height = inventoryWidget.getHeight();
        }
        if (this.config.inventoryOverlayDisplayMode().sessionData) {
            this.renderActiveSessionTotal(graphics);
        } else {
            this.renderActiveTripTotal(graphics);
        }
        return null;
    }

    private void renderActiveSessionTotal(Graphics2D graphics) {
        SessionStats sessionStats = this.plugin.getSessionManager().getActiveSessionStats();
        if (sessionStats == null) {
            Object totalText = "0";
            if (this.config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.SESSION_GP_PER_HOUR) {
                totalText = (String)totalText + "/hr";
            }
            this.renderTotal(this.config, graphics, this.plugin, 0L, (String)totalText, null, 20);
            return;
        }
        long total = sessionStats.getNetTotal();
        Object totalText = UI.formatGp(total, this.config.showExactGp());
        if (this.config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.SESSION_GP_PER_HOUR) {
            total = this.getGpPerHour(sessionStats.getSessionRuntime(), total);
            totalText = UI.formatGp(total, this.config.showExactGp()) + "/hr";
        }
        String formattedRunTime = this.config.showRunTime() ? UI.formatTime(sessionStats.getSessionRuntime()) : null;
        String runTimeText = null;
        if (formattedRunTime != null) {
            runTimeText = " (" + formattedRunTime + ")";
        }
        this.renderTotal(this.config, graphics, this.plugin, total, (String)totalText, runTimeText, 20);
    }

    private void renderActiveTripTotal(Graphics2D graphics) {
        long total = this.plugin.getProfitGp();
        Object totalText = UI.formatGp(total, this.config.showExactGp());
        if (this.config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.TRIP_GP_PER_HOUR && this.plugin.getState() == RunState.RUN && !this.plugin.getRunData().isBankDelay) {
            total = this.getGpPerHour(this.plugin.elapsedRunTime(), total);
            totalText = UI.formatGp(total, this.config.showExactGp()) + "/hr";
        }
        String formattedRunTime = this.getFormattedRunTime();
        String runTimeText = null;
        if (formattedRunTime != null) {
            runTimeText = " (" + formattedRunTime + ")";
        }
        if (this.plugin.getRunData().isBankDelay) {
            total = 0L;
            totalText = this.config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.TRIP_GP_PER_HOUR ? "0/hr" : (this.config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.TRIP_PROFIT ? "0" : UI.formatGp(this.plugin.getTotalGp(), this.config.showExactGp()));
        }
        this.renderTotal(this.config, graphics, this.plugin, total, (String)totalText, runTimeText, 20);
    }

    private boolean needsCheck() {
        return this.plugin.getChargeableItemsNeedingCheck().size() != 0;
    }

    private void loadCoinsImages() {
        this.coinsImage100 = this.loadCoinsImage(100);
        this.coinsImage250 = this.loadCoinsImage(250);
        this.coinsImage1000 = this.loadCoinsImage(1000);
        this.coinsImage10000 = this.loadCoinsImage(10000);
        this.hasLoadedCoinsImages = true;
    }

    private BufferedImage loadCoinsImage(int quantity) {
        Object image = this.itemManager.getImage(995, quantity, false);
        image = ImageUtil.resizeImage((BufferedImage)image, (int)15, (int)15);
        return image;
    }

    private BufferedImage getCoinsImage(int quantity) {
        long absValue;
        if (!this.hasLoadedCoinsImages) {
            this.loadCoinsImages();
        }
        if ((absValue = (long)Math.abs(quantity)) >= 10000L) {
            return this.coinsImage10000;
        }
        if (absValue >= 1000L) {
            return this.coinsImage1000;
        }
        if (absValue >= 250L) {
            return this.coinsImage250;
        }
        return this.coinsImage100;
    }

    private BufferedImage getRedXImage() {
        if (this.redXImage == null) {
            this.redXImage = this.spriteManager.getSprite(940, 0);
            this.redXImage = ImageUtil.resizeImage((BufferedImage)this.redXImage, (int)15, (int)15);
        }
        return this.redXImage;
    }

    private void renderTotal(GPPerHourConfig config, Graphics2D graphics, GPPerHourPlugin plugin, long total, String totalText, String runTimeText, int height) {
        int imageOffset;
        int containerAlpha;
        Color textColor;
        Color borderColor;
        Color backgroundColor;
        int numCoins;
        boolean showCoinStack = config.showCoinStack();
        boolean showCheckIcon = this.needsCheck();
        if (total > Integer.MAX_VALUE) {
            numCoins = Integer.MAX_VALUE;
        } else if (total < Integer.MIN_VALUE) {
            numCoins = Integer.MIN_VALUE;
        } else {
            numCoins = (int)total;
            if (numCoins == 0) {
                numCoins = 1000000;
            }
        }
        numCoins = Math.abs(numCoins);
        if (total == 0L && !config.showOnEmpty() || plugin.getState() == RunState.BANK && !config.showWhileBanking()) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        int totalWidth = graphics.getFontMetrics().stringWidth(totalText);
        int fixedRunTimeWidth = 0;
        int actualRunTimeWidth = 0;
        int imageWidthWithPadding = 0;
        if (runTimeText != null && runTimeText.length() >= 2) {
            fixedRunTimeWidth = 5 * (runTimeText.length() - 2) + 6 + 5;
            actualRunTimeWidth = graphics.getFontMetrics().stringWidth(runTimeText);
        }
        if (showCoinStack) {
            imageWidthWithPadding = 18;
        }
        if (showCheckIcon) {
            imageWidthWithPadding += 18;
        }
        int width = totalWidth + fixedRunTimeWidth + imageWidthWithPadding + 20;
        int x = this.lastWidgetData.getCanvasLocation().getX() + this.lastWidgetData.getWidth() / 2 - width / 2;
        switch (config.horizontalAlignment()) {
            case CENTER: {
                break;
            }
            case LEFT: {
                x = this.lastWidgetData.getCanvasLocation().getX();
                break;
            }
            case RIGHT: {
                x = this.lastWidgetData.getCanvasLocation().getX() + this.lastWidgetData.getWidth() - width;
            }
        }
        int xOffset = config.inventoryXOffset();
        if (config.isInventoryXOffsetNegative()) {
            xOffset *= -1;
        }
        x += xOffset;
        int yOffset = config.inventoryYOffset();
        if (config.isInventoryYOffsetNegative()) {
            yOffset *= -1;
        }
        int y = this.lastWidgetData.getCanvasLocation().getY() - height - yOffset;
        if (plugin.getState() == RunState.BANK || config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.INVENTORY_TOTAL) {
            backgroundColor = config.totalColor();
            borderColor = config.borderColor();
            textColor = config.textColor();
        } else if (total >= 0L) {
            backgroundColor = config.profitColor();
            borderColor = config.profitBorderColor();
            textColor = config.profitTextColor();
        } else {
            backgroundColor = config.lossColor();
            borderColor = config.lossBorderColor();
            textColor = config.lossTextColor();
        }
        int cornerRadius = config.cornerRadius();
        if (!config.roundCorners()) {
            cornerRadius = 0;
        }
        if ((containerAlpha = backgroundColor.getAlpha()) > 0) {
            graphics.setColor(borderColor);
            graphics.drawRoundRect(x, y, width + 1, height + 1, cornerRadius, cornerRadius);
        }
        graphics.setColor(backgroundColor);
        graphics.fillRoundRect(x + 1, y + 1, width, height, cornerRadius, cornerRadius);
        TextComponent textComponent = new TextComponent();
        textComponent.setColor(textColor);
        textComponent.setText(totalText);
        textComponent.setPosition(new java.awt.Point(x + 10, y + 17));
        textComponent.render(graphics);
        if (runTimeText != null) {
            textComponent = new TextComponent();
            textComponent.setColor(textColor);
            textComponent.setText(runTimeText);
            textComponent.setPosition(new java.awt.Point(x + width - 10 - actualRunTimeWidth - imageWidthWithPadding, y + 17));
            textComponent.render(graphics);
        }
        if (showCoinStack) {
            imageOffset = 4;
            if (showCheckIcon) {
                imageOffset -= imageWidthWithPadding / 2;
            }
            BufferedImage image = this.getCoinsImage(numCoins / 100);
            graphics.drawImage((Image)image, x + width - 10 - 15 + imageOffset, y + 3, null);
        }
        if (showCheckIcon) {
            imageOffset = 4;
            BufferedImage redXImage = this.getRedXImage();
            graphics.drawImage((Image)redXImage, x + width - 10 - 15 + imageOffset, y + 3, null);
        }
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        boolean isTripRunning = !config.inventoryOverlayDisplayMode().sessionData && plugin.getState() != RunState.BANK && !plugin.getRunData().isBankDelay;
        boolean isSessionRunning = config.inventoryOverlayDisplayMode().sessionData && plugin.getSessionManager().getActiveSessionStats() != null;
        RoundRectangle2D.Double roundRectangle2D = new RoundRectangle2D.Double(x, y, width + 1, height + 1, cornerRadius, cornerRadius);
        if (roundRectangle2D.contains(mouseX, mouseY) && (isTripRunning || isSessionRunning) && config.showLedgerOnHover()) {
            if (config.inventoryOverlayDisplayMode() == InventoryOverlayDisplayMode.INVENTORY_TOTAL) {
                this.renderLedger(graphics);
            } else {
                this.renderProfitLossLedger(graphics);
            }
        }
    }

    private void renderLedger(Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        List ledger = this.plugin.getInventoryLedger().stream().filter(item -> item.getQty() > 0.005f).collect(Collectors.toList());
        LinkedList<LedgerEntry> ledgerEntries = new LinkedList<LedgerEntry>();
        ledgerEntries.add(this.createTitleEntry(false));
        if (ledger.isEmpty()) {
            ledgerEntries.add(this.createEmptyEntry());
        } else {
            Long[] prices;
            String[] descriptions = (String[])(ledger = ledger.stream().sorted(Comparator.comparingLong(o -> -o.getCombinedValue())).collect(Collectors.toList())).stream().map(item -> {
                Object desc = item.getDescription();
                if (item.getQty() != 0.0f && Math.abs(item.getQty()) != 1.0f && !item.getDescription().contains("Coins")) {
                    desc = UI.formatQuantity(item.getQty(), true) + " " + (String)desc;
                }
                return desc;
            }).toArray(String[]::new);
            if (descriptions.length == (prices = (Long[])ledger.stream().map(item -> item.getCombinedValue()).toArray(Long[]::new)).length) {
                for (int i = 0; i < descriptions.length; ++i) {
                    String desc = descriptions[i];
                    long price = prices[i];
                    String rightText = this.formatNumber(price);
                    Color leftColor = Color.decode("#FFF7E3");
                    Color rightColor = price > 0L ? Color.GREEN : Color.WHITE;
                    ledgerEntries.add(new LedgerEntry(desc, leftColor, rightText, rightColor, false));
                }
            }
            long total = ledger.stream().mapToLong(item -> item.getCombinedValue()).sum();
            ledgerEntries.add(new LedgerEntry("Total", Color.ORANGE, this.formatNumber(total), this.priceToColor(total), true));
        }
        boolean firstCharge = true;
        for (String itemName : this.plugin.getChargeableItemsNeedingCheck()) {
            ledgerEntries.add(new LedgerEntry("Check " + itemName + " to calibrate.", Color.RED, "", Color.WHITE, firstCharge));
            firstCharge = false;
        }
        int maxRowW = 0;
        int sectionPadding = 5;
        int sectionPaddingTotal = 0;
        for (LedgerEntry entry : ledgerEntries) {
            int width = fontMetrics.stringWidth(entry.leftText) + fontMetrics.stringWidth(entry.rightText);
            if (width > maxRowW) {
                maxRowW = width;
            }
            if (entry.addGapBefore) {
                sectionPaddingTotal += sectionPadding;
            }
            if (!entry.addGapAfter) continue;
            sectionPaddingTotal += sectionPadding;
        }
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        int rowW = maxRowW + 20 + 20;
        int rowH = fontMetrics.getHeight();
        int h = ledgerEntries.size() * rowH + 8 + sectionPaddingTotal + 2;
        int x = mouseX - rowW - 10;
        int y = mouseY - h / 2;
        int cornerRadius = 0;
        graphics.setColor(Color.decode("#1b1b1b"));
        graphics.fillRoundRect(x, y, rowW, h, cornerRadius, cornerRadius);
        int borderWidth = 1;
        graphics.setColor(Color.decode("#0b0b0b"));
        graphics.setStroke(new BasicStroke(borderWidth));
        graphics.drawRoundRect(x - borderWidth / 2, y - borderWidth / 2, rowW + borderWidth / 2, h + borderWidth / 2, cornerRadius, cornerRadius);
        this.renderLedgerEntries(ledgerEntries, x, y, rowW, rowH, sectionPadding, graphics);
    }

    private LedgerEntry createTitleEntry(boolean isSessionStats) {
        LedgerEntry titleEntry = new LedgerEntry(isSessionStats ? "Active Session Summary" : "Active Trip Summary", Color.WHITE, "", Color.WHITE, false);
        titleEntry.addGapAfter = true;
        titleEntry.center = true;
        return titleEntry;
    }

    private LedgerEntry createEmptyEntry() {
        LedgerEntry emptyEntry = new LedgerEntry("Ledger items will appear here.", Color.WHITE, "", Color.WHITE, false);
        return emptyEntry;
    }

    private void renderProfitLossLedger(Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        List<LedgerItem> ledger = null;
        if (this.config.inventoryOverlayDisplayMode().sessionData) {
            SessionStats stats = this.plugin.getSessionManager().getActiveSessionStats();
            ledger = GPPerHourPlugin.getProfitLossLedger(stats.getInitialQtys(), stats.getQtys());
        } else {
            ledger = GPPerHourPlugin.getProfitLossLedger(this.plugin.getRunData().initialItemQtys, this.plugin.getRunData().itemQtys);
        }
        List gain = ledger.stream().filter(item -> item.getQty() > 0.0f).collect(Collectors.toList());
        List loss = ledger.stream().filter(item -> item.getQty() < 0.0f).collect(Collectors.toList());
        gain = gain.stream().sorted(Comparator.comparingLong(o -> -o.getCombinedValue())).collect(Collectors.toList());
        loss = loss.stream().sorted(Comparator.comparingLong(o -> -o.getCombinedValue())).collect(Collectors.toList());
        ledger = new LinkedList<LedgerItem>();
        ledger.addAll(gain);
        ledger.addAll(loss);
        LinkedList<LedgerEntry> ledgerEntries = new LinkedList<LedgerEntry>();
        ledgerEntries.add(this.createTitleEntry(this.config.inventoryOverlayDisplayMode().sessionData));
        if (ledger.isEmpty()) {
            ledgerEntries.add(this.createEmptyEntry());
        } else {
            Long[] prices;
            String[] descriptions = (String[])ledger.stream().map(item -> {
                Object desc = item.getDescription();
                if (item.getQty() != 0.0f && Math.abs(item.getQty()) != 1.0f && !item.getDescription().contains("Coins")) {
                    desc = UI.formatQuantity(item.getQty(), true) + " " + (String)desc;
                }
                return desc;
            }).toArray(String[]::new);
            if (descriptions.length == (prices = (Long[])ledger.stream().map(item -> item.getCombinedValue()).toArray(Long[]::new)).length) {
                String prevDesc = "";
                for (int i = 0; i < descriptions.length; ++i) {
                    Color leftColor = Color.decode("#FFF7E3");
                    Color rightColor = Color.WHITE;
                    boolean addGap = false;
                    String desc = descriptions[i];
                    if (i > 0 && prices[i - 1] >= 0L && prices[i] < 0L && !prevDesc.contains("Total")) {
                        addGap = true;
                    }
                    prevDesc = desc;
                    long price = prices[i];
                    String formattedPrice = this.formatNumber(price);
                    rightColor = this.priceToColor(price);
                    ledgerEntries.add(new LedgerEntry(desc, leftColor, formattedPrice, rightColor, addGap));
                }
            }
            long totalGain = gain.stream().mapToLong(item -> item.getCombinedValue()).sum();
            long totalLoss = loss.stream().mapToLong(item -> item.getCombinedValue()).sum();
            long netTotal = ledger.stream().mapToLong(item -> item.getCombinedValue()).sum();
            ledgerEntries.add(new LedgerEntry("Total Gain", Color.YELLOW, this.formatNumber(totalGain), this.priceToColor(totalGain), true));
            ledgerEntries.add(new LedgerEntry("Total Loss", Color.YELLOW, this.formatNumber(totalLoss), this.priceToColor(totalLoss), false));
            ledgerEntries.add(new LedgerEntry("Net Total", Color.ORANGE, this.formatNumber(netTotal), this.priceToColor(netTotal), false));
            long runTime = this.plugin.elapsedRunTime();
            if (runTime != -1L) {
                long gpPerHour = this.getGpPerHour(runTime, netTotal);
                String gpPerHourString = UI.formatGp(gpPerHour, this.config.showExactGp());
                ledgerEntries.add(new LedgerEntry("GP/hr", Color.ORANGE, gpPerHourString, this.priceToColor(gpPerHour), false));
            }
        }
        boolean firstCharge = true;
        for (String itemName : this.plugin.getChargeableItemsNeedingCheck()) {
            ledgerEntries.add(new LedgerEntry("Check " + itemName + " to calibrate.", Color.RED, "", Color.WHITE, firstCharge));
            firstCharge = false;
        }
        int maxRowW = 0;
        int sectionPadding = 5;
        int sectionPaddingTotal = 0;
        for (LedgerEntry entry : ledgerEntries) {
            int width = fontMetrics.stringWidth(entry.leftText) + fontMetrics.stringWidth(entry.rightText);
            if (width > maxRowW) {
                maxRowW = width;
            }
            if (entry.addGapBefore) {
                sectionPaddingTotal += sectionPadding;
            }
            if (!entry.addGapAfter) continue;
            sectionPaddingTotal += sectionPadding;
        }
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        int rowW = maxRowW + 20 + 20;
        int rowH = fontMetrics.getHeight();
        int h = ledgerEntries.size() * rowH + 8 + sectionPaddingTotal + 2;
        int x = mouseX - rowW - 10;
        int y = mouseY - h / 2;
        int cornerRadius = 0;
        graphics.setColor(Color.decode("#1b1b1b"));
        graphics.fillRoundRect(x, y, rowW, h, cornerRadius, cornerRadius);
        int borderWidth = 1;
        graphics.setColor(Color.decode("#0b0b0b"));
        graphics.setStroke(new BasicStroke(borderWidth));
        graphics.drawRoundRect(x - borderWidth / 2, y - borderWidth / 2, rowW + borderWidth / 2, h + borderWidth / 2, cornerRadius, cornerRadius);
        this.renderLedgerEntries(ledgerEntries, x, y, rowW, rowH, sectionPadding, graphics);
    }

    long getGpPerHour(long runTime, long total) {
        long timeNow = Instant.now().toEpochMilli();
        if (timeNow - this.lastGpPerHourUpdateTime < 1000L) {
            return this.lastGpPerHour;
        }
        this.lastGpPerHourUpdateTime = timeNow;
        this.lastGpPerHour = UI.getGpPerHour(runTime, total);
        return this.lastGpPerHour;
    }

    String formatNumber(long number) {
        return QuantityFormatter.formatNumber((long)number);
    }

    Color priceToColor(long price) {
        if (price > 0L) {
            return Color.GREEN;
        }
        if (price < 0L) {
            return Color.RED;
        }
        return Color.WHITE;
    }

    private void renderLedgerEntries(LinkedList<LedgerEntry> ledgerEntries, int x, int y, int rowW, int rowH, int sectionPadding, Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int yPosition = 17;
        for (LedgerEntry ledgerEntry : ledgerEntries) {
            if (ledgerEntry.addGapBefore) {
                yPosition += sectionPadding;
            }
            if (ledgerEntry.center) {
                String leftText = ledgerEntry.leftText;
                int textW = fontMetrics.stringWidth(leftText);
                int textX = x + rowW / 2 - textW / 2;
                int textY = y + yPosition;
                TextComponent textComponent = new TextComponent();
                textComponent.setColor(ledgerEntry.leftColor);
                textComponent.setText(leftText);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
            } else {
                int textX = x + 10;
                int textY = y + yPosition;
                TextComponent textComponent = new TextComponent();
                textComponent.setColor(ledgerEntry.leftColor);
                textComponent.setText(ledgerEntry.leftText);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
                String rightText = ledgerEntry.rightText;
                int textW = fontMetrics.stringWidth(rightText);
                textX = x + rowW - 10 - textW;
                textComponent = new TextComponent();
                textComponent.setColor(ledgerEntry.rightColor);
                textComponent.setText(rightText);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
            }
            yPosition += rowH;
            if (!ledgerEntry.addGapAfter) continue;
            yPosition += sectionPadding;
        }
    }

    private String getFormattedRunTime() {
        if (!this.config.showRunTime()) {
            return null;
        }
        long runTime = this.plugin.elapsedRunTime();
        if (runTime == -1L) {
            return null;
        }
        return UI.formatTime(runTime);
    }

    public static enum InventoryOverlayDisplayMode {
        TRIP_GP_PER_HOUR("Trip GP/hr", false),
        TRIP_PROFIT("Trip Profit", false),
        SESSION_GP_PER_HOUR("Session GP/hr", true),
        SESSION_PROFIT("Session Profit", true),
        INVENTORY_TOTAL("Inventory Value", false);

        private final String configName;
        private final boolean sessionData;

        public String toString() {
            return this.configName;
        }

        private InventoryOverlayDisplayMode(String configName, boolean sessionData) {
            this.configName = configName;
            this.sessionData = sessionData;
        }
    }

    class LedgerEntry {
        final String leftText;
        final Color leftColor;
        final String rightText;
        final Color rightColor;
        final boolean addGapBefore;
        boolean center;
        boolean addGapAfter;

        public LedgerEntry(String leftText, Color leftColor, String rightText, Color rightColor, boolean addGapBefore) {
            this.leftText = leftText;
            this.leftColor = leftColor;
            this.rightText = rightText;
            this.rightColor = rightColor;
            this.addGapBefore = addGapBefore;
        }
    }

    private class InventoryWidgetData {
        public Point canvasLocation;
        public int width;
        public int height;

        public Point getCanvasLocation() {
            return this.canvasLocation;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setCanvasLocation(Point canvasLocation) {
            this.canvasLocation = canvasLocation;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InventoryWidgetData)) {
                return false;
            }
            InventoryWidgetData other = (InventoryWidgetData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            Point this$canvasLocation = this.getCanvasLocation();
            Point other$canvasLocation = other.getCanvasLocation();
            return !(this$canvasLocation == null ? other$canvasLocation != null : !this$canvasLocation.equals(other$canvasLocation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InventoryWidgetData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            Point $canvasLocation = this.getCanvasLocation();
            result = result * 59 + ($canvasLocation == null ? 43 : $canvasLocation.hashCode());
            return result;
        }

        public String toString() {
            return "ActiveTripOverlay.InventoryWidgetData(canvasLocation=" + this.getCanvasLocation() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }
}

