/*
 * Decompiled with CFR 0.152.
 */
package com.gpperhour;

import com.gpperhour.GPPerHourConfig;
import com.gpperhour.GPPerHourPlugin;
import com.gpperhour.LedgerItem;
import com.gpperhour.SessionManager;
import com.gpperhour.SessionStats;
import com.gpperhour.TripData;
import com.gpperhour.UI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActiveSessionPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ActiveSessionPanel.class);
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private static final String sessionNameLabelPlaceholder = "Session Stats";
    private static final String gpPerHourLabelPrefix = "GP/hr: ";
    private static final String netTotalLabelPrefix = "Net Total: ";
    private static final String totalGainsLabelPrefix = "Total Gains: ";
    private static final String totalLossesLabelPrefix = "Total Losses: ";
    private static final String sessionTimeLabelPrefix = "Session Time: ";
    private static final String tripCountLabelPrefix = "Trip Count: ";
    private static final String avgTripDurationLabelPrefix = "Avg Trip Duration: ";
    private static final Color tripActiveBorderColor = new Color(37, 107, 31);
    private static final Color borderColor = new Color(57, 57, 57);
    private final GPPerHourConfig config;
    private final GPPerHourPlugin plugin;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final SessionManager sessionManager;
    private final JPanel tripsPanel = new JPanel();
    GridBagConstraints constraints = new GridBagConstraints();
    private final JPanel sessionInfoPanel;
    private final List<TripPanelData> tripPanels = new LinkedList<TripPanelData>();
    private JLabel startTrackingButton;
    private JLabel stopTrackingButton;
    private final JLabel sessionNameLabel = new JLabel("Session Stats");
    private final JLabel gpPerHourLabel = new JLabel(ActiveSessionPanel.htmlLabel("GP/hr: ", "N/A"));
    private final JLabel netTotalLabel = new JLabel(ActiveSessionPanel.htmlLabel("Net Total: ", "N/A"));
    private final JLabel totalGainsLabel = new JLabel(ActiveSessionPanel.htmlLabel("Total Gains: ", "N/A"));
    private final JLabel totalLossesLabel = new JLabel(ActiveSessionPanel.htmlLabel("Total Losses: ", "N/A"));
    private final JLabel sessionTimeLabel = new JLabel(ActiveSessionPanel.htmlLabel("Session Time: ", "N/A"));
    private final JLabel tripCountLabel = new JLabel(ActiveSessionPanel.htmlLabel("Trip Count: ", "N/A"));
    private final JLabel avgTripDurationLabel = new JLabel(ActiveSessionPanel.htmlLabel("Avg Trip Duration: ", "N/A"));
    private final JLabel errorLabel = new JLabel("Error");
    private Component errorSpacing;
    private Component tripCountSpacing;
    private Component avgTripDurationSpacing;
    private final UI.LootPanelData sessionLootPanelData = new UI.LootPanelData();
    private boolean showSessionLootGrid = true;
    private final List<LedgerItem> emptyLedger = new LinkedList<LedgerItem>();
    TripData previousRunData = null;
    List<LedgerItem> previousLedger = null;
    int repeatCount = 0;
    int consecutiveRepeatCount = 0;
    long previousGpPerHour = 0L;
    long combinedRuntime;

    ActiveSessionPanel(GPPerHourPlugin plugin, GPPerHourConfig config, ItemManager itemManager, ClientThread clientThread, SessionManager sessionManager) {
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.sessionManager = sessionManager;
        this.sessionInfoPanel = new JPanel();
    }

    void sidePanelInitializer() {
        this.setLayout(new BorderLayout());
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(0, 0));
        container.setBorder(new EmptyBorder(0, 0, 0, 0));
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.tripsPanel.setLayout(new GridBagLayout());
        this.tripsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.tripsPanel, "North");
        JScrollPane tripsWrapper = new JScrollPane(wrapper);
        tripsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        tripsWrapper.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        tripsWrapper.getVerticalScrollBar().setBorder(new EmptyBorder(0, 5, 0, 0));
        tripsWrapper.setHorizontalScrollBarPolicy(31);
        container.add((Component)this.buildSessionInfoPanel(), "North");
        container.add((Component)tripsWrapper, "Center");
        this.add(container, "Center");
    }

    void setTripCountAndDurationVisible(boolean visible) {
        this.tripCountLabel.setVisible(visible);
        this.avgTripDurationLabel.setVisible(visible);
        this.tripCountSpacing.setVisible(visible);
        this.avgTripDurationSpacing.setVisible(visible);
    }

    private JPanel buildSessionInfoPanel() {
        this.sessionInfoPanel.setLayout(new BorderLayout(0, 10));
        this.sessionInfoPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel sessionInfoSection = new JPanel();
        sessionInfoSection.setLayout(new BoxLayout(sessionInfoSection, 1));
        sessionInfoSection.setBorder(new EmptyBorder(6, 5, 3, 0));
        int vGap = 6;
        this.sessionNameLabel.setFont(FontManager.getRunescapeBoldFont());
        sessionInfoSection.add(this.sessionNameLabel);
        UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.gpPerHourLabel);
        UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.netTotalLabel);
        UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.totalGainsLabel);
        UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.totalLossesLabel);
        UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.tripCountLabel);
        this.tripCountSpacing = UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.avgTripDurationLabel);
        this.avgTripDurationSpacing = UI.addVerticalRigidBox(sessionInfoSection, vGap);
        sessionInfoSection.add(this.sessionTimeLabel);
        this.errorSpacing = UI.addVerticalRigidBox(sessionInfoSection, vGap);
        this.errorLabel.setForeground(Color.red);
        sessionInfoSection.add(this.errorLabel);
        this.errorLabel.setVisible(false);
        this.errorSpacing.setVisible(false);
        JLabel newTripButton = UI.createIconButton(UI.SESSIONINFO_PLUS_ICON, UI.SESSIONINFO_PLUS_HOVER_ICON, "Create new trip", () -> this.clientThread.invokeLater(() -> this.plugin.updatePluginState(true)));
        this.startTrackingButton = UI.createIconButton(UI.SESSIONINFO_PLAY_ICON, UI.SESSIONINFO_PLAY_HOVER_ICON, "Start tracking new trips", () -> {
            this.config.setEnableSessionTracking(true);
            this.updateStopStartVisibility();
            this.updateTrips();
        });
        this.stopTrackingButton = UI.createIconButton(UI.SESSIONINFO_STOP_ICON, UI.SESSIONINFO_STOP_HOVER_ICON, "Stop tracking new trips", () -> {
            this.config.setEnableSessionTracking(false);
            this.updateStopStartVisibility();
            this.updateTrips();
        });
        this.updateStopStartVisibility();
        JLabel toggleSessionLootGridButton = UI.createIconButton(UI.SESSIONINFO_GRID_ICON, UI.SESSIONINFO_GRID_HOVER_ICON, "Toggle session loot grid", () -> {
            this.showSessionLootGrid = !this.showSessionLootGrid;
            this.updateTrips();
        });
        JLabel refreshPricesButton = UI.createIconButton(UI.SESSIONINFO_REFRESH_ICON, UI.SESSIONINFO_REFRESH_HOVER_ICON, "Refresh prices", () -> this.clientThread.invokeLater(() -> this.plugin.refreshPrices()));
        JLabel deleteTripsButton = UI.createIconButton(UI.SESSIONINFO_TRASH_ICON, UI.SESSIONINFO_TRASH_HOVER_ICON, "Delete all completed trips", () -> {
            int confirm = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete all completed trips?", "Warning", 2);
            if (confirm == 0) {
                this.sessionManager.deleteAllTrips();
                this.updateTrips();
            }
        });
        JLabel settingsButton = UI.createIconButton(UI.SESSIONINFO_GEAR_ICON, UI.SESSIONINFO_GEAR_HOVER_ICON, "Open configuration", () -> this.clientThread.invokeLater(() -> this.plugin.openConfiguration()));
        JLabel saveButton = UI.createIconButton(UI.SESSIONINFO_SAVE_ICON, UI.SESSIONINFO_SAVE_HOVER_ICON, "Save session", () -> {
            String name = JOptionPane.showInputDialog((Component)((Object)this), "Enter the name of the session to save.\nThis will not delete the selected trips.", "Save Session", -1);
            if (name == null) {
                return;
            }
            if (name.isEmpty()) {
                name = "Unnamed Session";
            }
            this.sessionManager.saveNewSession(name);
        });
        JPanel iconButtons = new JPanel(new FlowLayout(1, 8, 0));
        iconButtons.add(newTripButton);
        iconButtons.add(this.startTrackingButton);
        iconButtons.add(this.stopTrackingButton);
        iconButtons.add(saveButton);
        iconButtons.add(toggleSessionLootGridButton);
        iconButtons.add(refreshPricesButton);
        iconButtons.add(deleteTripsButton);
        iconButtons.add(settingsButton);
        this.sessionLootPanelData.lootPanel.setLayout(new BorderLayout());
        this.sessionLootPanelData.lootPanel.setBorder(new MatteBorder(1, 1, 1, 1, borderColor));
        this.sessionInfoPanel.add((Component)sessionInfoSection, "North");
        this.sessionInfoPanel.add((Component)iconButtons, "Center");
        this.sessionInfoPanel.add((Component)this.sessionLootPanelData.lootPanel, "South");
        return this.sessionInfoPanel;
    }

    void updateStopStartVisibility() {
        this.startTrackingButton.setVisible(!this.config.getEnableSessionTracking());
        this.stopTrackingButton.setVisible(this.config.getEnableSessionTracking());
    }

    void updateTrips() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Map<String, TripData> trips = this.sessionManager.getActiveTrips();
        List runDataSorted = trips.values().stream().sorted(Comparator.comparingLong(o -> o.runStartTime)).collect(Collectors.toList());
        int tripIndex = 0;
        this.previousLedger = null;
        this.previousRunData = null;
        this.repeatCount = 0;
        this.consecutiveRepeatCount = 0;
        this.combinedRuntime = 0L;
        for (TripData runData : runDataSorted) {
            boolean validTrip = this.renderTrip(runData, tripIndex);
            if (!validTrip) continue;
            ++tripIndex;
        }
        for (int i = tripIndex - this.repeatCount; i < this.tripPanels.size(); ++i) {
            this.getPanelData((int)i).masterPanel.setVisible(false);
        }
        SessionStats stats = this.sessionManager.getActiveSessionStats();
        if (stats == null) {
            this.sessionNameLabel.setText(sessionNameLabelPlaceholder);
            this.gpPerHourLabel.setText(ActiveSessionPanel.htmlLabel(gpPerHourLabelPrefix, "N/A"));
            this.netTotalLabel.setText(ActiveSessionPanel.htmlLabel(netTotalLabelPrefix, "N/A"));
            this.totalGainsLabel.setText(ActiveSessionPanel.htmlLabel(totalGainsLabelPrefix, "N/A"));
            this.totalLossesLabel.setText(ActiveSessionPanel.htmlLabel(totalLossesLabelPrefix, "N/A"));
            this.sessionTimeLabel.setText(ActiveSessionPanel.htmlLabel(sessionTimeLabelPrefix, "N/A"));
            this.tripCountLabel.setText(ActiveSessionPanel.htmlLabel(tripCountLabelPrefix, "N/A"));
            this.avgTripDurationLabel.setText(ActiveSessionPanel.htmlLabel(avgTripDurationLabelPrefix, "N/A"));
            if (this.showSessionLootGrid) {
                UI.updateLootGrid(this.emptyLedger, this.sessionLootPanelData, this.itemManager, this.config);
            }
            this.updateErrorPanel(false);
        } else {
            this.sessionNameLabel.setText(sessionNameLabelPlaceholder);
            this.gpPerHourLabel.setText(ActiveSessionPanel.htmlLabel(gpPerHourLabelPrefix, UI.formatGp(UI.getGpPerHour(stats.getSessionRuntime(), stats.getNetTotal()), this.config.showExactGp()) + "/hr"));
            this.netTotalLabel.setText(ActiveSessionPanel.htmlLabel(netTotalLabelPrefix, UI.formatGp(stats.getNetTotal(), this.config.showExactGp())));
            this.totalGainsLabel.setText(ActiveSessionPanel.htmlLabel(totalGainsLabelPrefix, UI.formatGp(stats.getTotalGain(), this.config.showExactGp())));
            this.totalLossesLabel.setText(ActiveSessionPanel.htmlLabel(totalLossesLabelPrefix, UI.formatGp(stats.getTotalLoss(), this.config.showExactGp())));
            this.sessionTimeLabel.setText(ActiveSessionPanel.htmlLabel(sessionTimeLabelPrefix, UI.formatTime(stats.getSessionRuntime())));
            boolean showTripCountAndTime = stats.getTripCount() > 1;
            this.setTripCountAndDurationVisible(showTripCountAndTime);
            if (showTripCountAndTime) {
                this.tripCountLabel.setText(ActiveSessionPanel.htmlLabel(tripCountLabelPrefix, Integer.toString(stats.getTripCount())));
                this.avgTripDurationLabel.setText(ActiveSessionPanel.htmlLabel(avgTripDurationLabelPrefix, UI.formatTime(stats.getAvgTripDuration())));
            }
            if (this.showSessionLootGrid) {
                UI.updateLootGrid(UI.sortLedger(GPPerHourPlugin.getProfitLossLedger(stats.getInitialQtys(), stats.getQtys())), this.sessionLootPanelData, this.itemManager, this.config);
            }
            this.updateErrorPanel(true);
        }
        this.sessionLootPanelData.lootPanel.setVisible(this.showSessionLootGrid);
    }

    private void updateErrorPanel(boolean visible) {
        if (!visible || !this.needsCheck()) {
            this.errorLabel.setVisible(false);
            this.errorSpacing.setVisible(false);
            return;
        }
        HashSet<String> items = this.plugin.getChargeableItemsNeedingCheck();
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        for (String item : items) {
            builder.append("Check " + item + " to calibrate.<br>");
        }
        builder.append("</body></html>");
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(builder.toString());
        this.errorSpacing.setVisible(true);
    }

    private boolean needsCheck() {
        return this.plugin.getChargeableItemsNeedingCheck().size() != 0;
    }

    boolean renderTrip(TripData runData, int tripIndex) {
        long runtime;
        List<LedgerItem> ledger = GPPerHourPlugin.getProfitLossLedger(runData.initialItemQtys, runData.itemQtys);
        ledger = UI.sortLedger(ledger);
        if (!runData.isInProgress() && UI.ledgersMatch(ledger, this.previousLedger)) {
            ++this.consecutiveRepeatCount;
            ++this.repeatCount;
            TripPanelData tpData = this.getPanelData(tripIndex - this.repeatCount);
            TripStats tripStats = this.getTripStats(ledger);
            int startIndex = tripIndex - this.consecutiveRepeatCount;
            int endIndex = tripIndex;
            long runtime2 = runData.getRuntime();
            this.combinedRuntime += runtime2;
            tpData.titleLabel.setText("Trips " + (startIndex + 1) + "-" + (endIndex + 1) + " (Identical)");
            tpData.durationLabel.setText(UI.formatTime(this.combinedRuntime));
            long gpPerHour = UI.getGpPerHour(runtime2, tripStats.getNetTotal());
            gpPerHour = (long)((float)(this.previousGpPerHour * (long)this.consecutiveRepeatCount + gpPerHour) / ((float)this.consecutiveRepeatCount + 1.0f));
            tpData.topLeftLabel.setText(ActiveSessionPanel.htmlLabel(gpPerHourLabelPrefix, UI.formatGp(gpPerHour, false) + "/hr"));
            this.updateButtonMiddle(tpData, runData);
            tpData.deleteWrapper.addActionListener(event -> this.sessionManager.deleteTrip(runData.identifier));
            this.updateButtonPause(tpData, runData);
            this.previousGpPerHour = gpPerHour;
            return true;
        }
        TripPanelData tpData = this.getPanelData(tripIndex - this.repeatCount);
        TripStats tripStats = this.getTripStats(ledger);
        tpData.setContentPanelBorder(this.sessionManager.isTimeInActiveSession(runData.runStartTime) ? tripActiveBorderColor : null);
        tpData.masterPanel.setVisible(true);
        this.combinedRuntime = runtime = runData.getRuntime();
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(FontManager.getRunescapeSmallFont());
        tpData.bottomRightLabel.setText(ActiveSessionPanel.htmlLabel("Losses: ", QuantityFormatter.quantityToStackSize((long)tripStats.totalLosses)));
        long gpPerHour = UI.getGpPerHour(runtime, tripStats.getNetTotal());
        tpData.topLeftLabel.setText(ActiveSessionPanel.htmlLabel(gpPerHourLabelPrefix, UI.formatGp(gpPerHour, false) + "/hr"));
        tpData.bottomLeftLabel.setText(ActiveSessionPanel.htmlLabel(netTotalLabelPrefix, QuantityFormatter.quantityToStackSize((long)tripStats.netTotal)));
        tpData.topRightLabel.setText(ActiveSessionPanel.htmlLabel("Gains: ", QuantityFormatter.quantityToStackSize((long)tripStats.totalGains)));
        tpData.topRightLabel.setBorder(new EmptyBorder(0, 535 - fontMetrics.stringWidth(tpData.topLeftLabel.getText()), 0, 0));
        String title = "Trip " + (tripIndex + 1);
        if (runData.isInProgress()) {
            title = title + " (Active)";
        }
        tpData.titleLabel.setText(title);
        tpData.subtitleLabel.setText("Started " + UI.getTimeAgo(runData.runStartTime));
        tpData.durationLabel.setText(UI.formatTime(runtime));
        UI.clearListeners(tpData.buttonLeft);
        tpData.buttonLeft.setEnabled(!this.sessionManager.getActiveSessionStartId().equals(runData.identifier));
        tpData.buttonLeft.setText("Set Start");
        tpData.buttonLeft.setToolTipText("Set this trip as the start of the active session.");
        tpData.buttonLeft.addActionListener(event -> {
            this.sessionManager.setSessionStart(runData.identifier);
            this.updateTrips();
        });
        this.updateButtonMiddle(tpData, runData);
        this.updateButtonRight(tpData, runData);
        this.updateButtonPause(tpData, runData);
        UI.updateLootGrid(ledger, tpData.lootPanelData, this.itemManager, this.config);
        this.consecutiveRepeatCount = 0;
        this.previousLedger = ledger;
        this.previousRunData = runData;
        this.previousGpPerHour = gpPerHour;
        return true;
    }

    void updateButtonMiddle(TripPanelData tpData, TripData runData) {
        UI.clearListeners(tpData.buttonMiddle);
        tpData.buttonMiddle.setEnabled(this.sessionManager.getActiveSessionEndId() == null ? !runData.isInProgress() : !this.sessionManager.getActiveSessionEndId().equals(runData.identifier));
        if (runData.isInProgress()) {
            tpData.buttonMiddle.setText("Continue");
            tpData.buttonMiddle.setToolTipText("Include new trips in the active session.");
            tpData.buttonMiddle.addActionListener(event -> {
                this.sessionManager.setSessionEnd(null);
                this.updateTrips();
            });
        } else {
            tpData.buttonMiddle.setText("Set End");
            tpData.buttonMiddle.setToolTipText("Set this trip as the end of the active session.");
            tpData.buttonMiddle.addActionListener(event -> {
                this.sessionManager.setSessionEnd(runData.identifier);
                this.updateTrips();
            });
        }
    }

    void updateButtonRight(TripPanelData tpData, TripData runData) {
        UI.clearListeners(tpData.buttonRight);
        UI.clearListeners(tpData.deleteWrapper);
        tpData.buttonRight.setEnabled(!runData.isInProgress());
        tpData.buttonRight.setText("Delete");
        tpData.buttonRight.setToolTipText("Delete this trip.");
        tpData.buttonRight.addActionListener(event -> {
            int confirm = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete this trip?", "Warning", 2);
            if (confirm == 0) {
                this.sessionManager.deleteTrip(runData.identifier);
                for (ActionListener listener : tpData.deleteWrapper.getActionListeners()) {
                    listener.actionPerformed(event);
                }
                this.updateTrips();
            }
        });
    }

    void updateButtonPause(TripPanelData tpData, TripData runData) {
        UI.clearListeners(tpData.pauseButton);
        boolean visible = runData.isInProgress();
        CardLayout cardLayout = (CardLayout)tpData.pauseButtonCardContainer.getLayout();
        cardLayout.show(tpData.pauseButtonCardContainer, visible ? "visible" : "hidden");
        if (visible) {
            tpData.pauseButton.setSelected(runData.isPaused);
            tpData.pauseButton.addActionListener(event -> {
                runData.isPaused = tpData.pauseButton.isSelected();
                tpData.pauseButton.setSelected(runData.isPaused);
            });
        }
    }

    TripPanelData getPanelData(int index) {
        this.ensureTripPanelCount(index + 1);
        return this.tripPanels.get(this.tripPanels.size() - 1 - index);
    }

    void ensureTripPanelCount(int size) {
        while (this.tripPanels.size() < size) {
            this.constraints.gridy = this.tripPanels.size();
            TripPanelData data = this.buildTripPanel();
            this.tripsPanel.add((Component)data.masterPanel, this.constraints);
            this.tripPanels.add(data);
        }
    }

    TripStats getTripStats(List<LedgerItem> ledger) {
        long gains = 0L;
        long losses = 0L;
        for (LedgerItem item : ledger) {
            long value = item.getCombinedValue();
            if (value > 0L) {
                gains += value;
                continue;
            }
            losses += value;
        }
        long net = gains + losses;
        return new TripStats(gains, losses, net);
    }

    private TripPanelData buildTripPanel() {
        TripPanelData data = new TripPanelData();
        JToggleButton lootHeaderButtonPanel = data.lootHeaderButtonPanel;
        JToggleButton pauseButton = data.pauseButton;
        JLabel bottomLeftLabel = data.bottomLeftLabel;
        JLabel topLeftLabel = data.topLeftLabel;
        JLabel bottomRightLabel = data.bottomRightLabel;
        JLabel topRightLabel = data.topRightLabel;
        JPanel masterPanel = data.masterPanel;
        JButton buttonLeft = data.buttonLeft;
        JButton buttonMiddle = data.buttonMiddle;
        JButton buttonRight = data.buttonRight;
        JPanel contentPanel = data.contentPanel;
        JPanel lootPanel = data.lootPanelData.lootPanel;
        JPanel cardContainer = data.pauseButtonCardContainer;
        data.titleLabel.setForeground(Color.WHITE);
        data.titleLabel.setHorizontalAlignment(0);
        data.subtitleLabel.setFont(FontManager.getRunescapeSmallFont());
        data.subtitleLabel.setForeground(Color.GRAY);
        data.subtitleLabel.setHorizontalAlignment(0);
        cardContainer.setOpaque(false);
        cardContainer.add((Component)pauseButton, "visible");
        JPanel hiddenPanel = new JPanel();
        hiddenPanel.setOpaque(false);
        cardContainer.add((Component)hiddenPanel, "hidden");
        JPanel titlePanel = new JPanel();
        titlePanel.setOpaque(false);
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)data.durationLabel, "West");
        titlePanel.add((Component)data.titleLabel, "Center");
        titlePanel.add((Component)cardContainer, "East");
        JPanel headerPanel = new JPanel();
        headerPanel.setOpaque(false);
        headerPanel.setLayout(new BorderLayout(0, 5));
        headerPanel.setBorder(new EmptyBorder(10, 10, 3, 10));
        headerPanel.add((Component)titlePanel, "North");
        headerPanel.add((Component)data.subtitleLabel, "Center");
        masterPanel.setLayout(new BorderLayout());
        masterPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel bottomInfo = new JPanel();
        JPanel topInfo = new JPanel();
        lootHeaderButtonPanel.setLayout(new GridLayout(2, 0, 0, 0));
        bottomInfo.setLayout(new GridLayout(0, 2, 0, 0));
        topInfo.setLayout(new BorderLayout());
        lootHeaderButtonPanel.setPreferredSize(new Dimension(200, 35));
        lootHeaderButtonPanel.setBorder(new EmptyBorder(4, 5, 0, 5));
        pauseButton.setIcon(UI.PAUSE_ICON);
        pauseButton.setSelectedIcon(UI.PLAY_ICON);
        pauseButton.setToolTipText("Pause time tracking for this trip.");
        pauseButton.setPreferredSize(new Dimension(20, 20));
        SwingUtil.removeButtonDecorations((AbstractButton)pauseButton);
        bottomLeftLabel.setFont(FontManager.getRunescapeSmallFont());
        topLeftLabel.setFont(FontManager.getRunescapeSmallFont());
        bottomRightLabel.setFont(FontManager.getRunescapeSmallFont());
        topRightLabel.setFont(FontManager.getRunescapeSmallFont());
        SwingUtil.removeButtonDecorations((AbstractButton)lootHeaderButtonPanel);
        lootHeaderButtonPanel.setRolloverEnabled(false);
        topLeftLabel.setForeground(Color.WHITE);
        topInfo.setBorder(new EmptyBorder(0, 0, 0, 0));
        topInfo.add((Component)topLeftLabel, "West");
        topRightLabel.setBorder(new EmptyBorder(0, 48, 0, 0));
        topInfo.add((Component)topRightLabel, "Center");
        bottomInfo.add(bottomLeftLabel);
        bottomInfo.add(bottomRightLabel);
        topInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        bottomInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        lootHeaderButtonPanel.add((Component)topInfo, "North");
        lootHeaderButtonPanel.add((Component)bottomInfo, "South");
        float fontSize = 16.0f;
        EmptyBorder buttonBorder = new EmptyBorder(2, 2, 2, 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 3, 0, 0));
        buttonLeft.setBorder(buttonBorder);
        buttonLeft.setFont(buttonLeft.getFont().deriveFont(fontSize));
        buttonPanel.add(buttonLeft);
        buttonMiddle.setFont(buttonMiddle.getFont().deriveFont(fontSize));
        buttonMiddle.setBorder(buttonBorder);
        buttonPanel.add(buttonMiddle);
        buttonRight.setFont(buttonRight.getFont().deriveFont(fontSize));
        buttonPanel.add(buttonRight);
        buttonPanel.setPreferredSize(new Dimension(0, 30));
        lootPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)headerPanel, "North");
        topPanel.add((Component)lootHeaderButtonPanel, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)topPanel, "North");
        contentPanel.add((Component)lootPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        contentPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        data.setContentPanelBorder(null);
        masterPanel.add((Component)contentPanel, "North");
        return data;
    }

    static String htmlLabel(String key, String valueStr) {
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    private class TripStats {
        private final long totalGains;
        private final long totalLosses;
        private final long netTotal;

        public TripStats(long totalGains, long totalLosses, long netTotal) {
            this.totalGains = totalGains;
            this.totalLosses = totalLosses;
            this.netTotal = netTotal;
        }

        public long getTotalGains() {
            return this.totalGains;
        }

        public long getTotalLosses() {
            return this.totalLosses;
        }

        public long getNetTotal() {
            return this.netTotal;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TripStats)) {
                return false;
            }
            TripStats other = (TripStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalGains() != other.getTotalGains()) {
                return false;
            }
            if (this.getTotalLosses() != other.getTotalLosses()) {
                return false;
            }
            return this.getNetTotal() == other.getNetTotal();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TripStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $totalGains = this.getTotalGains();
            result = result * 59 + (int)($totalGains >>> 32 ^ $totalGains);
            long $totalLosses = this.getTotalLosses();
            result = result * 59 + (int)($totalLosses >>> 32 ^ $totalLosses);
            long $netTotal = this.getNetTotal();
            result = result * 59 + (int)($netTotal >>> 32 ^ $netTotal);
            return result;
        }

        public String toString() {
            return "ActiveSessionPanel.TripStats(totalGains=" + this.getTotalGains() + ", totalLosses=" + this.getTotalLosses() + ", netTotal=" + this.getNetTotal() + ")";
        }
    }

    private class TripPanelData {
        JLabel durationLabel = new JLabel("1:00:44");
        JLabel titleLabel = new JLabel("Trip X");
        JLabel subtitleLabel = new JLabel("Started X ago");
        JToggleButton pauseButton = new JToggleButton();
        JPanel pauseButtonCardContainer = new JPanel(new CardLayout());
        JToggleButton lootHeaderButtonPanel = new JToggleButton();
        JLabel topLeftLabel = new JLabel(ActiveSessionPanel.htmlLabel("Net Total: ", "N/A"));
        JLabel bottomLeftLabel = new JLabel(ActiveSessionPanel.htmlLabel("GP/hr: ", "N/A"));
        JLabel topRightLabel = new JLabel(ActiveSessionPanel.htmlLabel("Gains: ", "N/A"));
        JLabel bottomRightLabel = new JLabel(ActiveSessionPanel.htmlLabel("Losses: ", "N/A"));
        JPanel masterPanel = new JPanel();
        JButton buttonLeft = new JButton("Left");
        JButton buttonMiddle = new JButton("Middle");
        JButton buttonRight = new JButton("Right");
        JPanel contentPanel = new JPanel();
        UI.LootPanelData lootPanelData = new UI.LootPanelData();
        JButton deleteWrapper = new JButton();

        private TripPanelData() {
        }

        void setContentPanelBorder(Color color) {
            if (color == null) {
                color = borderColor;
            }
            this.contentPanel.setBorder(new MatteBorder(1, 1, 1, 1, color));
        }
    }
}

