/*
 * Decompiled with CFR 0.152.
 */
package com.code;

import com.code.JungleJapesConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Jungle Japes Indicator")
public class JungleJapesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(JungleJapesPlugin.class);
    public Clip clip;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private JungleJapesConfig config;
    @VisibleForTesting
    private boolean inToaRaid;
    private boolean invocationChanged = false;
    private static final int BANANA_GAME_OBJECT_ID = 45755;
    private static final int BANANA_SLIP_ANIMATION_ID = 4030;
    private static final int BANANA_GRAPHICS_ID = 1575;
    private static final int TOA_LOBBY_ID = 13454;
    private static final int TOA_NEXUS_ID = 14160;
    private static final int TOA_APMEKEN_ID = 15186;
    private static final int TOA_BABA_ID = 15188;
    private static int BANANA_DELAY = 0;
    private int invocationLevel = 0;
    private int invocationVarbit = 0;

    protected void startUp() {
        this.inToaRaid = false;
        this.clientThread.invokeLater(this::checkInvocation);
    }

    protected void shutDown() {
        this.inToaRaid = false;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (BANANA_DELAY > 0) {
            --BANANA_DELAY;
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (animationChanged.getActor() == null || animationChanged.getActor().getName() == null) {
            return;
        }
        if (BANANA_DELAY > 0) {
            return;
        }
        if (!this.inToaRaid) {
            return;
        }
        for (Player player : this.client.getPlayers()) {
            if (player.getAnimation() != 4030 && player.getGraphic() != 1575) continue;
            this.playSound("rallittelija");
            BANANA_DELAY = 4;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        if (BANANA_DELAY > 0) {
            return;
        }
        if (!this.inToaRaid) {
            return;
        }
        if (gameObjectSpawned.getGameObject().getId() == 45755) {
            this.playSound("stuge");
            BANANA_DELAY = 4;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitValueChanged) {
        this.invocationVarbit = this.client.getVarbitValue(14380);
        if (this.getRegion() == 13454) {
            this.resetState();
        }
        if (this.getRegion() == 14160 || this.getRegion() == 15186 || this.getRegion() == 15188) {
            this.invocationChanged = true;
        }
        this.checkInvocation();
    }

    private void checkInvocation() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.invocationChanged) {
            this.invocationLevel = this.invocationVarbit;
            this.invocationChanged = false;
        }
        if (this.invocationLevel > 0) {
            this.inToaRaid = true;
        } else {
            this.resetState();
        }
    }

    private void resetState() {
        this.invocationLevel = 0;
        this.inToaRaid = false;
    }

    private int getRegion() {
        LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint).getRegionID();
    }

    private void playSound(String audio) {
        String soundFile = "/" + audio + ".wav";
        if (this.clip != null) {
            this.clip.close();
        }
        AudioInputStream soundInputStream = null;
        try {
            InputStream input = JungleJapesPlugin.class.getResourceAsStream(soundFile);
            BufferedInputStream bufferedInput = new BufferedInputStream(input);
            soundInputStream = AudioSystem.getAudioInputStream(bufferedInput);
        }
        catch (UnsupportedAudioFileException e) {
            log.warn("The specified audio file is not supported.");
            e.printStackTrace();
        }
        catch (IOException e) {
            log.warn("Failed to load sound.");
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            log.warn("Audio file not found.");
            e.printStackTrace();
        }
        if (soundInputStream == null) {
            return;
        }
        if (!this.tryToLoadFile(soundInputStream)) {
            return;
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float volumeValue = this.config.volume() - 100;
        volume.setValue(volumeValue);
        this.clip.loop(0);
    }

    private boolean tryToLoadFile(AudioInputStream sound) {
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(sound);
            return true;
        }
        catch (IOException | LineUnavailableException e) {
            log.warn("Could not load the file: ", (Throwable)e);
            return false;
        }
    }

    @Provides
    JungleJapesConfig provideConfig(ConfigManager configManager) {
        return (JungleJapesConfig)configManager.getConfig(JungleJapesConfig.class);
    }

    public boolean isInToaRaid() {
        return this.inToaRaid;
    }
}

