/*
 * Decompiled with CFR 0.152.
 */
package com.itemdropsound;

import com.google.inject.Provides;
import com.itemdropsound.ItemDropSoundConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.TileItem;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Item Drop Sound")
public class ItemDropSoundPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemDropSoundPlugin.class);
    public static final File SOUND_FOLDER = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "item-drop-sounds");
    public static final File SOUND_FILE = new File(SOUND_FOLDER, "item_drop_sound.wav");
    @Inject
    private Client client;
    @Inject
    private ItemDropSoundConfig config;

    protected void startUp() throws Exception {
        this.initializeSoundFiles();
        log.info("Item Dropper started!");
    }

    private void initializeSoundFiles() {
        if (!SOUND_FOLDER.exists() && !SOUND_FOLDER.mkdirs()) {
            log.warn("Failed to create folder for item drop sounds");
        }
        try {
            int bytesRead;
            if (SOUND_FILE.exists()) {
                return;
            }
            InputStream stream = ItemDropSoundPlugin.class.getClassLoader().getResourceAsStream("item_drop.wav");
            OutputStream out = Files.newOutputStream(SOUND_FILE.toPath(), new OpenOption[0]);
            byte[] buffer = new byte[8192];
            while ((bytesRead = Objects.requireNonNull(stream).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.close();
            stream.close();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
        }
    }

    protected void shutDown() throws Exception {
        log.info("Item Dropper stopped!");
    }

    private List<Integer> getItemIds() {
        try {
            return Arrays.stream(this.config.itemIds().split(";")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException ex) {
            log.error("Invalid item id configuration");
            return new ArrayList<Integer>();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        List<Integer> itemIds = this.getItemIds();
        Clip clip = null;
        TileItem item = itemSpawned.getItem();
        if (itemIds.contains(item.getId())) {
            try (BufferedInputStream fileStream = new BufferedInputStream(Files.newInputStream(SOUND_FILE.toPath(), new OpenOption[0]));
                 AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);){
                clip = AudioSystem.getClip();
                clip.open(sound);
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                log.warn("Unable to load item drop alert sound", (Throwable)e);
            }
            if (clip != null) {
                clip.setFramePosition(clip.getFrameLength());
                clip.loop(1);
            }
        }
    }

    @Provides
    ItemDropSoundConfig provideConfig(ConfigManager configManager) {
        return (ItemDropSoundConfig)configManager.getConfig(ItemDropSoundConfig.class);
    }
}

