/*
 * Decompiled with CFR 0.152.
 */
package com.AerialFishing;

import com.AerialFishing.AerialFishingConfig;
import com.AerialFishing.AerialFishingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.client.game.FishingSpot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class AerialFishingSpotOverlay
extends Overlay {
    private static final int ONE_TICK_AERIAL_FISHING = 1;
    private static final int THREE_TICK_AERIAL_FISHING = 4;
    private static final int FIVE_TICK_AERIAL_FISHING = 7;
    private final AerialFishingPlugin plugin;
    private final AerialFishingConfig config;
    private final Client client;
    private final ItemManager itemManager;
    private boolean hidden;

    @Inject
    private AerialFishingSpotOverlay(AerialFishingPlugin plugin, AerialFishingConfig config, Client client, ItemManager itemManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.itemManager = itemManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.hidden) {
            return null;
        }
        Object previousSpot = null;
        Object previousLocation = null;
        for (NPC npc : this.plugin.getFishingSpots()) {
            FishingSpot spot = FishingSpot.findSpot((int)npc.getId());
            if (spot == null) continue;
            Integer distance = npc.getWorldLocation().distanceTo2D(this.client.getLocalPlayer().getWorldLocation());
            Color color = distance == 1 ? this.config.Color1T() : (distance < 4 ? this.config.Color2T() : (distance == 4 ? this.config.Color3T() : (distance < 7 ? this.config.Color4T() : (distance == 7 ? this.config.Color5T() : this.config.Color6T()))));
            Polygon poly = npc.getCanvasTilePoly();
            if (poly == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color.darker());
        }
        return null;
    }

    void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

