/*
 * Decompiled with CFR 0.152.
 */
package com.AerialFishing;

import com.AerialFishing.AerialFishingConfig;
import com.AerialFishing.AerialFishingSession;
import com.AerialFishing.AerialFishingSpotOverlay;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.FishingSpot;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Aerial Fishing Colors", description="Let's you set the highlight color of aerial fishing spots by tick length to catch", tags={"overlay", "skilling"})
@PluginDependency(value=XpTrackerPlugin.class)
@Singleton
public class AerialFishingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AerialFishingPlugin.class);
    private final AerialFishingSession session = new AerialFishingSession();
    private final List<NPC> fishingSpots = new ArrayList<NPC>();
    private FishingSpot currentSpot;
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AerialFishingConfig config;
    @Inject
    private AerialFishingSpotOverlay spotOverlay;

    @Provides
    AerialFishingConfig provideConfig(ConfigManager configManager) {
        return (AerialFishingConfig)configManager.getConfig(AerialFishingConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.spotOverlay);
    }

    protected void shutDown() throws Exception {
        this.spotOverlay.setHidden(true);
        this.overlayManager.remove((Overlay)this.spotOverlay);
        this.fishingSpots.clear();
        this.currentSpot = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.CONNECTION_LOST || gameState == GameState.LOGIN_SCREEN || gameState == GameState.HOPPING) {
            this.fishingSpots.clear();
        }
    }

    void reset() {
        this.session.setLastFishCaught(null);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        boolean showOverlays;
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY) && event.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        boolean bl = showOverlays = this.session.getLastFishCaught() != null || this.canPlayerFish(this.client.getItemContainer(InventoryID.INVENTORY)) || this.canPlayerFish(this.client.getItemContainer(InventoryID.EQUIPMENT));
        if (!showOverlays) {
            this.currentSpot = null;
        }
        this.spotOverlay.setHidden(!showOverlays);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (event.getMessage().contains("You catch a") || event.getMessage().contains("You catch some") || event.getMessage().equals("Your cormorant returns with its catch.")) {
            this.session.setLastFishCaught(Instant.now());
            this.spotOverlay.setHidden(false);
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        Actor target = event.getTarget();
        if (!(target instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)target;
        FishingSpot spot = FishingSpot.findSpot((int)npc.getId());
        if (spot == null) {
            return;
        }
        this.currentSpot = spot;
    }

    private boolean canPlayerFish(ItemContainer itemContainer) {
        if (itemContainer == null) {
            return false;
        }
        for (Item item : itemContainer.getItems()) {
            switch (item.getId()) {
                case 22816: 
                case 22817: {
                    return true;
                }
            }
        }
        return false;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.session.getLastFishCaught() != null) {
            Duration duration = Duration.between(this.session.getLastFishCaught(), Instant.now());
        }
        this.inverseSortSpotDistanceFromPlayer();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (FishingSpot.findSpot((int)npc.getId()) == null) {
            return;
        }
        this.fishingSpots.add(npc);
        this.inverseSortSpotDistanceFromPlayer();
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.fishingSpots.remove(npc);
    }

    private void inverseSortSpotDistanceFromPlayer() {
        if (this.fishingSpots.isEmpty()) {
            return;
        }
        LocalPoint cameraPoint = new LocalPoint(this.client.getCameraX(), this.client.getCameraY());
        this.fishingSpots.sort(Comparator.comparingInt(npc -> -npc.getLocalLocation().distanceTo(cameraPoint)).thenComparing(Actor::getLocalLocation, Comparator.comparingInt(LocalPoint::getX).thenComparingInt(LocalPoint::getY)).thenComparingInt(NPC::getId));
    }

    AerialFishingSession getSession() {
        return this.session;
    }

    List<NPC> getFishingSpots() {
        return this.fishingSpots;
    }

    FishingSpot getCurrentSpot() {
        return this.currentSpot;
    }
}

