/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.httpserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;

@PluginDescriptor(name="HTTP Server")
public class HttpServerPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private HttpServer server;

    protected void startUp() throws Exception {
        this.server = HttpServer.create(new InetSocketAddress(8080), 0);
        this.server.createContext("/stats", this::handleStats);
        this.server.createContext("/inv", this.handlerForInv(InventoryID.INVENTORY));
        this.server.createContext("/equip", this.handlerForInv(InventoryID.EQUIPMENT));
        this.server.setExecutor(Executors.newSingleThreadExecutor());
        this.server.start();
    }

    protected void shutDown() throws Exception {
        this.server.stop(1);
    }

    public void handleStats(HttpExchange exchange) throws IOException {
        JsonArray skills = new JsonArray();
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            JsonObject object = new JsonObject();
            object.addProperty("stat", skill.getName());
            object.addProperty("level", (Number)this.client.getRealSkillLevel(skill));
            object.addProperty("boostedLevel", (Number)this.client.getBoostedSkillLevel(skill));
            object.addProperty("xp", (Number)this.client.getSkillExperience(skill));
            skills.add((JsonElement)object);
        }
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
            RuneLiteAPI.GSON.toJson((JsonElement)skills, (Appendable)out);
        }
    }

    private HttpHandler handlerForInv(InventoryID inventoryID) {
        return exchange -> {
            Item[] items = this.invokeAndWait(() -> {
                ItemContainer itemContainer = this.client.getItemContainer(inventoryID);
                if (itemContainer != null) {
                    return itemContainer.getItems();
                }
                return null;
            });
            if (items == null) {
                exchange.sendResponseHeaders(204, 0L);
                return;
            }
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                RuneLiteAPI.GSON.toJson((Object)items, (Appendable)out);
            }
        };
    }

    private <T> T invokeAndWait(Callable<T> r) {
        try {
            AtomicReference ref = new AtomicReference();
            Semaphore semaphore = new Semaphore(0);
            this.clientThread.invokeLater(() -> {
                try {
                    ref.set(r.call());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    semaphore.release();
                }
            });
            semaphore.acquire();
            return (T)ref.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

