/*
 * Decompiled with CFR 0.152.
 */
package com.random.hopper.filters;

import com.random.hopper.USWorld;
import com.random.hopper.WorldHelper;
import com.random.hopper.filters.WorldFilter;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldRegion;

public class RegionWorldFilter
implements WorldFilter {
    private boolean allowAustralia;
    private boolean allowGermany;
    private boolean allowUK;
    private boolean allowUSAEast;
    private boolean allowUSAWest;

    public RegionWorldFilter(boolean allowAustralia, boolean allowUSAEast, boolean allowUSAWest, boolean allowGermany, boolean allowUK) {
        this.allowAustralia = allowAustralia;
        this.allowUSAEast = allowUSAEast;
        this.allowUSAWest = allowUSAWest;
        this.allowGermany = allowGermany;
        this.allowUK = allowUK;
    }

    @Override
    public boolean isWorldAccepted(World world) {
        WorldRegion region = world.getRegion();
        switch (region) {
            case AUSTRALIA: {
                return this.allowAustralia;
            }
            case GERMANY: {
                return this.allowGermany;
            }
            case UNITED_KINGDOM: {
                return this.allowUK;
            }
            case UNITED_STATES_OF_AMERICA: {
                USWorld usWorld = WorldHelper.getUSWorldSide(world.getId());
                if (usWorld == null) {
                    return false;
                }
                switch (usWorld) {
                    case EAST: {
                        return this.allowUSAEast;
                    }
                    case WEST: {
                        return this.allowUSAWest;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "RegionWorldFilter{allowAustralia=" + this.allowAustralia + ", allowGermany=" + this.allowGermany + ", allowUK=" + this.allowUK + ", allowUSAEast=" + this.allowUSAEast + ", allowUSAWest=" + this.allowUSAWest + "}";
    }
}

