/*
 * Decompiled with CFR 0.152.
 */
package com.random.hopper;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Provides;
import com.random.hopper.RandomHopperConfig;
import com.random.hopper.RandomHopperPanel;
import com.random.hopper.WorldHelper;
import com.random.hopper.filters.BlockIDWorldFilter;
import com.random.hopper.filters.ComboWorldFilter;
import com.random.hopper.filters.SkillTotalWorldFilter;
import com.random.hopper.filters.WorldFilter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WorldChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Random Hopper", description="", tags={"World Hop"})
public class RandomHopperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RandomHopperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RandomHopperConfig config;
    @Inject
    private KeyManager keyManager;
    private NavigationButton navButton;
    private RandomHopperPanel panel;
    private World targetWorld;
    private BiMap<Integer, Integer> cycleMapping;
    private LinkedList<Integer> worldQueue;
    private boolean shouldRecalculateWorldsOnTick = false;
    private final HotkeyListener randomKeyListener = new HotkeyListener(() -> this.config.randomKey()){

        public void hotkeyPressed() {
            RandomHopperPlugin.this.clientThread.invoke(() -> RandomHopperPlugin.this.doRandomHop());
        }
    };
    private final HotkeyListener previousKeyListener = new HotkeyListener(() -> this.config.previousKey()){

        public void hotkeyPressed() {
            RandomHopperPlugin.this.clientThread.invoke(() -> RandomHopperPlugin.this.hopPrevious());
        }
    };
    private final HotkeyListener nextKeyListener = new HotkeyListener(() -> this.config.nextKey()){

        public void hotkeyPressed() {
            RandomHopperPlugin.this.clientThread.invoke(() -> RandomHopperPlugin.this.hopNext());
        }
    };

    protected void startUp() {
        this.clientThread.invoke(() -> {
            WorldHelper.setWorldEnum(this.client.getEnum(4992));
            this.shouldRecalculateWorldsOnTick = true;
        });
        this.keyManager.registerKeyListener((KeyListener)this.randomKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.nextKeyListener);
        this.targetWorld = null;
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/randomhopper_icon.png");
        this.panel = new RandomHopperPanel(this);
        this.navButton = NavigationButton.builder().tooltip("Random Hopper").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.panel.updateWorldCountLabel();
        this.worldQueue = new LinkedList();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.keyManager.unregisterKeyListener((KeyListener)this.randomKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.nextKeyListener);
    }

    @Provides
    RandomHopperConfig getConfig(ConfigManager configManager) {
        return (RandomHopperConfig)configManager.getConfig(RandomHopperConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.targetWorld == null) {
            return;
        }
        if (this.shouldRecalculateWorldsOnTick) {
            this.newCycle();
            this.panel.updateAdjacentWorlds();
            this.shouldRecalculateWorldsOnTick = false;
        }
        if (this.isWorldHopperOpen()) {
            this.client.hopToWorld(this.convertToApiWorld(this.targetWorld));
            this.targetWorld = null;
        } else {
            this.client.openWorldHopper();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.worldQueue.addFirst(this.client.getWorld());
            this.panel.updateAdjacentWorlds();
        }
    }

    @Subscribe
    public void onWorldChanged(WorldChanged worldChanged) {
        this.panel.updateAdjacentWorlds();
    }

    boolean isWorldHopperOpen() {
        return this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) != null;
    }

    private void hop(World world) {
        assert (this.client.isClientThread());
        net.runelite.api.World rsWorld = this.convertToApiWorld(world);
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
        } else if (this.client.getGameState() != GameState.HOPPING) {
            this.targetWorld = world;
        }
        this.panel.updateAdjacentWorlds();
    }

    private net.runelite.api.World convertToApiWorld(World world) {
        net.runelite.api.World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        return rsWorld;
    }

    ArrayList<World> getValidWorlds(WorldFilter filter) {
        List worlds = this.worldService.getWorlds().getWorlds();
        ArrayList<World> validWorlds = new ArrayList<World>();
        for (World world : worlds) {
            EnumSet types = world.getTypes();
            if (!filter.isWorldAccepted(world)) continue;
            validWorlds.add(world);
        }
        return validWorlds;
    }

    List<World> filterWorlds(List<World> worlds, WorldFilter filter) {
        ArrayList<World> newWorlds = new ArrayList<World>();
        for (World world : worlds) {
            if (!filter.isWorldAccepted(world)) continue;
            newWorlds.add(world);
        }
        return newWorlds;
    }

    private World getRandomWorldFromCycle() {
        WorldResult worldResult = this.worldService.getWorlds();
        Random r = new Random();
        int nextWorldIndex = r.nextInt(this.cycleMapping.keySet().size());
        int i = 0;
        int nextWorldID = -1;
        Iterator iterator = this.cycleMapping.keySet().iterator();
        while (iterator.hasNext()) {
            int worldID = (Integer)iterator.next();
            if (i == nextWorldIndex) {
                nextWorldID = worldID;
                break;
            }
            ++i;
        }
        return worldResult.findWorld(nextWorldID);
    }

    void hopPrevious() {
        World nextWorld;
        if (this.cycleMapping == null) {
            return;
        }
        int currentWorld = this.client.getWorld();
        WorldResult worldResult = this.worldService.getWorlds();
        if (!this.cycleMapping.containsKey((Object)currentWorld)) {
            nextWorld = this.getRandomWorldFromCycle();
        } else {
            int nextWorldID = (Integer)this.cycleMapping.inverse().get((Object)currentWorld);
            nextWorld = worldResult.findWorld(nextWorldID);
        }
        this.clientThread.invoke(() -> this.hop(nextWorld));
    }

    void hopNext() {
        World nextWorld;
        if (this.cycleMapping == null) {
            return;
        }
        int currentWorld = this.client.getWorld();
        WorldResult worldResult = this.worldService.getWorlds();
        if (!this.cycleMapping.containsKey((Object)currentWorld)) {
            nextWorld = this.getRandomWorldFromCycle();
        } else {
            int nextWorldID = (Integer)this.cycleMapping.get((Object)currentWorld);
            nextWorld = worldResult.findWorld(nextWorldID);
        }
        this.clientThread.invoke(() -> this.hop(nextWorld));
    }

    void newCycle() {
        List<WorldFilter> panelFilters = this.panel.getFilters();
        panelFilters.add(this.getSkillTotalFilter());
        ComboWorldFilter comboFilter = new ComboWorldFilter(panelFilters);
        List allWorlds = this.worldService.getWorlds().getWorlds();
        Collections.sort(allWorlds, Comparator.comparingInt(World::getId));
        Collections.shuffle(allWorlds, new Random(this.panel.getSeed()));
        List<World> validWorlds = this.filterWorlds(allWorlds, comboFilter);
        ArrayList<Integer> validWorldIDs = new ArrayList<Integer>();
        for (World world : validWorlds) {
            validWorldIDs.add(world.getId());
        }
        if (validWorlds.size() == 0) {
            this.cycleMapping = null;
            return;
        }
        this.cycleMapping = HashBiMap.create();
        for (int i = 0; i < validWorlds.size() - 1; ++i) {
            this.cycleMapping.put((Object)((Integer)validWorldIDs.get(i)), (Object)((Integer)validWorldIDs.get(i + 1)));
        }
        this.cycleMapping.put((Object)((Integer)validWorldIDs.get(validWorldIDs.size() - 1)), (Object)((Integer)validWorldIDs.get(0)));
    }

    public int getWorldCount() {
        if (this.cycleMapping == null) {
            return 0;
        }
        return this.cycleMapping.size();
    }

    void doRandomHop() {
        List<WorldFilter> filters = this.panel.getFilters();
        filters.add(new BlockIDWorldFilter(this.client.getWorld()));
        filters.add(this.getSkillTotalFilter());
        ComboWorldFilter comboFilter = new ComboWorldFilter(filters);
        ArrayList<World> validWorlds = this.getValidWorlds(comboFilter);
        Random r = new Random();
        if (validWorlds.size() == 0) {
            return;
        }
        int chosenIndex = r.nextInt(validWorlds.size());
        World chosenWorld = validWorlds.get(chosenIndex);
        this.clientThread.invoke(() -> this.hop(chosenWorld));
    }

    WorldFilter getSkillTotalFilter() {
        return new SkillTotalWorldFilter(this.client.getTotalLevel());
    }

    public Integer[] getAdjacentWorlds() {
        int currentWorldID = this.client.getWorld();
        if (this.cycleMapping == null || !this.cycleMapping.containsKey((Object)currentWorldID)) {
            if (this.cycleMapping != null && this.cycleMapping.size() == 1) {
                int onlyWorld = (Integer)this.cycleMapping.values().iterator().next();
                return new Integer[]{onlyWorld, currentWorldID, onlyWorld};
            }
            return new Integer[]{null, currentWorldID, null};
        }
        int nextWorldID = (Integer)this.cycleMapping.get((Object)currentWorldID);
        int prevWorldID = (Integer)this.cycleMapping.inverse().get((Object)currentWorldID);
        return new Integer[]{prevWorldID, currentWorldID, nextWorldID};
    }
}

