/*
 * Decompiled with CFR 0.152.
 */
package com.random.hopper;

import com.random.hopper.RandomHopperPlugin;
import com.random.hopper.filters.RegionWorldFilter;
import com.random.hopper.filters.TrinaryWorldFilter;
import com.random.hopper.filters.TrinaryWorldFilterParameters;
import com.random.hopper.filters.WorldFilter;
import com.random.hopper.filters.WorldFilterHelpers;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;

class RandomHopperPanel
extends PluginPanel {
    private RandomHopperPlugin plugin;
    private JComboBox subscriptionDropdown;
    private JComboBox pvpDropdown;
    private JComboBox highRiskDropdown;
    private JComboBox skillTotalDropdown;
    private JComboBox bountyWorldDropdown;
    private JCheckBox usaEastBox;
    private JCheckBox usaWestBox;
    private JCheckBox ukBox;
    private JCheckBox gerBox;
    private JCheckBox ausBox;
    private JLabel worldCountLabel;
    private JRadioButton normalButton;
    private JRadioButton deadmanButton;
    private JRadioButton seasonalButton;
    private JRadioButton questButton;
    private JRadioButton freshButton;
    private JRadioButton pvpArenaButton;
    private JRadioButton betaButton;
    private JRadioButton noSaveButton;
    private JRadioButton tournamentButton;
    private JTextField seedTextField;
    private JLabel prevLabel;
    private JLabel currLabel;
    private JLabel nextLabel;
    Dimension preferredSize = new Dimension(100, 16);
    private static final TrinaryWorldFilterParameters[] comboBoxOptions = new TrinaryWorldFilterParameters[]{new TrinaryWorldFilterParameters("Always", true, false), new TrinaryWorldFilterParameters("Never", false, true), new TrinaryWorldFilterParameters("Sometimes", true, true)};
    private static final String worldCountToolTipText = "How many worlds passed through the filters.";
    private static final String randomHopToolTipText = "Hops to a random world.";
    private static final String hopPreviousToolTipText = "Hops to the previous world in the cycle, or a random world if you aren't in the cycle yet.";
    private static final String hopNextToolTipText = "Hops to the next world in the cycle, or a random world if you aren't in the cycle yet.";
    private static final String seedToolTipText = "If multiple people have the same seed and all the same configuration, \"Hop Next\" will always follow the same worlds.";
    private static final String previousWorldToolTipText = "Previous world";
    private static final String currentWorldToolTipText = "Current world";
    private static final String nextWorldToolTipText = "Next world";

    RandomHopperPanel(RandomHopperPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel panel = this.createPanel();
        this.add(panel);
    }

    private JPanel createLabel(String text) {
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 0));
        textPanel.setPreferredSize(this.preferredSize);
        textPanel.add(new JLabel(text));
        return textPanel;
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel subscriptionPanel = new JPanel(new FlowLayout(0));
        subscriptionPanel.add(this.createLabel("Subscription: "));
        this.subscriptionDropdown = new JComboBox<TrinaryWorldFilterParameters>(new TrinaryWorldFilterParameters[]{new TrinaryWorldFilterParameters("P2P", true, false), new TrinaryWorldFilterParameters("F2P", false, true), new TrinaryWorldFilterParameters("Either", true, true)});
        this.subscriptionDropdown.setSelectedIndex(0);
        subscriptionPanel.add(this.subscriptionDropdown);
        panel.add(subscriptionPanel);
        JPanel pvpPanel = new JPanel(new FlowLayout(0));
        pvpPanel.add(this.createLabel("PVP: "));
        this.pvpDropdown = new JComboBox<TrinaryWorldFilterParameters>(comboBoxOptions);
        this.pvpDropdown.setSelectedIndex(1);
        pvpPanel.add(this.pvpDropdown);
        panel.add(pvpPanel);
        JPanel highRiskPanel = new JPanel(new FlowLayout(0));
        highRiskPanel.add(this.createLabel("High Risk: "));
        this.highRiskDropdown = new JComboBox<TrinaryWorldFilterParameters>(comboBoxOptions);
        this.highRiskDropdown.setSelectedIndex(1);
        highRiskPanel.add(this.highRiskDropdown);
        panel.add(highRiskPanel);
        JPanel skillTotalPanel = new JPanel(new FlowLayout(0));
        skillTotalPanel.add(this.createLabel("Skill total: "));
        this.skillTotalDropdown = new JComboBox<TrinaryWorldFilterParameters>(comboBoxOptions);
        this.skillTotalDropdown.setSelectedIndex(2);
        skillTotalPanel.add(this.skillTotalDropdown);
        panel.add(skillTotalPanel);
        JPanel bountyWorldPanel = new JPanel(new FlowLayout(0));
        bountyWorldPanel.add(this.createLabel("Bounty World: "));
        this.bountyWorldDropdown = new JComboBox<TrinaryWorldFilterParameters>(comboBoxOptions);
        this.bountyWorldDropdown.setSelectedIndex(1);
        bountyWorldPanel.add(this.bountyWorldDropdown);
        panel.add(bountyWorldPanel);
        JPanel groupCodePanel = new JPanel(new FlowLayout(0));
        this.seedTextField = new JTextField(8);
        this.seedTextField.setToolTipText(seedToolTipText);
        groupCodePanel.add(this.createLabel("Seed: "));
        groupCodePanel.add(this.seedTextField);
        panel.add(groupCodePanel);
        JPanel regionPanel = new JPanel();
        regionPanel.setBorder(BorderFactory.createTitledBorder("Region"));
        regionPanel.setLayout(new GridLayout(0, 1));
        this.usaEastBox = new JCheckBox("U.S.A East");
        this.usaWestBox = new JCheckBox("U.S.A West");
        this.ukBox = new JCheckBox("U.K.");
        this.gerBox = new JCheckBox("Germany");
        this.ausBox = new JCheckBox("Australia");
        for (JCheckBox box : new JCheckBox[]{this.usaEastBox, this.usaWestBox, this.ukBox, this.gerBox, this.ausBox}) {
            regionPanel.add(box);
            box.setSelected(true);
        }
        panel.add(regionPanel);
        JPanel typePanel = new JPanel();
        typePanel.setBorder(BorderFactory.createTitledBorder("World Type"));
        typePanel.setLayout(new GridLayout(0, 1));
        ButtonGroup typeGroup = new ButtonGroup();
        this.normalButton = new JRadioButton("Normal");
        this.deadmanButton = new JRadioButton("Deadman");
        this.seasonalButton = new JRadioButton("Seasonal");
        this.questButton = new JRadioButton("Quest Speedrun");
        this.freshButton = new JRadioButton("Fresh Start");
        this.pvpArenaButton = new JRadioButton("PVP Arena");
        this.betaButton = new JRadioButton("Beta");
        this.noSaveButton = new JRadioButton("No Save");
        this.tournamentButton = new JRadioButton("Tournament");
        this.normalButton.setSelected(true);
        typeGroup.add(this.normalButton);
        typeGroup.add(this.deadmanButton);
        typeGroup.add(this.seasonalButton);
        typeGroup.add(this.questButton);
        typeGroup.add(this.freshButton);
        typeGroup.add(this.pvpArenaButton);
        typeGroup.add(this.betaButton);
        typeGroup.add(this.noSaveButton);
        typeGroup.add(this.tournamentButton);
        typePanel.add(this.normalButton);
        typePanel.add(this.deadmanButton);
        typePanel.add(this.seasonalButton);
        typePanel.add(this.questButton);
        typePanel.add(this.freshButton);
        typePanel.add(this.pvpArenaButton);
        typePanel.add(this.betaButton);
        typePanel.add(this.noSaveButton);
        typePanel.add(this.tournamentButton);
        panel.add(typePanel);
        JPanel wordCountPanel = new JPanel(new FlowLayout(1));
        this.worldCountLabel = new JLabel("");
        this.worldCountLabel.setToolTipText(worldCountToolTipText);
        wordCountPanel.add(this.worldCountLabel);
        panel.add(wordCountPanel);
        JPanel randomButtonWrapper = new JPanel(new FlowLayout(1));
        JButton randomButton = new JButton("Random Hop");
        randomButton.setToolTipText(randomHopToolTipText);
        randomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomHopperPanel.this.plugin.doRandomHop();
            }
        });
        randomButtonWrapper.add(randomButton);
        panel.add(randomButtonWrapper);
        JPanel prevNextPanel = new JPanel();
        Dimension buttonPreferredSize = new Dimension(110, 32);
        JButton prevButton = new JButton("Hop Previous");
        prevButton.setPreferredSize(buttonPreferredSize);
        prevButton.setToolTipText(hopPreviousToolTipText);
        JButton nextButton = new JButton("Hop Next");
        nextButton.setPreferredSize(buttonPreferredSize);
        nextButton.setToolTipText(hopNextToolTipText);
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomHopperPanel.this.plugin.hopNext();
            }
        });
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomHopperPanel.this.plugin.hopPrevious();
            }
        });
        prevNextPanel.add(prevButton);
        prevNextPanel.add(nextButton);
        panel.add(prevNextPanel);
        JPanel worldPanel = new JPanel();
        worldPanel.setLayout(new GridLayout(1, 3, 10, 0));
        this.prevLabel = new JLabel();
        this.prevLabel.setToolTipText(previousWorldToolTipText);
        this.prevLabel.setHorizontalAlignment(0);
        worldPanel.add(this.prevLabel);
        this.currLabel = new JLabel();
        this.currLabel.setToolTipText(currentWorldToolTipText);
        this.currLabel.setHorizontalAlignment(0);
        worldPanel.add(this.currLabel);
        this.nextLabel = new JLabel();
        this.nextLabel.setToolTipText(nextWorldToolTipText);
        this.nextLabel.setHorizontalAlignment(0);
        worldPanel.add(this.nextLabel);
        this.updateAdjacentWorlds();
        panel.add(worldPanel);
        ActionListener updateWorldsListener = e -> {
            this.updateWorldCountLabel();
            this.updateAdjacentWorlds();
        };
        for (JComboBox jComboBox : new JComboBox[]{this.subscriptionDropdown, this.pvpDropdown, this.highRiskDropdown, this.skillTotalDropdown, this.bountyWorldDropdown}) {
            jComboBox.addActionListener(updateWorldsListener);
        }
        for (JComponent jComponent : new JRadioButton[]{this.normalButton, this.deadmanButton, this.seasonalButton, this.questButton, this.freshButton, this.pvpArenaButton, this.betaButton, this.noSaveButton, this.tournamentButton}) {
            ((AbstractButton)jComponent).addActionListener(updateWorldsListener);
        }
        for (JComponent jComponent : new JCheckBox[]{this.gerBox, this.usaEastBox, this.usaWestBox, this.ausBox, this.ukBox}) {
            ((AbstractButton)jComponent).addActionListener(updateWorldsListener);
        }
        this.seedTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RandomHopperPanel.this.plugin.newCycle();
                RandomHopperPanel.this.updateAdjacentWorlds();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RandomHopperPanel.this.plugin.newCycle();
                RandomHopperPanel.this.updateAdjacentWorlds();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RandomHopperPanel.this.plugin.newCycle();
                RandomHopperPanel.this.updateAdjacentWorlds();
            }
        });
        return panel;
    }

    public void updateAdjacentWorlds() {
        Integer[] worlds = this.plugin.getAdjacentWorlds();
        this.prevLabel.setText(worlds[0] == null ? "?" : String.format("W%s", worlds[0]));
        this.currLabel.setText(worlds[1] == null ? "?" : String.format("W%s", worlds[1]));
        this.nextLabel.setText(worlds[2] == null ? "?" : String.format("W%s", worlds[2]));
    }

    public void updateWorldCountLabel() {
        this.plugin.newCycle();
        this.setWorldCountLabel(this.plugin.getWorldCount());
    }

    private void setWorldCountLabel(int count) {
        this.worldCountLabel.setText(String.format("%d Worlds", count));
    }

    List<WorldFilter> getFilters() {
        ArrayList<WorldFilter> filters = new ArrayList<WorldFilter>();
        filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldPayToPlay, (TrinaryWorldFilterParameters)this.subscriptionDropdown.getSelectedItem()));
        filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldPVP, (TrinaryWorldFilterParameters)this.pvpDropdown.getSelectedItem()));
        filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldHighRisk, (TrinaryWorldFilterParameters)this.highRiskDropdown.getSelectedItem()));
        filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldSkillTotal, (TrinaryWorldFilterParameters)this.skillTotalDropdown.getSelectedItem()));
        filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldBounty, (TrinaryWorldFilterParameters)this.bountyWorldDropdown.getSelectedItem()));
        filters.add(new RegionWorldFilter(this.ausBox.isSelected(), this.usaEastBox.isSelected(), this.usaWestBox.isSelected(), this.gerBox.isSelected(), this.ukBox.isSelected()));
        if (this.normalButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldNormal, new TrinaryWorldFilterParameters("normal", true, false)));
        }
        if (this.deadmanButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldDeadman, new TrinaryWorldFilterParameters("deadman", true, false)));
        }
        if (this.seasonalButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldSeasonal, new TrinaryWorldFilterParameters("seasonal", true, false)));
        }
        if (this.questButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldQuest, new TrinaryWorldFilterParameters("quest", true, false)));
        }
        if (this.freshButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldFreshStart, new TrinaryWorldFilterParameters("fresh", true, false)));
        }
        if (this.pvpArenaButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldPVPArena, new TrinaryWorldFilterParameters("pvpArena", true, false)));
        }
        if (this.betaButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldBeta, new TrinaryWorldFilterParameters("beta", true, false)));
        }
        if (this.noSaveButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldNoSave, new TrinaryWorldFilterParameters("no save", true, false)));
        }
        if (this.tournamentButton.isSelected()) {
            filters.add(new TrinaryWorldFilter(WorldFilterHelpers.isWorldTournament, new TrinaryWorldFilterParameters("tournament", true, false)));
        }
        return filters;
    }

    public int getSeed() {
        if (this.seedTextField.getText().isEmpty()) {
            return new Random().nextInt();
        }
        return this.seedTextField.getText().hashCode();
    }
}

