/*
 * Decompiled with CFR 0.152.
 */
package com.coxanalytics;

import com.coxanalytics.CoxAnalyticsPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoxPointsPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(CoxPointsPanel.class);
    private final CoxAnalyticsPlugin plugin;
    private static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private final JPanel panelContainer = new JPanel();
    private final JPanel titleContainer = new JPanel();
    private final JPanel pointsContainer = new JPanel();
    private final JLabel pointsPanelTitleLabel = new JLabel("CoX Points");
    private final JLabel teamPointsLabel = new JLabel("Team Points: 0");
    private final JLabel teamVirtualPointsHourLabel = new JLabel("Virtual Per Hour: 0");
    private final JLabel teamPointsHourLabel = new JLabel("Per Hour: 0");
    private final JLabel avgTeamPointsLabel = new JLabel("Avg. Points: 0");
    private final JLabel soloPointsLabel = new JLabel("Personal Points: 0");
    private final JLabel soloVirtualPointsHourLabel = new JLabel("Virtual Per Hour: 0");
    private final JLabel soloPointsHourLabel = new JLabel("Per Hour: 0");
    private final JLabel avgSoloPointsLabel = new JLabel("Avg. Points: 0");
    private final JLabel raidsCompletedLabel = new JLabel("Total: 0");
    private final JLabel avgTimeLabel = new JLabel("Avg. Time: 00:00.0");
    private final JLabel fastestTimeLabel = new JLabel("Fastest Time: 00:00.0");
    private final JLabel lastTimeLabel = new JLabel("Last Time: 00:00.0");
    private final JLabel timeDifLabel = new JLabel("Difference: ");
    private final JPanel splitsContainer = new JPanel();
    private final JLabel splitsPanelTitleLabel = new JLabel("CoX Splits");
    private final JLabel splitsLabel = new JLabel("");
    private final JLabel blankline = new JLabel("<html><br></html>");
    private final JLabel blankline1 = new JLabel("<html><br></html>");
    private final JButton pointsResetButton = new JButton(RESET);
    private final JButton splitsResetButton = new JButton(RESET);
    private static final ImageIcon RESET;
    private static final ImageIcon RESET_HOVER;
    private final JButton pointsClipboardButton = new JButton(CLIPBOARD);
    private final JButton splitsClipboardButton = new JButton(CLIPBOARD);
    private static final ImageIcon CLIPBOARD;
    private static final ImageIcon CLIPBOARD_HOVER;
    private final JPanel supportButtons = new JPanel();
    private final JButton discordButton = new JButton(DISCORD);
    private static final ImageIcon DISCORD;
    private static final ImageIcon DISCORD_HOVER;
    private final JButton githubButton = new JButton(GITHUB);
    private static final ImageIcon GITHUB;
    private static final ImageIcon GITHUB_HOVER;
    private final JButton folderButton = new JButton(FOLDER);
    private static final ImageIcon FOLDER;
    private static final ImageIcon FOLDER_HOVER;
    private final Color color = new Color(37, 197, 79);
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'><span style='color:white'>%s</span></body></html>";
    private static final String DIFFERENCE_TEMPLATE = "<html><body style=>Difference: <span style=%s>%s</span></body></html>";

    @Inject
    CoxPointsPanel(CoxAnalyticsPlugin plugin) {
        this.plugin = plugin;
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panelContainer.setLayout(new BoxLayout(this.panelContainer, 1));
        this.panelContainer.add(this.buildTitleContainer());
        this.panelContainer.add(this.buildSupportContainer());
        this.add(this.panelContainer, "North");
        this.add(this.tabbedPane(), "Center");
    }

    private JPanel buildTitleContainer() {
        this.titleContainer.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 8, 0), new MatteBorder(0, 0, 1, 0, this.color)));
        this.titleContainer.setLayout(new BorderLayout());
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"banner.png");
        ImageIcon i = new ImageIcon(image);
        JLabel overallIcon = new JLabel(i);
        this.titleContainer.add((Component)overallIcon, "North");
        return this.titleContainer;
    }

    private JTabbedPane tabbedPane() {
        JTabbedPane tabPanel = new JTabbedPane();
        JScrollPane pointPanel = CoxPointsPanel.wrapContainer(this.buildPointsPanel());
        JScrollPane splitPanel = CoxPointsPanel.wrapContainer(this.buildSplitsPanel());
        tabPanel.add("Points", pointPanel);
        tabPanel.add("Splits", splitPanel);
        return tabPanel;
    }

    static JScrollPane wrapContainer(JPanel container) {
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)container, "North");
        JScrollPane scroller = new JScrollPane(wrapped);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.getVerticalScrollBar().setPreferredSize(new Dimension(8, 0));
        return scroller;
    }

    private JPanel buildPointsPanel() {
        JPanel pointsInfoTitlePanel = new JPanel();
        pointsInfoTitlePanel.setLayout(new BorderLayout());
        pointsInfoTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 4, 0), new MatteBorder(0, 0, 1, 0, Color.GRAY)));
        pointsInfoTitlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel pointsInfoFirst = new JPanel();
        pointsInfoFirst.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.pointsPanelTitleLabel.setFont(FontManager.getRunescapeBoldFont());
        this.pointsPanelTitleLabel.setForeground(this.color);
        JPanel pointsInfoSecond = new JPanel(new GridLayout(1, 2, 10, 0));
        pointsInfoSecond.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.pointsClipboardButton.setRolloverIcon(CLIPBOARD_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)this.pointsClipboardButton);
        this.pointsClipboardButton.setPreferredSize(new Dimension(16, 14));
        this.pointsClipboardButton.setToolTipText("Copy to Clipboard");
        this.pointsClipboardButton.addActionListener(e -> {
            StringSelection selection = new StringSelection(this.copyPointsToClipboard());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        });
        this.pointsResetButton.setRolloverIcon(RESET_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)this.pointsResetButton);
        this.pointsResetButton.setPreferredSize(new Dimension(16, 14));
        this.pointsResetButton.setToolTipText("Reset");
        this.pointsResetButton.addActionListener(e -> this.plugin.resetPointsPanel());
        pointsInfoFirst.add(this.pointsPanelTitleLabel);
        pointsInfoSecond.add(this.pointsClipboardButton);
        pointsInfoSecond.add(this.pointsResetButton);
        pointsInfoTitlePanel.add((Component)pointsInfoFirst, "West");
        pointsInfoTitlePanel.add((Component)pointsInfoSecond, "East");
        this.pointsContainer.setLayout(new BorderLayout());
        this.pointsContainer.setBorder(new EmptyBorder(4, 10, 4, 10));
        this.pointsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel pointsInfobox = new JPanel(new GridBagLayout());
        pointsInfobox.setLayout(new GridLayout(15, 1, 0, 10));
        pointsInfobox.setBorder(new EmptyBorder(4, 0, 4, 0));
        pointsInfobox.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.teamPointsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.teamVirtualPointsHourLabel.setFont(FontManager.getRunescapeSmallFont());
        this.teamPointsHourLabel.setFont(FontManager.getRunescapeSmallFont());
        this.avgTeamPointsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.blankline.setFont(FontManager.getRunescapeSmallFont());
        this.soloPointsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.soloVirtualPointsHourLabel.setFont(FontManager.getRunescapeSmallFont());
        this.soloPointsHourLabel.setFont(FontManager.getRunescapeSmallFont());
        this.avgSoloPointsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.blankline1.setFont(FontManager.getRunescapeSmallFont());
        this.raidsCompletedLabel.setFont(FontManager.getRunescapeSmallFont());
        this.avgTimeLabel.setFont(FontManager.getRunescapeSmallFont());
        this.fastestTimeLabel.setFont(FontManager.getRunescapeSmallFont());
        this.lastTimeLabel.setFont(FontManager.getRunescapeSmallFont());
        this.timeDifLabel.setFont(FontManager.getRunescapeSmallFont());
        pointsInfobox.add(this.teamPointsLabel);
        pointsInfobox.add(this.teamVirtualPointsHourLabel);
        pointsInfobox.add(this.teamPointsHourLabel);
        pointsInfobox.add(this.avgTeamPointsLabel);
        pointsInfobox.add(this.blankline);
        pointsInfobox.add(this.soloPointsLabel);
        pointsInfobox.add(this.soloVirtualPointsHourLabel);
        pointsInfobox.add(this.soloPointsHourLabel);
        pointsInfobox.add(this.avgSoloPointsLabel);
        pointsInfobox.add(this.blankline1);
        pointsInfobox.add(this.raidsCompletedLabel);
        pointsInfobox.add(this.avgTimeLabel);
        pointsInfobox.add(this.fastestTimeLabel);
        pointsInfobox.add(this.lastTimeLabel);
        pointsInfobox.add(this.timeDifLabel);
        this.pointsContainer.add((Component)pointsInfoTitlePanel, "North");
        this.pointsContainer.add((Component)pointsInfobox, "West");
        return this.pointsContainer;
    }

    private JPanel buildSplitsPanel() {
        JPanel splitsInfoTitlePanel = new JPanel();
        splitsInfoTitlePanel.setLayout(new BorderLayout());
        splitsInfoTitlePanel.setBorder(new CompoundBorder(new EmptyBorder(4, 0, 4, 0), new MatteBorder(0, 0, 1, 0, Color.GRAY)));
        splitsInfoTitlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel splitsInfoFirst = new JPanel();
        splitsInfoFirst.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.splitsPanelTitleLabel.setFont(FontManager.getRunescapeBoldFont());
        this.splitsPanelTitleLabel.setForeground(this.color);
        JPanel splitsInfoSecond = new JPanel(new GridLayout(1, 2, 10, 0));
        splitsInfoSecond.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.splitsClipboardButton.setRolloverIcon(CLIPBOARD_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)this.splitsClipboardButton);
        this.splitsClipboardButton.setPreferredSize(new Dimension(16, 14));
        this.splitsClipboardButton.setToolTipText("Copy to Clipboard");
        this.splitsClipboardButton.addActionListener(e -> {
            StringSelection selection = new StringSelection(this.copySplitsToClipboard());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        });
        this.splitsResetButton.setRolloverIcon(RESET_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)this.splitsResetButton);
        this.splitsResetButton.setPreferredSize(new Dimension(16, 14));
        this.splitsResetButton.setToolTipText("Reset");
        this.splitsResetButton.addActionListener(e -> this.plugin.resetSplitsPanel());
        splitsInfoFirst.add(this.splitsPanelTitleLabel);
        splitsInfoSecond.add(this.splitsClipboardButton);
        splitsInfoSecond.add(this.splitsResetButton);
        splitsInfoTitlePanel.add((Component)splitsInfoFirst, "West");
        splitsInfoTitlePanel.add((Component)splitsInfoSecond, "East");
        this.splitsContainer.setLayout(new BorderLayout());
        this.splitsContainer.setBorder(new EmptyBorder(4, 10, 4, 10));
        this.splitsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel splitsInfobox = new JPanel(new GridBagLayout());
        splitsInfobox.setLayout(new GridLayout(1, 1, 0, 10));
        splitsInfobox.setBorder(new EmptyBorder(4, 0, 4, 0));
        splitsInfobox.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.splitsLabel.setFont(FontManager.getRunescapeSmallFont());
        splitsInfobox.add(this.splitsLabel);
        this.splitsContainer.add((Component)splitsInfoTitlePanel, "North");
        this.splitsContainer.add((Component)splitsInfobox, "West");
        return this.splitsContainer;
    }

    private JPanel buildSupportContainer() {
        this.supportButtons.setLayout(new BorderLayout());
        this.supportButtons.setBorder(new EmptyBorder(4, 5, 0, 10));
        JPanel supportInfobox = new JPanel(new GridBagLayout());
        supportInfobox.setLayout(new GridLayout(1, 2, 3, 0));
        supportInfobox.setBorder(new EmptyBorder(5, 5, 5, 5));
        supportInfobox.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.folderButton.setRolloverIcon(FOLDER_HOVER);
        this.folderButton.setToolTipText("Open Times Folder");
        this.folderButton.setPreferredSize(new Dimension(24, 24));
        this.discordButton.setRolloverIcon(DISCORD_HOVER);
        this.discordButton.setToolTipText("Discord");
        this.discordButton.setPreferredSize(new Dimension(23, 25));
        this.githubButton.setRolloverIcon(GITHUB_HOVER);
        this.githubButton.setToolTipText("Github");
        this.githubButton.setPreferredSize(new Dimension(20, 23));
        SwingUtil.removeButtonDecorations((AbstractButton)this.folderButton);
        SwingUtil.removeButtonDecorations((AbstractButton)this.githubButton);
        SwingUtil.removeButtonDecorations((AbstractButton)this.discordButton);
        this.folderButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(CoxAnalyticsPlugin.getTIMES_DIR());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.githubButton.addActionListener(e -> LinkBrowser.browse((String)"https://github.com/MoreBuchus/buchus-plugins"));
        this.discordButton.addActionListener(e -> LinkBrowser.browse((String)"https://discord.gg/mfw63tG9js"));
        supportInfobox.add(this.folderButton);
        supportInfobox.add(this.githubButton);
        supportInfobox.add(this.discordButton);
        this.supportButtons.add((Component)supportInfobox, "Center");
        return this.supportButtons;
    }

    private String copyPointsToClipboard() {
        String timeDifString = Text.removeTags((String)this.timeDifLabel.getText());
        return this.teamPointsLabel.getText() + "\r\n" + this.teamVirtualPointsHourLabel.getText() + "\r\n" + this.teamPointsHourLabel.getText() + "\r\n" + this.avgTeamPointsLabel.getText() + "\r\n" + this.soloPointsLabel.getText() + "\r\n" + this.soloVirtualPointsHourLabel.getText() + "\r\n" + this.soloPointsHourLabel.getText() + "\r\n" + this.avgSoloPointsLabel.getText() + "\r\n" + this.raidsCompletedLabel.getText() + "\r\n" + this.avgTimeLabel.getText() + "\r\n" + this.fastestTimeLabel.getText() + "\r\n" + this.lastTimeLabel.getText() + "\r\n" + timeDifString;
    }

    private String copySplitsToClipboard() {
        return this.plugin.getSplits().replace("<br>", "\r\n");
    }

    void setTeamPoints(int points) {
        this.teamPointsLabel.setText(CoxPointsPanel.toPoints("Team Points: ", points));
    }

    void setTeamVirtualPointsHour(int points, int ticks) {
        this.teamVirtualPointsHourLabel.setText(CoxPointsPanel.toPointsPerHour("Virtual Per Hour: ", points, ticks));
    }

    void setTeamPointsHour(int points, int ticks) {
        this.teamPointsHourLabel.setText(CoxPointsPanel.toPointsPerHour("Per Hour: ", points, ticks));
    }

    void setAvgTeamPoints(int points, int kc) {
        this.avgTeamPointsLabel.setText(CoxPointsPanel.toAvgPoints(points, kc));
    }

    void setSoloPoints(int points) {
        this.soloPointsLabel.setText(CoxPointsPanel.toPoints("Personal Points: ", points));
    }

    void setSoloVirtualPointsHour(int points, int ticks) {
        this.soloVirtualPointsHourLabel.setText(CoxPointsPanel.toPointsPerHour("Virtual Per Hour: ", points, ticks));
    }

    void setSoloPointsHour(int points, int ticks) {
        this.soloPointsHourLabel.setText(CoxPointsPanel.toPointsPerHour("Per Hour: ", points, ticks));
    }

    void setAvgSoloPoints(int points, int kc) {
        this.avgSoloPointsLabel.setText(CoxPointsPanel.toAvgPoints(points, kc));
    }

    void setCompletions(int regKC, int cmKC) {
        this.raidsCompletedLabel.setText(CoxPointsPanel.toCompletions(regKC, cmKC));
    }

    void setAvgTime(String time) {
        this.avgTimeLabel.setText("Avg. Time: " + time);
    }

    void setFastestTime(String time) {
        this.fastestTimeLabel.setText("Fastest Time: " + time);
    }

    void setLastTime(String time) {
        this.lastTimeLabel.setText("Last Time: " + time);
    }

    void setTimeDif(int difference) {
        String hexColor = "";
        Object time = "";
        if (difference > 0) {
            hexColor = "'color:#25c54f'";
            time = "-" + this.plugin.raidTime(difference);
        } else if (difference < 0) {
            hexColor = "'color:#e03c31'";
            time = "+" + this.plugin.raidTime(difference - difference * 2);
        }
        String timeDif = String.format(DIFFERENCE_TEMPLATE, hexColor, time);
        this.timeDifLabel.setText(timeDif);
    }

    void setSplits(String splits) {
        this.splitsLabel.setText(CoxPointsPanel.toSplits(splits));
    }

    private static String toCompletions(int regKC, int cmKC) {
        return regKC + cmKC == 0 ? "Total: 0" : "Total: " + (regKC + cmKC) + "   |   CoX: " + regKC + "   |   CM: " + cmKC;
    }

    private static String toSplits(String splits) {
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), splits);
    }

    private static String toPoints(String key, int value) {
        String points = POINTS_FORMAT.format(value);
        return key + points;
    }

    private static String toPointsPerHour(String key, int points, int ticks) {
        String pph = ticks == 0 ? "0" : POINTS_FORMAT.format((float)(points / ticks) * 6000.0f);
        return key + pph;
    }

    private static String toAvgPoints(int points, int kc) {
        String avgPts = kc == 0 ? "0" : POINTS_FORMAT.format((double)(points / kc));
        return "Avg. Points: " + avgPts;
    }

    static {
        BufferedImage resetImg = ImageUtil.loadImageResource(CoxAnalyticsPlugin.class, (String)"reset_icon.png");
        RESET = new ImageIcon(resetImg);
        RESET_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)resetImg, (int)-80));
        BufferedImage clipboardImg = ImageUtil.loadImageResource(CoxAnalyticsPlugin.class, (String)"clipboard.png");
        CLIPBOARD = new ImageIcon(clipboardImg);
        CLIPBOARD_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)clipboardImg, (int)-80));
        BufferedImage discordImg = ImageUtil.loadImageResource(CoxAnalyticsPlugin.class, (String)"discord_icon.png");
        DISCORD = new ImageIcon(discordImg);
        DISCORD_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)discordImg, (int)-80));
        BufferedImage githubImg = ImageUtil.loadImageResource(CoxAnalyticsPlugin.class, (String)"github_icon.png");
        GITHUB = new ImageIcon(githubImg);
        GITHUB_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)githubImg, (int)-80));
        BufferedImage folderImg = ImageUtil.loadImageResource(CoxAnalyticsPlugin.class, (String)"folder.png");
        FOLDER = new ImageIcon(folderImg);
        FOLDER_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)folderImg, (int)-80));
    }
}

