/*
 * Decompiled with CFR 0.152.
 */
package com.coxanalytics;

import com.coxanalytics.CoxAnalyticsConfig;
import com.coxanalytics.CoxAnalyticsOverlay;
import com.coxanalytics.CoxPointsPanel;
import com.coxanalytics.config.TimeStyle;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CoX Analytics", description="Additional information for CoX sessions.", tags={"cox", "floor", "splits", "olm", "time", "analytics", "session", "raid"})
public class CoxAnalyticsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoxAnalyticsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CoxAnalyticsConfig config;
    @Inject
    private CoxAnalyticsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private PluginManager pluginManager;
    private CoxPointsPanel pointsPanel;
    private NavigationButton button;
    private static final int COX_TIME_VAR = 6386;
    private static final int COX_POINT_WIDGET_SCRIPT = 1510;
    private static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private static final String RAID_START_MESSAGE = "The raid has begun!";
    private static final String KC_MESSAGE = "Your completed Chambers of Xeric count is:";
    private static final String KC_MESSAGE_CM = "Your completed Chambers of Xeric Challenge Mode count is:";
    private static final String RAID_COMPLETE_MESSAGE = "Congratulations - your raid is complete!";
    private static final String COMBAT_ROOM_COMPLETE_MESSAGE = "Combat room ";
    private static final String PUZZLE_ROOM_COMPLETE_MESSAGE = "Puzzle ";
    private boolean inCox;
    private int regKC = 0;
    private int cmKC = 0;
    private int fastestTicks = -1;
    private int splitTicks = 0;
    private String splits = "";
    private int totalTeamPoints = 0;
    private int totalSoloPoints = 0;
    private int totalEndTicks = 0;
    private int realEndTicks = 0;
    private boolean realTicksFlag = false;
    private int upperTicks = -1;
    private int middleTicks = -1;
    private int lowerTicks = -1;
    private int olmStart = -1;
    private int endTicks = -1;
    private String upperFloorTime = "";
    private String middleFloorTime = "";
    private String lowerFloorTime = "";
    private String olmTime = "";
    public int olmPhase = 0;
    public int mageStart = -1;
    private static final File TIMES_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "cox-analytics");

    @Provides
    CoxAnalyticsConfig provideConfig(ConfigManager configManager) {
        return (CoxAnalyticsConfig)configManager.getConfig(CoxAnalyticsConfig.class);
    }

    protected void startUp() throws Exception {
        this.buildPanel();
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.hideWidget(this.config.replaceWidget()));
        if (!TIMES_DIR.exists()) {
            TIMES_DIR.mkdirs();
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.button);
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.hideWidget(false));
        this.reset();
        this.resetTimes();
    }

    public void reset() {
        this.inCox = false;
        this.upperTicks = -1;
        this.middleTicks = -1;
        this.lowerTicks = -1;
        this.endTicks = -1;
        this.upperFloorTime = "";
        this.middleFloorTime = "";
        this.lowerFloorTime = "";
        this.olmTime = "";
        this.olmPhase = 0;
        this.splitTicks = 0;
        this.mageStart = -1;
    }

    public void resetTimes() {
        this.upperTicks = -1;
        this.middleTicks = -1;
        this.lowerTicks = -1;
        this.endTicks = -1;
        this.upperFloorTime = "";
        this.middleFloorTime = "";
        this.lowerFloorTime = "";
        this.olmTime = "";
        this.splits = "";
        this.splitTicks = 0;
        this.mageStart = -1;
    }

    private void buildPanel() {
        this.clientToolbar.removeNavigation(this.button);
        this.pointsPanel = (CoxPointsPanel)((Object)this.injector.getInstance(CoxPointsPanel.class));
        this.pointsPanel.init();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"cox.png");
        this.button = NavigationButton.builder().tooltip("CoX Analytics").icon(icon).priority(this.config.panelPriority()).panel((PluginPanel)this.pointsPanel).build();
        if (this.config.ptsPanel()) {
            this.clientToolbar.addNavigation(this.button);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("CoxAnalytics")) {
            if (e.getKey().equals("ptsPanel")) {
                if (this.config.ptsPanel()) {
                    this.clientToolbar.addNavigation(this.button);
                    this.pointsPanel.revalidate();
                } else if (!this.config.ptsPanel()) {
                    this.clientToolbar.removeNavigation(this.button);
                }
            } else if (e.getKey().equals("panelPriority")) {
                this.buildPanel();
            } else if (e.getKey().equals("replaceWidget")) {
                this.hideWidget(this.config.replaceWidget());
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        if (this.inCox && this.client.getVarbitValue(5432) != 1) {
            this.reset();
        } else {
            this.inCox = this.client.getVarbitValue(5432) == 1;
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && !this.inCox) {
            this.reset();
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && this.realTicksFlag) {
            ++this.realEndTicks;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) throws Exception {
        if (this.inCox) {
            String msg = Text.removeTags((String)e.getMessage());
            if (e.getType() == ChatMessageType.GAMEMESSAGE) {
                if (msg.startsWith(KC_MESSAGE) || msg.startsWith(KC_MESSAGE_CM)) {
                    String trimKcMsg = msg.substring(msg.indexOf(":")).replace(".", "");
                    if (msg.startsWith(KC_MESSAGE)) {
                        ++this.regKC;
                        this.splits = this.splits + "CoX KC" + trimKcMsg;
                        this.pointsPanel.setSplits(this.splits);
                        if (this.config.exportTimes()) {
                            this.exportTimes(false);
                        }
                    } else if (msg.startsWith(KC_MESSAGE_CM)) {
                        ++this.cmKC;
                        this.splits = this.splits + "CoX CM KC" + trimKcMsg;
                        this.pointsPanel.setSplits(this.splits);
                        if (this.config.exportTimes()) {
                            this.exportTimes(true);
                        }
                    }
                    this.updatePanel();
                }
            } else if (e.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
                if (msg.startsWith(COMBAT_ROOM_COMPLETE_MESSAGE) || msg.startsWith(PUZZLE_ROOM_COMPLETE_MESSAGE)) {
                    String room = msg.split("`")[1];
                    int roomTicks = this.coxTimeVar() - this.splitTicks;
                    if (this.splitTicks != this.coxTimeVar()) {
                        this.splitTicks = this.coxTimeVar();
                    }
                    this.splits = this.splits + room + ": " + this.raidTime(roomTicks) + "<br>";
                    this.pointsPanel.setSplits(this.splits);
                } else if (msg.contains("Olm phase") || msg.contains("Olm head")) {
                    this.splits = msg.contains("Total") ? this.splits + msg.substring(0, msg.indexOf("Total")).replace(" duration", "").trim() + "<br>" : this.splits + msg.replace(" duration", "").trim() + "<br>";
                    this.pointsPanel.setSplits(this.splits);
                } else if (msg.contains("level complete! Duration: ")) {
                    if (msg.contains("Upper")) {
                        this.upperTicks = this.coxTimeVar();
                        this.getFloorTimes();
                        this.splits = this.splits + "Floor 1: " + this.upperFloorTime + "<br>";
                    } else if (msg.contains("Middle")) {
                        this.middleTicks = this.coxTimeVar();
                        this.getFloorTimes();
                        this.splits = this.splits + "Floor 2: " + this.middleFloorTime + "<br>";
                    } else if (msg.contains("Lower")) {
                        this.lowerTicks = this.coxTimeVar();
                        this.olmStart = this.coxTimeVar();
                        this.getFloorTimes();
                        this.splits = this.splits + (this.middleTicks != -1 ? "Floor 3: " + this.lowerFloorTime + "<br>" : "Floor 2: " + this.lowerFloorTime + "<br>");
                    }
                    if (this.splitTicks != this.coxTimeVar()) {
                        this.splitTicks = this.coxTimeVar();
                    }
                    this.pointsPanel.setSplits(this.splits);
                } else if (msg.startsWith(RAID_START_MESSAGE)) {
                    this.resetTimes();
                    if (!this.realTicksFlag) {
                        this.realTicksFlag = true;
                    }
                } else if (msg.startsWith(RAID_COMPLETE_MESSAGE)) {
                    int totalPoints = this.client.getVarbitValue(5431);
                    int personalPoints = this.client.getVarbitValue(5422);
                    int scale = this.client.getVarbitValue(5424);
                    this.endTicks = this.coxTimeVar();
                    this.getFloorTimes();
                    this.splits = this.splits + "Olm: " + this.olmTime + "<br>Raid Completed: " + this.raidTime(this.endTicks) + " | Team Size: " + scale + "<br>";
                    this.pointsPanel.setSplits(this.splits);
                    this.totalEndTicks += this.endTicks;
                    this.totalTeamPoints += totalPoints;
                    this.totalSoloPoints += personalPoints;
                    if (this.config.ptsHr()) {
                        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Solo pts/hr: ").append(ChatColorType.HIGHLIGHT).append(this.getPointsPerHour(personalPoints)).append(ChatColorType.NORMAL).append(", Team pts/hr: ").append(ChatColorType.HIGHLIGHT).append(this.getPointsPerHour(totalPoints)).build();
                        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
                    }
                }
            }
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath e) {
        NPC npc;
        Optional<Plugin> deoTimers = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("CoX Timers")).findFirst();
        if (deoTimers.isPresent() && this.pluginManager.isPluginEnabled(deoTimers.get()) && this.config.showOlmMageHand() && e.getActor() instanceof NPC && ((npc = (NPC)e.getActor()).getId() == 7550 || npc.getId() == 7553) && this.olmPhase + 1 < this.getOlmPhases() && this.mageStart != -1) {
            ++this.olmPhase;
            String chatMessage = "Olm mage hand phase " + this.olmPhase + " duration: <col=ff0000>" + this.raidTime(this.coxTimeVar() - this.mageStart);
            this.client.addChatMessage(ChatMessageType.FRIENDSCHATNOTIFICATION, "", chatMessage, null);
            this.splits = this.splits + "Olm mage hand phase " + this.olmPhase + ": " + this.raidTime(this.coxTimeVar() - this.mageStart) + "<br>";
            this.pointsPanel.setSplits(this.splits);
            this.mageStart = -1;
        }
    }

    private int getOlmPhases() {
        int scale = this.client.getVarbitValue(5424);
        return 3 + scale / 8;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (e.getGameObject().getId() == 29881) {
            this.mageStart = this.coxTimeVar();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.coxTimeVar() > 0 && this.client.getVarbitValue(5425) < 5) {
            this.client.runScript(new Object[]{2289, 0, 0, 0});
            Widget widget = this.client.getWidget(WidgetInfo.RAIDS_POINTS_INFOBOX);
            Point mousePosition = this.client.getMouseCanvasPosition();
            if (widget != null && !widget.isHidden() && widget.getBounds().contains(mousePosition.getX(), mousePosition.getY()) && this.config.splitsTooltip() && this.upperTicks != -1) {
                this.tooltipManager.add(new Tooltip(this.getFloorTimes()));
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        Widget widget;
        if (event.getScriptId() == 1510 && this.inCox && (widget = this.client.getWidget(WidgetInfo.RAIDS_POINTS_INFOBOX)) != null && !widget.isHidden()) {
            widget.setHidden(this.config.replaceWidget());
        }
    }

    private void hideWidget(boolean hidden) {
        Widget widget;
        if (this.client.getGameState() == GameState.LOGGED_IN && this.inCox && (widget = this.client.getWidget(WidgetInfo.RAIDS_POINTS_INFOBOX)) != null) {
            widget.setHidden(hidden);
        }
    }

    public String getFloorTimes() {
        Object time = "";
        if (this.upperTicks != -1) {
            this.upperFloorTime = this.raidTime(this.upperTicks);
            time = (String)time + "Floor 1: " + this.upperFloorTime;
            if (this.middleTicks == -1) {
                if (this.lowerTicks != -1) {
                    this.lowerFloorTime = this.raidTime(this.lowerTicks - this.upperTicks);
                    time = (String)time + "</br>Floor 2: " + this.lowerFloorTime;
                }
            } else {
                this.middleFloorTime = this.raidTime(this.middleTicks - this.upperTicks);
                time = (String)time + "</br>Floor 2: " + this.middleFloorTime;
                if (this.lowerTicks != -1) {
                    this.lowerFloorTime = this.raidTime(this.lowerTicks - this.middleTicks);
                    time = (String)time + "</br>Floor 3: " + this.lowerFloorTime;
                }
            }
            if (this.endTicks != -1) {
                this.olmTime = this.raidTime(this.endTicks - this.olmStart);
                time = (String)time + "</br>Olm: " + this.olmTime;
            }
        }
        return time;
    }

    public int coxTimeVar() {
        return this.client.getVarbitValue(6386);
    }

    public String raidTime(int ticks) {
        boolean ingame_setting;
        TimeStyle setting = this.config.timerStyle();
        boolean bl = ingame_setting = this.client.getVarbitValue(11866) == 1;
        if (setting == TimeStyle.TICKS || setting == TimeStyle.VARBIT && ingame_setting) {
            return CoxAnalyticsPlugin.to_mmss_precise(ticks);
        }
        return CoxAnalyticsPlugin.to_mmss(ticks);
    }

    public static String to_mmss(int ticks) {
        int m;
        int s = (ticks - (m = ticks / 100) * 100) * 6 / 10;
        return m + (s < 10 ? ":0" : ":") + s;
    }

    public static String to_mmss_precise(int ticks) {
        int min = ticks / 100;
        int tmp = (ticks - min * 100) * 6;
        int sec = tmp / 10;
        int sec_tenth = tmp - sec * 10;
        return min + (sec < 10 ? ":0" : ":") + sec + "." + sec_tenth;
    }

    public String getPointsPerHour(int points) {
        return POINTS_FORMAT.format((float)(points / this.endTicks) * 6000.0f);
    }

    private void updatePanel() {
        int totalKC = this.regKC + this.cmKC;
        if (this.endTicks != -1) {
            this.pointsPanel.setTeamPoints(this.totalTeamPoints);
            this.pointsPanel.setTeamVirtualPointsHour(this.totalTeamPoints, this.totalEndTicks);
            this.pointsPanel.setTeamPointsHour(this.totalTeamPoints, this.realEndTicks);
            this.pointsPanel.setAvgTeamPoints(this.totalTeamPoints, totalKC);
            this.pointsPanel.setSoloPoints(this.totalSoloPoints);
            this.pointsPanel.setSoloVirtualPointsHour(this.totalSoloPoints, this.totalEndTicks);
            this.pointsPanel.setSoloPointsHour(this.totalSoloPoints, this.realEndTicks);
            this.pointsPanel.setAvgSoloPoints(this.totalSoloPoints, totalKC);
            this.pointsPanel.setCompletions(this.regKC, this.cmKC);
            this.pointsPanel.setAvgTime(this.raidTime(this.totalEndTicks / totalKC));
            this.pointsPanel.setLastTime(this.raidTime(this.endTicks));
            this.pointsPanel.setTimeDif(this.fastestTicks != -1 ? this.fastestTicks - this.endTicks : 0);
        }
        if (this.fastestTicks == -1 || this.endTicks < this.fastestTicks) {
            this.fastestTicks = this.endTicks;
            this.pointsPanel.setFastestTime(this.raidTime(this.fastestTicks));
        }
    }

    public void resetPointsPanel() {
        this.regKC = 0;
        this.cmKC = 0;
        this.totalTeamPoints = 0;
        this.totalSoloPoints = 0;
        this.totalEndTicks = 0;
        this.fastestTicks = -1;
        this.realTicksFlag = false;
        this.realEndTicks = 0;
        this.pointsPanel.setTeamPoints(this.totalTeamPoints);
        this.pointsPanel.setTeamVirtualPointsHour(this.totalTeamPoints, this.totalEndTicks);
        this.pointsPanel.setTeamPointsHour(this.totalTeamPoints, this.realEndTicks);
        this.pointsPanel.setAvgTeamPoints(this.totalTeamPoints, this.regKC + this.cmKC);
        this.pointsPanel.setSoloPoints(this.totalSoloPoints);
        this.pointsPanel.setSoloVirtualPointsHour(this.totalSoloPoints, this.totalEndTicks);
        this.pointsPanel.setSoloPointsHour(this.totalSoloPoints, this.realEndTicks);
        this.pointsPanel.setAvgSoloPoints(this.totalSoloPoints, this.regKC + this.cmKC);
        this.pointsPanel.setCompletions(this.regKC, this.cmKC);
        this.pointsPanel.setFastestTime("00:00.0");
        this.pointsPanel.setLastTime("00:00.0");
        this.pointsPanel.setTimeDif(0);
    }

    public void resetSplitsPanel() {
        this.splits = "";
        this.pointsPanel.setSplits(this.splits);
    }

    private void exportTimes(boolean cm) throws Exception {
        Object fileName = "";
        fileName = cm ? TIMES_DIR + "\\" + this.client.getLocalPlayer().getName() + "_CmTimes.txt" : TIMES_DIR + "\\" + this.client.getLocalPlayer().getName() + "_CoxTimes.txt";
        FileWriter writer = new FileWriter((String)fileName, true);
        try {
            writer.write(this.splits.replace("<br>", "\r\n") + "\r\n------------------------------------------------------------------------------------------------\r\n------------------------------------------------------------------------------------------------\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writer.close();
    }

    public boolean isInCox() {
        return this.inCox;
    }

    public int getRegKC() {
        return this.regKC;
    }

    public int getCmKC() {
        return this.cmKC;
    }

    public int getFastestTicks() {
        return this.fastestTicks;
    }

    public int getSplitTicks() {
        return this.splitTicks;
    }

    public String getSplits() {
        return this.splits;
    }

    public int getTotalTeamPoints() {
        return this.totalTeamPoints;
    }

    public int getTotalSoloPoints() {
        return this.totalSoloPoints;
    }

    public int getTotalEndTicks() {
        return this.totalEndTicks;
    }

    public int getRealEndTicks() {
        return this.realEndTicks;
    }

    public boolean isRealTicksFlag() {
        return this.realTicksFlag;
    }

    public int getUpperTicks() {
        return this.upperTicks;
    }

    public int getMiddleTicks() {
        return this.middleTicks;
    }

    public int getLowerTicks() {
        return this.lowerTicks;
    }

    public int getOlmStart() {
        return this.olmStart;
    }

    public int getEndTicks() {
        return this.endTicks;
    }

    public String getUpperFloorTime() {
        return this.upperFloorTime;
    }

    public String getMiddleFloorTime() {
        return this.middleFloorTime;
    }

    public String getLowerFloorTime() {
        return this.lowerFloorTime;
    }

    public String getOlmTime() {
        return this.olmTime;
    }

    public static File getTIMES_DIR() {
        return TIMES_DIR;
    }
}

