/*
 * Decompiled with CFR 0.152.
 */
package com.coxanalytics;

import com.coxanalytics.CoxAnalyticsConfig;
import com.coxanalytics.CoxAnalyticsPlugin;
import com.coxanalytics.config.CustomOverlayInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class CoxAnalyticsOverlay
extends OverlayPanel {
    private static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private final Client client;
    private final CoxAnalyticsPlugin plugin;
    private final CoxAnalyticsConfig config;
    private final TooltipManager tooltipManager;

    @Inject
    private CoxAnalyticsOverlay(Client client, CoxAnalyticsPlugin plugin, CoxAnalyticsConfig config, TooltipManager tooltipManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isInCox() && this.config.replaceWidget()) {
            Point mousePosition;
            Rectangle bounds;
            int totalPoints = this.client.getVarbitValue(5431);
            int personalPoints = this.client.getVarbitValue(5422);
            switch (this.config.fontType()) {
                case SMALL: {
                    graphics.setFont(FontManager.getRunescapeSmallFont());
                    break;
                }
                case REGULAR: {
                    graphics.setFont(FontManager.getRunescapeFont());
                    break;
                }
                case BOLD: {
                    graphics.setFont(FontManager.getRunescapeBoldFont());
                    break;
                }
                case CUSTOM: {
                    if (this.config.fontName().equals("")) break;
                    graphics.setFont(new Font(this.config.fontName(), this.config.fontWeight().getWeight(), this.config.fontSize()));
                }
            }
            if (!this.config.overlayInfo().isEmpty()) {
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.TOTAL)) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Total:").right(POINTS_FORMAT.format(totalPoints)).build());
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.PERSONAL)) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left(this.client.getLocalPlayer().getName() + ":").right(POINTS_FORMAT.format(personalPoints)).build());
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.ELAPSED)) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").rightColor(!this.plugin.getOlmTime().equals("") ? Color.GREEN : Color.WHITE).right(this.plugin.raidTime(this.plugin.coxTimeVar())).build());
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.FLOOR)) {
                    if (this.plugin.getUpperTicks() != -1) {
                        this.panelComponent.getChildren().add(LineComponent.builder().left("Floor 1: ").right(this.plugin.getUpperFloorTime()).build());
                    }
                    if (this.plugin.getMiddleTicks() != -1) {
                        this.panelComponent.getChildren().add(LineComponent.builder().left("Floor 2: ").right(this.plugin.getMiddleFloorTime()).build());
                    }
                    if (this.plugin.getLowerTicks() != -1) {
                        if (this.plugin.getMiddleTicks() != -1) {
                            this.panelComponent.getChildren().add(LineComponent.builder().left("Floor 3: ").right(this.plugin.getLowerFloorTime()).build());
                        } else {
                            this.panelComponent.getChildren().add(LineComponent.builder().left("Floor 2: ").right(this.plugin.getLowerFloorTime()).build());
                        }
                    }
                    if (!this.plugin.getOlmTime().equals("")) {
                        this.panelComponent.getChildren().add(LineComponent.builder().left("Olm: ").right(this.plugin.getOlmTime()).build());
                    }
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.CURRENT) && this.plugin.getOlmTime().equals("")) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Current Split:").rightColor(Color.WHITE).right(this.plugin.raidTime(this.plugin.coxTimeVar() - this.plugin.getSplitTicks())).build());
                }
            }
            if ((bounds = this.getBounds()).getX() > 0.0 && bounds.contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY()) && this.config.splitsTooltip() && this.plugin.getUpperTicks() != -1) {
                this.tooltipManager.add(new Tooltip(this.plugin.getFloorTimes()));
            }
        }
        switch (this.config.backgroundStyle()) {
            case HIDE: {
                this.panelComponent.setBackgroundColor(null);
                break;
            }
            case STANDARD: {
                this.panelComponent.setBackgroundColor(ComponentConstants.STANDARD_BACKGROUND_COLOR);
                break;
            }
            case CUSTOM: {
                this.panelComponent.setBackgroundColor(this.config.backgroundColor());
            }
        }
        return super.render(graphics);
    }
}

