/*
 * Decompiled with CFR 0.152.
 */
package com.spritemarkers;

import com.spritemarkers.SpriteMarker;
import com.spritemarkers.SpriteMarkersConfig;
import com.spritemarkers.SpriteMarkersPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TileHighlighterOverlay
extends Overlay {
    private final Client client;
    private final SpriteMarkersPlugin plugin;
    private final SpriteMarkersConfig config;
    private static final int MAX_TILES = 32;

    @Inject
    public TileHighlighterOverlay(Client client, SpriteMarkersConfig config, SpriteMarkersPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.MED);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showSprites() || !this.config.highlightSprites()) {
            return null;
        }
        ArrayList<SpriteMarker> spriteMarkers = this.plugin.getSpriteMarkersLoaded();
        if (spriteMarkers.isEmpty()) {
            return null;
        }
        for (SpriteMarker spriteMarker : spriteMarkers) {
            WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
            if (playerLoc.distanceTo(spriteMarker.getWorldPoint()) > 32) continue;
            WorldPoint worldLoc = spriteMarker.getWorldPoint();
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldLoc);
            if (localPoint == null) {
                return null;
            }
            Polygon tilePolygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
            if (tilePolygon == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)tilePolygon, (Color)Color.WHITE);
        }
        return null;
    }
}

