/*
 * Decompiled with CFR 0.152.
 */
package com.spritemarkers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import com.spritemarkers.ImportExportTool;
import com.spritemarkers.MinimapSpriteOverlay;
import com.spritemarkers.SpriteMarker;
import com.spritemarkers.SpriteMarkerID;
import com.spritemarkers.SpriteMarkersConfig;
import com.spritemarkers.SpriteMarkersOverlay;
import com.spritemarkers.TileHighlighterOverlay;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Sprite Markers", description="Mark tiles with sprites", tags={"overlay", "tiles"})
public class SpriteMarkersPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private SpriteMarkersConfig config;
    @Inject
    private SpriteMarkersOverlay overlay;
    @Inject
    private TileHighlighterOverlay highlighterOverlay;
    @Inject
    private MinimapSpriteOverlay minimapSpriteOverlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ImportExportTool importExportTool;
    @Inject
    private Gson gson;
    private static final int LEFT_CONTROL_KEYCODE = 82;
    private static final String ADD_SPRITE = "Add Sprite";
    private static final String REMOVE_SPRITE = "Remove Sprite";
    private static final String CANCEL = "Cancel";
    protected static final String CONFIG_GROUP = "spriteMarkers";
    protected static final String REGION = "Region_";
    private final ArrayList<SpriteMarker> spriteMarkersLoaded = new ArrayList();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.highlighterOverlay);
        this.overlayManager.add((Overlay)this.minimapSpriteOverlay);
        this.importExportTool.addOptions();
        this.loadSprites();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.highlighterOverlay);
        this.overlayManager.remove((Overlay)this.minimapSpriteOverlay);
        this.importExportTool.removeOptions();
        this.spriteMarkersLoaded.clear();
    }

    private boolean containsSprite(ArrayList<SpriteMarkerID> spriteMarkerIDS, SpriteMarkerID targetSpriteMarker) {
        for (SpriteMarkerID spriteMarkerID : spriteMarkerIDS) {
            if (!spriteMarkerID.equals(targetSpriteMarker)) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryEvent) {
        Tile targetTile;
        boolean markerKeyPressed = this.client.isKeyPressed(82);
        if (markerKeyPressed && menuEntryEvent.getOption().equals(CANCEL) && (targetTile = this.client.getSelectedSceneTile()) != null) {
            LocalPoint localPoint = targetTile.getLocalLocation();
            WorldPoint worldLoc = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
            int regionID = worldLoc.getRegionID();
            SpriteMarkerID targetSpriteMarkerID = new SpriteMarkerID(regionID, worldLoc.getRegionX(), worldLoc.getRegionY(), this.client.getPlane(), this.config.spriteID(), this.config.scale());
            ArrayList<SpriteMarkerID> savedSprites = this.jsonToSprite(regionID);
            boolean spriteHere = this.containsSprite(savedSprites, targetSpriteMarkerID);
            if (!spriteHere) {
                this.client.createMenuEntry(-1).setOption(ADD_SPRITE).setTarget(menuEntryEvent.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.addTileSprite());
            } else {
                this.client.createMenuEntry(-1).setOption(REMOVE_SPRITE).setTarget(menuEntryEvent.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.removeTileSprite());
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadSprites();
        }
    }

    private void addTileSprite() {
        Tile targetTile = this.client.getSelectedSceneTile();
        if (targetTile != null) {
            LocalPoint localPoint = targetTile.getLocalLocation();
            WorldPoint worldLoc = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
            int regionID = worldLoc.getRegionID();
            SpriteMarkerID spriteMarkerID = new SpriteMarkerID(regionID, worldLoc.getRegionX(), worldLoc.getRegionY(), this.client.getPlane(), this.config.spriteID(), this.config.scale());
            this.saveSprite(regionID, spriteMarkerID);
            this.loadSprites();
        }
    }

    private void removeTileSprite() {
        Tile tile = this.client.getSelectedSceneTile();
        if (tile == null) {
            return;
        }
        LocalPoint localPoint = tile.getLocalLocation();
        WorldPoint targetLocation = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        int regionID = targetLocation.getRegionID();
        SpriteMarkerID TargetSpriteMarkerID = new SpriteMarkerID(regionID, targetLocation.getRegionX(), targetLocation.getRegionY(), this.client.getPlane(), this.config.spriteID(), this.config.scale());
        ArrayList<SpriteMarkerID> currSprites = this.jsonToSprite(regionID);
        for (SpriteMarkerID spriteMarkerID : currSprites) {
            if (!spriteMarkerID.equals(TargetSpriteMarkerID)) continue;
            currSprites.remove(spriteMarkerID);
            break;
        }
        if (!currSprites.isEmpty()) {
            String spriteMarkersToJson = this.gson.toJson(currSprites);
            this.configManager.setConfiguration(CONFIG_GROUP, REGION + regionID, spriteMarkersToJson);
        } else {
            this.configManager.unsetConfiguration(CONFIG_GROUP, REGION + regionID);
        }
        this.loadSprites();
    }

    void saveSprite(int regionId, SpriteMarkerID newSprite) {
        ArrayList<SpriteMarkerID> currPoints = this.jsonToSprite(regionId);
        currPoints.add(newSprite);
        String spriteMarkersToJson = this.gson.toJson(currPoints);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION + regionId, spriteMarkersToJson);
    }

    void saveSprite(int regionId, ArrayList<SpriteMarkerID> newSprites) {
        ArrayList<SpriteMarkerID> currPoints = this.jsonToSprite(regionId);
        currPoints.addAll(newSprites);
        String spriteMarkersToJson = this.gson.toJson(currPoints);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION + regionId, spriteMarkersToJson);
    }

    void loadSprites() {
        this.spriteMarkersLoaded.clear();
        int[] loadedRegions = this.client.getMapRegions();
        if (loadedRegions != null) {
            for (int loadedRegion : loadedRegions) {
                ArrayList<SpriteMarkerID> regionSprites = this.jsonToSprite(loadedRegion);
                ArrayList<SpriteMarker> spriteMarkers = this.getSpriteMarkers(regionSprites);
                this.spriteMarkersLoaded.addAll(spriteMarkers);
            }
        }
    }

    ArrayList<SpriteMarkerID> jsonToSprite(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION + regionId);
        if (json != null && !json.equals("")) {
            return (ArrayList)this.gson.fromJson(json, new TypeToken<ArrayList<SpriteMarkerID>>(){}.getType());
        }
        return new ArrayList<SpriteMarkerID>();
    }

    private ArrayList<SpriteMarker> getSpriteMarkers(ArrayList<SpriteMarkerID> regionSprites) {
        if (regionSprites.isEmpty()) {
            return new ArrayList<SpriteMarker>();
        }
        ArrayList<SpriteMarker> spriteMarkers = new ArrayList<SpriteMarker>();
        for (SpriteMarkerID spriteMarkerID : regionSprites) {
            WorldPoint worldLoc = WorldPoint.fromRegion((int)spriteMarkerID.getRegionId(), (int)spriteMarkerID.getRegionX(), (int)spriteMarkerID.getRegionY(), (int)spriteMarkerID.getPlane());
            SpriteMarker spriteMarker = new SpriteMarker(spriteMarkerID.getSpriteId(), spriteMarkerID.getScale(), worldLoc);
            spriteMarkers.add(spriteMarker);
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)spriteMarker.getWorldPoint());
            for (WorldPoint worldPoint : localWorldPoints) {
                spriteMarkers.add(new SpriteMarker(spriteMarkerID.getSpriteId(), spriteMarkerID.getScale(), worldPoint));
            }
        }
        return spriteMarkers;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals(CONFIG_GROUP) && configChanged.getKey().equals("show import")) {
            if (this.config.showImport()) {
                this.importExportTool.addOptions();
            } else {
                this.importExportTool.removeOptions();
            }
        }
    }

    @Provides
    SpriteMarkersConfig provideConfig(ConfigManager configManager) {
        return (SpriteMarkersConfig)configManager.getConfig(SpriteMarkersConfig.class);
    }

    public ArrayList<SpriteMarker> getSpriteMarkersLoaded() {
        return this.spriteMarkersLoaded;
    }
}

