/*
 * Decompiled with CFR 0.152.
 */
package com.spritemarkers;

import com.spritemarkers.SpriteMarker;
import com.spritemarkers.SpriteMarkersConfig;
import com.spritemarkers.SpriteMarkersPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class SpriteMarkersOverlay
extends Overlay {
    private final Client client;
    private final SpriteMarkersPlugin plugin;
    private final SpriteMarkersConfig config;
    private static final int MAX_TILES = 32;
    @Inject
    SpriteManager spriteManager;
    @Inject
    private ConfigManager configManager;

    @Inject
    public SpriteMarkersOverlay(Client client, SpriteMarkersConfig config, SpriteMarkersPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showSprites()) {
            return null;
        }
        ArrayList<SpriteMarker> spriteMarkers = this.plugin.getSpriteMarkersLoaded();
        if (spriteMarkers.isEmpty()) {
            return null;
        }
        for (SpriteMarker spriteMarker : spriteMarkers) {
            BufferedImage toImage = this.spriteManager.getSprite(1, 0);
            try {
                toImage = this.spriteManager.getSprite(spriteMarker.getSpriteId(), 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
            if (toImage == null || spriteMarker.worldPoint.distanceTo(playerLoc) > 32) continue;
            WorldPoint worldLoc = spriteMarker.getWorldPoint();
            LocalPoint locPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldLoc);
            if (locPoint == null) {
                return null;
            }
            toImage = ImageUtil.resizeImage((BufferedImage)toImage, (int)(toImage.getWidth() * spriteMarker.getScale() / 100), (int)(toImage.getHeight() * spriteMarker.getScale() / 100));
            OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)locPoint, (BufferedImage)toImage, (int)0);
        }
        if (this.config.clear().equals("clear")) {
            for (SpriteMarker spriteMarker : spriteMarkers) {
                if (this.configManager.getConfiguration("spriteMarkers", "Region_" + spriteMarker.getWorldPoint().getRegionID()) == null) continue;
                this.configManager.unsetConfiguration("spriteMarkers", "Region_" + spriteMarker.getWorldPoint().getRegionID());
            }
            this.plugin.getSpriteMarkersLoaded().clear();
        }
        return null;
    }
}

