/*
 * Decompiled with CFR 0.152.
 */
package com.spritemarkers;

import com.spritemarkers.SpriteMarker;
import com.spritemarkers.SpriteMarkersConfig;
import com.spritemarkers.SpriteMarkersPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class MinimapSpriteOverlay
extends Overlay {
    private final Client client;
    private final SpriteMarkersPlugin plugin;
    private final SpriteMarkersConfig config;
    private static final int MINIMAP_RADIUS = 16;
    private static final int BIG_SPRITE = 250;
    @Inject
    SpriteManager spriteManager;

    @Inject
    public MinimapSpriteOverlay(Client client, SpriteMarkersConfig config, SpriteMarkersPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showSprites() || !this.config.showOnMap()) {
            return null;
        }
        ArrayList<SpriteMarker> spriteMarkers = this.plugin.getSpriteMarkersLoaded();
        if (spriteMarkers.isEmpty()) {
            return null;
        }
        for (SpriteMarker spriteMarker : spriteMarkers) {
            this.drawMinimapSprite(graphics, spriteMarker);
        }
        return null;
    }

    private void drawMinimapSprite(Graphics2D graphics, SpriteMarker spriteMarker) {
        WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
        if (playerLoc != null && playerLoc.distanceTo(spriteMarker.getWorldPoint()) <= 16) {
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)spriteMarker.worldPoint);
            if (localPoint == null) {
                return;
            }
            Point miniMapPoint = Perspective.localToMinimap((Client)this.client, (LocalPoint)localPoint);
            if (miniMapPoint == null) {
                return;
            }
            BufferedImage toImage = this.spriteManager.getSprite(1, 0);
            try {
                toImage = this.spriteManager.getSprite(spriteMarker.getSpriteId(), 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (toImage != null) {
                int scaleFactor = Math.min(toImage.getHeight(), toImage.getWidth()) / this.config.largeMapSpriteSize();
                if (Math.max(toImage.getHeight(), toImage.getWidth()) < 250) {
                    scaleFactor = Math.min(toImage.getHeight(), toImage.getWidth()) / this.config.smallMapSpriteSize();
                }
                scaleFactor = Math.max(scaleFactor, 1);
                toImage = ImageUtil.resizeImage((BufferedImage)toImage, (int)(toImage.getWidth() / scaleFactor), (int)(toImage.getHeight() / scaleFactor));
                Point offsetPoint = new Point(miniMapPoint.getX() - toImage.getWidth() / 2, miniMapPoint.getY() - toImage.getHeight() / 2);
                OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)offsetPoint, (BufferedImage)toImage);
            }
        }
    }
}

