/*
 * Decompiled with CFR 0.152.
 */
package com.spritemarkers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.spritemarkers.SpriteMarker;
import com.spritemarkers.SpriteMarkerID;
import com.spritemarkers.SpriteMarkersPlugin;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;

public class ImportExportTool {
    private static final WidgetMenuOption EXPORT_SPRITE_MARKERS = new WidgetMenuOption("Export", "Sprite Markers", WidgetInfo.MINIMAP_TOGGLE_RUN_ORB);
    private static final WidgetMenuOption IMPORT_SPRITE_MARKERS = new WidgetMenuOption("Import", "Sprite Markers", WidgetInfo.MINIMAP_TOGGLE_RUN_ORB);
    private final SpriteMarkersPlugin spriteMarkersPlugin;
    private final Client client;
    private final MenuManager menuManager;
    private final ChatMessageManager chatMessageManager;
    private final Gson gson;

    @Inject
    private ImportExportTool(SpriteMarkersPlugin plugin, Client client, ChatMessageManager chatMessageManager, MenuManager menuManager, Gson gson) {
        this.spriteMarkersPlugin = plugin;
        this.client = client;
        this.menuManager = menuManager;
        this.chatMessageManager = chatMessageManager;
        this.gson = gson;
    }

    void addOptions() {
        this.menuManager.addManagedCustomMenu(EXPORT_SPRITE_MARKERS, this::exportSpriteMarkers);
        this.menuManager.addManagedCustomMenu(IMPORT_SPRITE_MARKERS, this::importSpriteMarkers);
    }

    void removeOptions() {
        this.menuManager.removeManagedCustomMenu(EXPORT_SPRITE_MARKERS);
        this.menuManager.removeManagedCustomMenu(IMPORT_SPRITE_MARKERS);
    }

    private void exportSpriteMarkers(MenuEntry menuEntry) {
        ArrayList<SpriteMarker> spriteMarkersLoaded = this.spriteMarkersPlugin.getSpriteMarkersLoaded();
        if (spriteMarkersLoaded.isEmpty()) {
            this.addChatMessage("There are no loaded sprite markers to export");
            return;
        }
        int[] loadedRegions = this.client.getMapRegions();
        if (loadedRegions == null || loadedRegions.length == 0) {
            return;
        }
        ArrayList<SpriteMarkerID> spriteIDSToSave = new ArrayList<SpriteMarkerID>();
        for (int region : loadedRegions) {
            spriteIDSToSave.addAll(this.spriteMarkersPlugin.jsonToSprite(region));
        }
        String markersJSONString = this.gson.toJson(spriteIDSToSave);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(markersJSONString), null);
        this.addChatMessage("Copied loaded sprite markers to clipboard");
    }

    private void importSpriteMarkers(MenuEntry menuEntry) {
        String text;
        try {
            text = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException e) {
            this.addChatMessage("Clipboard error - could not import sprite markers");
            return;
        }
        if (text.isEmpty() || text == null) {
            this.addChatMessage("Empty clipboard - could not import sprite markers");
            return;
        }
        ArrayList spriteMarkerIDS = new ArrayList();
        try {
            spriteMarkerIDS = (ArrayList)this.gson.fromJson(text, new TypeToken<ArrayList<SpriteMarkerID>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            this.addChatMessage("No Sprites in clipboard/Wrong formatting - could not import sprite markers");
            return;
        }
        if (spriteMarkerIDS == null || spriteMarkerIDS.isEmpty()) {
            this.addChatMessage("No Sprite Markers in clipboard");
            return;
        }
        this.addToConfig(spriteMarkerIDS);
    }

    private void addToConfig(ArrayList<SpriteMarkerID> spriteMarkerIDS) {
        HashMap<Integer, ArrayList<SpriteMarkerID>> IDToMarkers = new HashMap<Integer, ArrayList<SpriteMarkerID>>();
        for (SpriteMarkerID spriteMarkerID : spriteMarkerIDS) {
            int currRegion = spriteMarkerID.getRegionId();
            if (IDToMarkers.containsKey(currRegion)) {
                ((ArrayList)IDToMarkers.get(currRegion)).add(spriteMarkerID);
                continue;
            }
            IDToMarkers.put(currRegion, new ArrayList<SpriteMarkerID>(Collections.singletonList(spriteMarkerID)));
        }
        Iterator<SpriteMarkerID> iterator = IDToMarkers.keySet().iterator();
        while (iterator.hasNext()) {
            int regionId = (Integer)((Object)iterator.next());
            this.spriteMarkersPlugin.saveSprite(regionId, (ArrayList)IDToMarkers.get(regionId));
        }
        this.spriteMarkersPlugin.loadSprites();
        this.addChatMessage("Sprite Markers imported");
    }

    private void addChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

