/*
 * Decompiled with CFR 0.152.
 */
package bbp.essencepouchhealth;

import bbp.essencepouchhealth.EssencePouchHealthOverlay;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Essence Pouch Health", description="Shows how much essence you can put into your pouches before it degrades.", tags={"rc", "runecraft", "runecrafting", "pouch", "rune", "essence", "degrade"})
public class EssencePouchHealthPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EssencePouchHealthPlugin.class);
    private static final int SMALL_POUCH = 5509;
    private static final int MEDIUM_POUCH = 5510;
    private static final int LARGE_POUCH = 5512;
    private static final int GIANT_POUCH = 5514;
    private static final int COLOSSAL_POUCH = 26784;
    private static final int MEDIUM_POUCH_USES = 264;
    private static final int LARGE_POUCH_USES = 279;
    private static final int GIANT_POUCH_USES = 120;
    private static final int COLOSSAL_POUCH_USES = 320;
    private static final List<Integer> healthyPouchList = List.of(Integer.valueOf(5510), Integer.valueOf(5512), Integer.valueOf(5514), Integer.valueOf(26784));
    private static final List<Integer> degradedPouchList = List.of(Integer.valueOf(5511), Integer.valueOf(5513), Integer.valueOf(5515), Integer.valueOf(26786));
    private static final List<Integer> essenceList = List.of(Integer.valueOf(24704), Integer.valueOf(7936), Integer.valueOf(1436), Integer.valueOf(26879));
    private Map<Integer, Integer> itemUses = new HashMap<Integer, Integer>(){
        {
            this.put(5509, 0);
            this.put(5510, 0);
            this.put(5512, 0);
            this.put(5514, 0);
            this.put(26784, 0);
        }
    };
    private final Map<Integer, Integer> maxItemUses = new HashMap<Integer, Integer>(){
        {
            this.put(5509, -1);
            this.put(5510, 264);
            this.put(5512, 279);
            this.put(5514, 120);
            this.put(26784, 320);
        }
    };
    private final Map<Integer, Integer> pouchSize = new HashMap<Integer, Integer>(){
        {
            this.put(5509, 3);
            this.put(5510, 6);
            this.put(5512, 9);
            this.put(5514, 12);
            this.put(26784, 40);
        }
    };
    public ArrayList<Integer> filledPouches = new ArrayList();
    private Multiset<Integer> previousInventorySnapshot;
    private int lastClickedItem = -1;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private EssencePouchHealthOverlay rcOverlay;
    @Inject
    private ItemManager itemManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.rcOverlay);
        this.previousInventorySnapshot = this.getInventorySnapshot();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.rcOverlay);
    }

    private Multiset<Integer> getInventorySnapshot() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        HashMultiset inventorySnapshot = HashMultiset.create();
        if (inventory != null) {
            Arrays.stream(inventory.getItems()).forEach(arg_0 -> EssencePouchHealthPlugin.lambda$getInventorySnapshot$0((Multiset)inventorySnapshot, arg_0));
        }
        return inventorySnapshot;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.previousInventorySnapshot == null) {
            return;
        }
        if (this.lastClickedItem == -1) {
            return;
        }
        Multiset<Integer> currentInventorySnapshot = this.getInventorySnapshot();
        Multiset itemsRemoved = Multisets.difference(this.previousInventorySnapshot, currentInventorySnapshot);
        if (itemsRemoved.isEmpty()) {
            log.info("Did not actually fill anything...");
            return;
        }
        int removedEssenceCount = (int)itemsRemoved.stream().filter(essenceList::contains).count();
        for (int pouchID : this.filledPouches) {
            this.itemUses.put(pouchID, this.itemUses.get(pouchID) + Math.min(removedEssenceCount, this.pouchSize.get(pouchID)));
            if (removedEssenceCount <= this.pouchSize.get(pouchID)) break;
            removedEssenceCount -= this.pouchSize.get(pouchID).intValue();
        }
        this.filledPouches.clear();
        Stream<Integer> degradedPouchesRemoved = itemsRemoved.stream().filter(degradedPouchList::contains);
        if (degradedPouchesRemoved.findAny().isPresent()) {
            Multiset itemsAdded = Multisets.difference(currentInventorySnapshot, this.previousInventorySnapshot);
            if ((int)itemsAdded.stream().filter(healthyPouchList::contains).count() > 0) {
                this.itemUses.put(5510, 0);
                this.itemUses.put(5512, 0);
                this.itemUses.put(5514, 0);
                this.itemUses.put(26784, 0);
            }
        }
        this.lastClickedItem = -1;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.lastClickedItem = -1;
        if (event.getMenuOption() == null || !event.getMenuOption().equals("Fill")) {
            return;
        }
        int inventoryIndex = event.getParam0();
        ItemContainer inventoryContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventoryContainer == null) {
            return;
        }
        Item item = inventoryContainer.getItem(inventoryIndex);
        if (item == null) {
            return;
        }
        int itemId = item.getId();
        String itemName = item.toString();
        if (!this.filledPouches.contains(itemId)) {
            this.filledPouches.add(itemId);
        }
        log.info("Filled pouches: {}", this.filledPouches);
        if (!this.itemUses.containsKey(itemId)) {
            log.info("Filled an item that we don't know about: {} with ID: {}", (Object)itemName, (Object)itemId);
            return;
        }
        this.previousInventorySnapshot = this.getInventorySnapshot();
        this.lastClickedItem = itemId;
    }

    public Map<Integer, Integer> getItemUses() {
        return this.itemUses;
    }

    public Map<Integer, Integer> getMaxItemUses() {
        return this.maxItemUses;
    }

    private static /* synthetic */ void lambda$getInventorySnapshot$0(Multiset inventorySnapshot, Item item) {
        inventorySnapshot.add((Object)item.getId(), item.getQuantity());
    }
}

