/*
 * Decompiled with CFR 0.152.
 */
package com.shopcalculator.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.runelite.client.ui.PluginPanel;

public class ShopCalculatorPanel
extends PluginPanel {
    private final NumberFormat numberFormat;
    private final JTextField itemValueField;
    private final JTextField shopIncreaseField;
    private final JTextField totalTransactionsField;
    private final JTextField itemsPerHopField;
    private final JLabel avgCostPerItemLabel;
    private final JLabel hopsNeededLabel;
    private final JLabel totalCostPerHopLabel;
    private final JLabel totalCostLabel;

    public ShopCalculatorPanel() {
        this.setLayout(new GridBagLayout());
        this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
        this.itemValueField = new JTextField(10);
        this.itemValueField.setText("0");
        this.shopIncreaseField = new JTextField(10);
        this.shopIncreaseField.setText("1");
        this.totalTransactionsField = new JTextField(10);
        this.totalTransactionsField.setText("0");
        this.itemsPerHopField = new JTextField(10);
        this.itemsPerHopField.setText("10");
        ((AbstractDocument)this.itemValueField.getDocument()).setDocumentFilter(new IntegerOnlyFilter());
        ((AbstractDocument)this.shopIncreaseField.getDocument()).setDocumentFilter(new IntegerOnlyFilter());
        ((AbstractDocument)this.totalTransactionsField.getDocument()).setDocumentFilter(new IntegerOnlyFilter());
        ((AbstractDocument)this.itemsPerHopField.getDocument()).setDocumentFilter(new IntegerOnlyFilter());
        this.avgCostPerItemLabel = new JLabel();
        this.hopsNeededLabel = new JLabel();
        this.totalCostPerHopLabel = new JLabel();
        this.totalCostLabel = new JLabel();
        JButton calculateButton = new JButton("Calculate");
        calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopCalculatorPanel.this.calculateResults();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.addComponent(new JLabel("Item value"), 0, 0, gbc);
        this.addComponent(new JLabel("Change per (%)"), 0, 1, gbc);
        this.addComponent(new JLabel("Total to buy/sell"), 2, 0, gbc);
        this.addComponent(new JLabel("Items per Hop"), 2, 1, gbc);
        this.addComponent(new JLabel("Average/item"), 9, 0, gbc);
        this.addComponent(new JLabel("Hops needed"), 11, 0, gbc);
        this.addComponent(new JLabel("Total/hop"), 13, 0, gbc);
        this.addComponent(new JLabel("Total"), 15, 0, gbc);
        gbc.anchor = 10;
        gbc.fill = 2;
        this.addComponent(this.itemValueField, 1, 0, gbc);
        this.addComponent(this.shopIncreaseField, 1, 1, gbc);
        this.addComponent(this.totalTransactionsField, 3, 0, gbc);
        this.addComponent(this.itemsPerHopField, 3, 1, gbc);
        this.addComponent(this.avgCostPerItemLabel, 9, 1, gbc);
        this.addComponent(this.hopsNeededLabel, 11, 1, gbc);
        this.addComponent(this.totalCostPerHopLabel, 13, 1, gbc);
        this.addComponent(this.totalCostLabel, 15, 1, gbc);
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.addComponent(calculateButton, 7, 0, gbc);
        this.addComponent(new JSeparator(), 8, 0, gbc);
        this.addComponent(new JSeparator(), 10, 0, gbc);
        this.addComponent(new JSeparator(), 12, 0, gbc);
        this.addComponent(new JSeparator(), 14, 0, gbc);
        this.addComponent(new JSeparator(), 16, 0, gbc);
    }

    private void addComponent(Component component, int gridY, int gridX, GridBagConstraints gbc) {
        gbc.gridy = gridY;
        gbc.gridx = gridX;
        this.add(component, gbc);
    }

    private void calculateResults() {
        int item_value = this.parseIntegerOrDefault(this.itemValueField.getText());
        double shop_increase = this.parseDoubleOrDefault(this.shopIncreaseField.getText()) * 0.01;
        int total_transactions = this.parseIntegerOrDefault(this.totalTransactionsField.getText());
        int items_per_hop = this.parseIntegerOrDefault(this.itemsPerHopField.getText());
        double total_cost_per_hop = 0.0;
        for (int i = 0; i < items_per_hop; ++i) {
            total_cost_per_hop += Math.floor((double)item_value + (double)(i * item_value) * shop_increase);
        }
        this.avgCostPerItemLabel.setText(this.formatNumber(total_cost_per_hop / (double)items_per_hop) + " gp");
        this.hopsNeededLabel.setText(String.valueOf(this.formatNumber((double)total_transactions / (double)items_per_hop)));
        this.totalCostPerHopLabel.setText(this.formatNumber(total_cost_per_hop) + " gp");
        this.totalCostLabel.setText(this.formatNumber((double)total_transactions / (double)items_per_hop * total_cost_per_hop) + " gp");
    }

    private String formatNumber(double number) {
        return this.numberFormat.format(number);
    }

    private double parseDoubleOrDefault(String text) {
        if (text.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private int parseIntegerOrDefault(String text) {
        if (text.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static class IntegerOnlyFilter
    extends DocumentFilter {
        private IntegerOnlyFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            StringBuilder sb = new StringBuilder(string);
            for (int i = sb.length() - 1; i >= 0; --i) {
                char c = sb.charAt(i);
                if (Character.isDigit(c)) continue;
                sb.deleteCharAt(i);
            }
            super.insertString(fb, offset, sb.toString(), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text == null) {
                return;
            }
            StringBuilder sb = new StringBuilder(text);
            for (int i = sb.length() - 1; i >= 0; --i) {
                char c = sb.charAt(i);
                if (Character.isDigit(c)) continue;
                sb.deleteCharAt(i);
            }
            super.replace(fb, offset, length, sb.toString(), attrs);
        }
    }
}

