/*
 * Decompiled with CFR 0.152.
 */
package com.zalcano;

import com.google.inject.Provides;
import com.zalcano.ZalcanoConfig;
import com.zalcano.ZalcanoOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.ScriptEvent;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(configName="ZalcanoUtility", name="ZalcanoUtility")
public class ZalcanoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZalcanoPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ZalcanoConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ZalcanoOverlay zalcanoOverlay;
    private Widget hpBar;
    private int hpBarWidgetId = 19857428;
    private boolean hpBarHidden = true;
    private int zalcanoState;
    private int throwingHp;
    private int miningHp;
    private List<Player> playersInSight;
    private List<Player> playersParticipating = new ArrayList<Player>();
    private final List<WorldPoint> excludedWorldPoints = new ArrayList<WorldPoint>();
    private static final int ZALCANO_REGION = 12126;
    private int shieldDamageDealt;
    private final int minimumDamageLootShield = 30;
    private final int minimumDamageUniquesShield = 50;
    private int miningDamageDealt;
    private final int minimumDamageLootMining = 30;
    private final int minimumDamageUniquesMining = 50;
    private float chanceOfToolSeedTable = 0.0f;

    protected void startUp() throws Exception {
        log.info("Zalcano plugin started");
        this.overlayManager.add((Overlay)this.zalcanoOverlay);
        this.addExcludedWorldPoints();
        this.playersParticipating = new ArrayList<Player>();
        this.playersInSight = new ArrayList<Player>(this.client.getPlayers());
        while (this.playersInSight.remove(null)) {
        }
        this.shieldDamageDealt = 0;
        this.miningDamageDealt = 0;
        this.zalcanoState = 9049;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.zalcanoOverlay);
        log.info("Zalcano plugin stopped");
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        Widget widget;
        ScriptEvent event = scriptPreFired.getScriptEvent();
        if (event != null && (widget = event.getSource()) != null && widget.getId() == this.hpBarWidgetId) {
            this.hpBarHidden = widget.isHidden();
            if (!this.hpBarHidden) {
                this.hpBar = widget;
            }
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        this.playersParticipating.remove(playerDespawned.getPlayer());
        this.playersInSight.remove(playerDespawned.getPlayer());
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        this.playersInSight.add(playerSpawned.getPlayer());
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.filterPlayersAtGate(this.playersInSight);
        this.updateZalcanoStatus();
        this.updateZalcanoHealth();
    }

    private void updateZalcanoStatus() {
        for (NPC npc : this.client.getNpcs()) {
            if (npc.getId() == 9049) {
                if (this.zalcanoState == 9050) {
                    this.throwingHp = 300;
                }
                this.zalcanoState = npc.getId();
            }
            if (npc.getId() != 9050) continue;
            this.zalcanoState = npc.getId();
        }
    }

    private void updateZalcanoHealth() {
        block4: {
            block2: {
                block3: {
                    if (this.hpBarHidden) break block2;
                    if (this.zalcanoState != 9049) break block3;
                    this.throwingHp = this.parseHealthbar(this.hpBar.getText());
                    break block4;
                }
                if (this.zalcanoState != 9050) break block4;
                this.miningHp = this.parseHealthbar(this.hpBar.getText());
                break block4;
            }
            for (NPC npc : this.client.getNpcs()) {
                int healthRatio = npc.getHealthRatio();
                if (healthRatio < 0) continue;
                if (npc.getId() == 9049) {
                    this.throwingHp = healthRatio * 3;
                    continue;
                }
                if (npc.getId() != 9050) continue;
                this.miningHp = healthRatio * 10;
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (npc.getId() == 9049 || npc.getId() == 9050) {
            if (this.zalcanoState == 0) {
                this.shieldDamageDealt = 0;
                this.miningDamageDealt = 0;
                this.miningHp = 1000;
                this.throwingHp = 300;
                this.chanceOfToolSeedTable = 0.0f;
            }
            this.zalcanoState = npc.getId();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (npc.isDead() && npc.getId() == 9050) {
            this.zalcanoState = 0;
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (hitsplatApplied.getHitsplat().isMine() && hitsplatApplied.getActor() instanceof NPC) {
            NPC npc = (NPC)hitsplatApplied.getActor();
            if (npc.getId() == 9049) {
                this.shieldDamageDealt += hitsplatApplied.getHitsplat().getAmount();
            } else if (npc.getId() == 9050) {
                this.miningDamageDealt += hitsplatApplied.getHitsplat().getAmount();
            }
            this.calculateToolSeedTableChances();
        }
    }

    private void calculateToolSeedTableChances() {
        float points = this.miningDamageDealt + this.shieldDamageDealt * 2;
        int cap = 1000;
        if (points > (float)cap) {
            points = cap;
        }
        float contribution = points / 2800.0f;
        this.chanceOfToolSeedTable = contribution / 200.0f;
    }

    private int parseHealthbar(String healthbar) {
        return Integer.parseInt(healthbar.substring(0, healthbar.indexOf("/") - 1));
    }

    private void filterPlayersAtGate(List<Player> players) {
        for (Player p : players) {
            WorldPoint playerLocation = p.getWorldLocation();
            if (this.excludedWorldPoints.contains(playerLocation)) {
                this.playersParticipating.remove(p);
                continue;
            }
            if (this.playersParticipating.contains(p)) continue;
            this.playersParticipating.add(p);
        }
    }

    private void addExcludedWorldPoints() {
        int plane = 0;
        int minExcludedX = 3033;
        int maxExcludedX = 3034;
        int minExcludedY = 6063;
        int maxExcludedY = 6065;
        for (int x = minExcludedX; x <= maxExcludedX; ++x) {
            for (int y = minExcludedY; y <= maxExcludedY; ++y) {
                this.excludedWorldPoints.add(new WorldPoint(x, y, plane));
            }
        }
    }

    @Provides
    ZalcanoConfig provideConfig(ConfigManager configManager) {
        return (ZalcanoConfig)configManager.getConfig(ZalcanoConfig.class);
    }

    public boolean playerInZalcanoArea() {
        return Objects.requireNonNull(this.client.getLocalPlayer()).getWorldLocation().getRegionID() == 12126;
    }

    public int getZalcanoState() {
        return this.zalcanoState;
    }

    public int getThrowingHp() {
        return this.throwingHp;
    }

    public int getMiningHp() {
        return this.miningHp;
    }

    public List<Player> getPlayersParticipating() {
        return this.playersParticipating;
    }

    public int getShieldDamageDealt() {
        return this.shieldDamageDealt;
    }

    public int getMinimumDamageLootShield() {
        Objects.requireNonNull(this);
        return 30;
    }

    public int getMinimumDamageUniquesShield() {
        Objects.requireNonNull(this);
        return 50;
    }

    public int getMiningDamageDealt() {
        return this.miningDamageDealt;
    }

    public int getMinimumDamageLootMining() {
        Objects.requireNonNull(this);
        return 30;
    }

    public int getMinimumDamageUniquesMining() {
        Objects.requireNonNull(this);
        return 50;
    }

    public float getChanceOfToolSeedTable() {
        return this.chanceOfToolSeedTable;
    }
}

