/*
 * Decompiled with CFR 0.152.
 */
package com.zalcano;

import com.zalcano.ZalcanoConfig;
import com.zalcano.ZalcanoPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ZalcanoOverlay
extends OverlayPanel {
    private final Client client;
    private final ZalcanoPlugin plugin;
    private final ZalcanoConfig config;

    @Inject
    private ZalcanoOverlay(Client client, ZalcanoPlugin plugin, ZalcanoConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public String getName() {
        return "ZalcanoUtilityOverlay";
    }

    public Dimension render(Graphics2D graphics2D) {
        if (!this.shouldShowOverlay()) {
            return null;
        }
        this.showTitle();
        if (this.config.showPlayerCount()) {
            this.showPlayerCount();
        }
        if (this.config.showHealth()) {
            this.showHealth();
        }
        if (this.config.showDamageDealt()) {
            this.showDamageDealt();
        }
        if (this.config.showToolSeedCalculations()) {
            this.showToolSeedCalculations();
        }
        return super.render(graphics2D);
    }

    private boolean shouldShowOverlay() {
        return this.plugin.playerInZalcanoArea();
    }

    private void showTitle() {
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Zalcano").build());
    }

    private void showPlayerCount() {
        int playercount = this.plugin.getPlayersParticipating().size();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Players: " + playercount).build());
    }

    private void showHealth() {
        int firstPhaseHealth = 640;
        int secondPhaseHealth = 360;
        int miningHp = this.plugin.getMiningHp();
        int phase = miningHp > firstPhaseHealth ? 1 : (miningHp > secondPhaseHealth ? 2 : 3);
        Color color = this.decideColorBasedOnThreshold(miningHp, firstPhaseHealth, secondPhaseHealth);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Mining HP:  " + miningHp + " / 1000 (Phase: " + phase + ")").leftColor(color).build());
        if (this.plugin.getZalcanoState() == 9049) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Throwing HP:  " + this.plugin.getThrowingHp() + " / 300").build());
        }
    }

    private void showDamageDealt() {
        Color color = this.decideColorBasedOnThreshold(this.plugin.getShieldDamageDealt(), this.plugin.getMinimumDamageUniquesShield(), this.plugin.getMinimumDamageLootShield());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Shield Damage dealt: " + this.plugin.getShieldDamageDealt() + " / " + this.plugin.getMinimumDamageUniquesShield()).leftColor(color).build());
        color = this.decideColorBasedOnThreshold(this.plugin.getMiningDamageDealt(), this.plugin.getMinimumDamageUniquesMining(), this.plugin.getMinimumDamageLootMining());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Mining Damage dealt: " + this.plugin.getMiningDamageDealt() + " / " + this.plugin.getMinimumDamageUniquesMining()).leftColor(color).build());
    }

    private Color decideColorBasedOnThreshold(int damage, int greenThreshold, int yellowThreshold) {
        if (damage >= greenThreshold) {
            return Color.GREEN;
        }
        if (damage > yellowThreshold) {
            return Color.YELLOW;
        }
        return Color.RED;
    }

    private void showToolSeedCalculations() {
        this.panelComponent.getChildren().add(LineComponent.builder().left("Chance of tool seed: " + String.format("%.3g", Float.valueOf(this.plugin.getChanceOfToolSeedTable() * 100.0f)) + "%").build());
    }
}

