/*
 * Decompiled with CFR 0.152.
 */
package com.compost;

import com.compost.DidICompostConfig;
import com.compost.DidICompostPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ImageUtil;

public class PatchOverlay
extends Overlay {
    private final Client client;
    private final DidICompostPlugin plugin;
    private final DidICompostConfig config;
    public List<WorldPoint> worldPoints = new ArrayList<WorldPoint>();
    Color defaultColor = Color.RED;

    public List<WorldPoint> getWorldPoints() {
        return this.worldPoints;
    }

    public void setWorldPoints(List<WorldPoint> worldPoints) {
        this.worldPoints = worldPoints;
    }

    @Inject
    private PatchOverlay(Client client, DidICompostConfig config, DidICompostPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (int i = 0; i < this.worldPoints.size(); ++i) {
            try {
                this.drawBucket(graphics, this.worldPoints.get(i));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void drawBucket(Graphics2D graphics, WorldPoint worldPoint) throws IOException {
        if (worldPoint.getPlane() != this.client.getPlane()) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        BufferedImage img = ImageUtil.loadImageResource(DidICompostPlugin.class, (String)"/Bottomless_compost_bucket.png");
        Point point = this.XYToPoint(worldPoint.getX(), worldPoint.getY(), worldPoint.getPlane());
        graphics.drawImage((Image)img, point.getX(), point.getY(), null);
    }

    private Point XYToPoint(int x, int y, int z) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (int)x, (int)y);
        if (localPoint == null) {
            return null;
        }
        return Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)z);
    }
}

