/*
 * Decompiled with CFR 0.152.
 */
package com.compost;

import com.compost.DidICompostConfig;
import com.compost.FarmingPatches;
import com.compost.PatchOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.ObjectComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Did I Compost?")
public class DidICompostPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DidICompostPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DidICompostConfig config;
    @Inject
    private PatchOverlay patchOverlay;
    @Inject
    private OverlayManager overlayManager;
    private static final Pattern COMPOST_USED_ON_PATCH = Pattern.compile("You treat the .+ with (?<compostType>ultra|super|)compost\\.");
    private static final Pattern FERTILE_SOIL_CAST = Pattern.compile("^The .+ has been treated with (?<compostType>ultra|super|)compost");
    private static final Pattern ALREADY_TREATED = Pattern.compile("This .+ has already been (treated|fertilised) with (?<compostType>ultra|super|)compost(?: - the spell can't make it any more fertile)?\\.");
    private static final Pattern INSPECT_PATCH = Pattern.compile("This is an? .+\\. The soil has been treated with (?<compostType>ultra|super|)compost\\..*");
    private static final Pattern INSPECT_PATCH_NONE = Pattern.compile("This is an? .+\\. The soil has not been treated.*");
    private static final Pattern CLEAR_HERB = Pattern.compile("The herb patch is now empty.*");
    private static final Pattern CLEAR_PATCH = Pattern.compile("You have successfully cleared this patch for new crops.*");
    private static final Pattern CLEAR_TREE = Pattern.compile("You examine the tree for signs of disease and find that it is in perfect health.*");
    private static final Pattern CLEAR_ALLOTMENT = Pattern.compile("The allotment is now empty.*");
    private static final Pattern CLEAR_SEAWEED = Pattern.compile("You pick some giant seaweed.*");
    private static final Pattern CLEAR_BELLA = Pattern.compile("You pick some deadly nightshade.*");
    private static final Pattern CLEAR_MUSHROOM = Pattern.compile("You pick a Bittercap mushroom.*");
    private static final ImmutableSet<Integer> COMPOST_ITEMS = ImmutableSet.of((Object)6032, (Object)6034, (Object)21483, (Object)22997);
    private static final ArrayList<Integer> compostIds = new ArrayList<Integer>(Arrays.asList(6032, 6034, 21483, 22997));
    int currentPatch = 0;

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuClicked) {
        Widget w;
        Boolean isCompost = false;
        MenuAction action = menuClicked.getMenuAction();
        if (action == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT && (w = this.client.getSelectedWidget()) != null) {
            if (compostIds.contains(w.getItemId())) {
                isCompost = true;
            }
            if (w.getId() == WidgetInfo.SPELL_LUNAR_FERTILE_SOIL.getPackedId()) {
                isCompost = true;
            }
        }
        if (action == MenuAction.GAME_OBJECT_FIFTH_OPTION) {
            isCompost = "Inspect".equals(menuClicked.getMenuOption());
        }
        ObjectComposition patchDef = this.client.getObjectDefinition(menuClicked.getId());
        for (int i = 0; i < FarmingPatches.values().length; ++i) {
            if (FarmingPatches.values()[i].patchId != patchDef.getId()) continue;
            this.currentPatch = patchDef.getId();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        String messageString = message.getMessage();
        String compostType = "";
        Matcher matcher = COMPOST_USED_ON_PATCH.matcher(messageString);
        if (matcher.matches() || (matcher = FERTILE_SOIL_CAST.matcher(messageString)).find() || (matcher = ALREADY_TREATED.matcher(messageString)).matches() || (matcher = INSPECT_PATCH.matcher(messageString)).matches()) {
            String compostGroup;
            switch (compostGroup = matcher.group("compostType")) {
                case "ultra": {
                    compostType = "ultra";
                    break;
                }
                case "super": {
                    compostType = "super";
                    break;
                }
                default: {
                    compostType = "compost";
                }
            }
        }
        if (compostType == "ultra" || compostType == "super" || compostType == "compost") {
            this.addPatch(this.currentPatch);
        }
        if ((matcher = CLEAR_PATCH.matcher(messageString)).matches() || (matcher = CLEAR_HERB.matcher(messageString)).matches() || (matcher = CLEAR_TREE.matcher(messageString)).matches() || (matcher = INSPECT_PATCH_NONE.matcher(messageString)).matches() || (matcher = CLEAR_ALLOTMENT.matcher(messageString)).matches() || (matcher = CLEAR_SEAWEED.matcher(messageString)).matches() || (matcher = CLEAR_MUSHROOM.matcher(messageString)).matches() || (matcher = CLEAR_BELLA.matcher(messageString)).matches()) {
            this.deletePatch(this.currentPatch);
        }
    }

    public void addPatch(int currentPatch) {
        FarmingPatches newPatch = FarmingPatches.fromPatchId(currentPatch);
        if (newPatch != null) {
            List<WorldPoint> currentTiles = this.patchOverlay.getWorldPoints();
            currentTiles.add(newPatch.tile);
            this.patchOverlay.setWorldPoints(currentTiles);
        }
    }

    public void deletePatch(int currentPatch) {
        FarmingPatches oldPatch = FarmingPatches.fromPatchId(currentPatch);
        if (oldPatch != null) {
            List<WorldPoint> currentTiles = this.patchOverlay.getWorldPoints();
            for (int i = 0; i < currentTiles.size(); ++i) {
                if (currentTiles.get(i) != oldPatch.tile) continue;
                currentTiles.remove(i);
            }
            this.patchOverlay.setWorldPoints(currentTiles);
        }
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.patchOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.patchOverlay);
    }

    @Provides
    DidICompostConfig provideConfig(ConfigManager configManager) {
        return (DidICompostConfig)configManager.getConfig(DidICompostConfig.class);
    }
}

